/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u0014\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0005H\u0007\u001a\"\u0010\u001a\u001a\u00020\u00172\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007\u001a\u001c\u0010\u001e\u001a\u00020\u00172\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\n\u001a\u00020\u0005H\u0003\u001a\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006%"}, d2={"getQualifiedNameAndTemplateHeader", "Lcom/jetbrains/cidr/lang/generate/FunctionQualifiedNameInfo;", "function", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "psiContext", "Lcom/intellij/psi/PsiElement;", "toParts", "", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName;", "symbol", "context", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "getScopeSymbol", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol;", "reduceQualifiers", "target", "scope", "isFriendFunctionInProperNamespace", "", "isResolved", "fromQualifiers", "quals", "makeTemplateParameters", "", "t", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCTemplateSymbol;", "makeTemplateHeader", "s", "symbols", "Lcom/jetbrains/cidr/lang/symbols/OCTypeParameterSymbol;", "getTemplateVar", "getRequiresClause", "Lcom/jetbrains/cidr/lang/psi/OCRequiresClause;", "structSym", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nOCCppGeneratedQualifiedFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCCppGeneratedQualifiedFunction.kt\ncom/jetbrains/cidr/lang/generate/OCCppGeneratedQualifiedFunctionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1563#2:144\n1634#2,3:145\n*S KotlinDebug\n*F\n+ 1 OCCppGeneratedQualifiedFunction.kt\ncom/jetbrains/cidr/lang/generate/OCCppGeneratedQualifiedFunctionKt\n*L\n120#1:144\n120#1:145,3\n*E\n"})
public final class OCCppGeneratedQualifiedFunctionKt {
    @NotNull
    public static final FunctionQualifiedNameInfo getQualifiedNameAndTemplateHeader(@NotNull OCFunctionSymbol function, @NotNull PsiElement psiContext) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)psiContext, (String)"psiContext");
        OCResolveContext oCResolveContext = OCResolveContext.forPsi(psiContext);
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forPsi(...)");
        OCResolveContext context = oCResolveContext;
        List<OCSymbolWithQualifiedName> result = OCCppGeneratedQualifiedFunctionKt.reduceQualifiers(OCCppGeneratedQualifiedFunctionKt.toParts(function, context), OCCppGeneratedQualifiedFunctionKt.getScopeSymbol(psiContext), context);
        return OCCppGeneratedQualifiedFunctionKt.fromQualifiers(result, psiContext);
    }

    private static final List<OCSymbolWithQualifiedName> toParts(OCSymbolWithQualifiedName symbol, OCResolveContext context) {
        List res = new ArrayList();
        for (OCSymbolWithQualifiedName cur = symbol; cur != null; cur = cur.getResolvedOwner(context, false)) {
            res.add(cur);
        }
        return CollectionsKt.reversed((Iterable)res);
    }

    private static final OCNamespaceSymbol getScopeSymbol(PsiElement context) {
        Class[] classArray = new Class[]{OCStruct.class, OCCppNamespace.class, OCFile.class};
        PsiElement scopePSI = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])classArray);
        return scopePSI instanceof OCSymbolDeclarator ? (OCNamespaceSymbol)((OCSymbolDeclarator)scopePSI).getSymbol() : null;
    }

    private static final List<OCSymbolWithQualifiedName> reduceQualifiers(List<? extends OCSymbolWithQualifiedName> target, OCNamespaceSymbol scope, OCResolveContext context) {
        for (int i = target.size() - 1; -1 < i; --i) {
            if (!OCCppGeneratedQualifiedFunctionKt.isResolved(target.get(i), scope, context) && !OCCppGeneratedQualifiedFunctionKt.isFriendFunctionInProperNamespace(target.get(i), scope, context)) continue;
            return target.subList(i, target.size());
        }
        return target;
    }

    private static final boolean isFriendFunctionInProperNamespace(OCSymbolWithQualifiedName symbol, OCNamespaceSymbol scope, OCResolveContext context) {
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriend()) {
            if (scope == null) {
                return ((OCFunctionSymbol)symbol).getQualifierParent() == null;
            }
            return scope.isSameSymbol(((OCFunctionSymbol)symbol).getQualifierParent(), context);
        }
        return false;
    }

    private static final boolean isResolved(OCSymbolWithQualifiedName target, OCNamespaceSymbol scope, OCResolveContext context) {
        OCNamespaceSymbol oCNamespaceSymbol = scope;
        List<OCSymbol> list = OCSymbolReference.getGlobalReference(OCQualifiedName.with(target.getName()), scope, (VirtualFile)(oCNamespaceSymbol != null ? oCNamespaceSymbol.getContainingFile() : null), -1L).resolveToSymbols(context);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveToSymbols(...)");
        List<OCSymbol> symbols = list;
        return !((Collection)symbols).isEmpty() && target.isSameSymbol((OCSymbol)CollectionsKt.first(symbols), context.getProject());
    }

    private static final FunctionQualifiedNameInfo fromQualifiers(List<? extends OCSymbolWithQualifiedName> quals, PsiElement context) {
        StringBuilder qualifiedName = new StringBuilder();
        StringBuilder templateHeader = new StringBuilder();
        for (OCSymbolWithQualifiedName oCSymbolWithQualifiedName : quals) {
            boolean functionItself = oCSymbolWithQualifiedName instanceof OCFunctionSymbol;
            qualifiedName.append(oCSymbolWithQualifiedName.getName());
            if (oCSymbolWithQualifiedName instanceof OCTemplateSymbol) {
                OCTemplateSymbol oCTemplateSymbol = (OCTemplateSymbol)((Object)oCSymbolWithQualifiedName);
                OCResolveContext oCResolveContext = OCResolveContext.forPsi(context);
                Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forPsi(...)");
                qualifiedName.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateParameters(oCTemplateSymbol, oCResolveContext));
                templateHeader.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader((OCTemplateSymbol)((Object)oCSymbolWithQualifiedName), context));
                if (oCSymbolWithQualifiedName instanceof OCStructSymbol) {
                    OCStructSymbol oCStructSymbol = (OCStructSymbol)oCSymbolWithQualifiedName;
                    Project project = context.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (OCCppGeneratedQualifiedFunctionKt.getRequiresClause(oCStructSymbol, project) != null) {
                        OCRequiresClause it;
                        boolean bl = false;
                        templateHeader.append(it.getText());
                    }
                }
            }
            if (functionItself) continue;
            qualifiedName.append("::");
        }
        String string = qualifiedName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = templateHeader.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new FunctionQualifiedNameInfo(string, string2);
    }

    private static final String makeTemplateParameters(OCTemplateSymbol t, OCResolveContext context) {
        List<OCTypeArgument> spec = t.getTemplateSpecialization();
        List<OCTypeParameterSymbol> list = t.getTemplateParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTemplateParameters(...)");
        List<OCTypeParameterSymbol> params = list;
        if (spec != null) {
            return "<" + CollectionsKt.joinToString$default((Iterable)spec, (CharSequence)", ", null, null, (int)0, null, arg_0 -> OCCppGeneratedQualifiedFunctionKt.makeTemplateParameters$lambda$0(context, arg_0), (int)30, null) + ">";
        }
        if (!params.isEmpty() && !(t instanceof OCFunctionSymbol)) {
            return "<" + CollectionsKt.joinToString$default((Iterable)params, (CharSequence)", ", null, null, (int)0, null, OCCppGeneratedQualifiedFunctionKt::makeTemplateParameters$lambda$1, (int)30, null) + ">";
        }
        return "";
    }

    @NlsSafe
    @NotNull
    public static final String makeTemplateHeader(@NotNull OCTemplateSymbol s, @NotNull PsiElement context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!s.isTemplateSymbol() || s instanceof OCStructSymbol && ((OCStructSymbol)s).getTemplateParameters().isEmpty())) {
            List<OCTypeParameterSymbol> list = s.getTemplateParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTemplateParameters(...)");
            object = OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(list, context) + "\n";
        } else {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public static final String makeTemplateHeader(@NotNull List<? extends OCTypeParameterSymbol<?>> symbols, @NotNull PsiElement context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = symbols;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OCTypeParameterSymbol oCTypeParameterSymbol = (OCTypeParameterSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OCCppGeneratedQualifiedFunctionKt.getTemplateVar(it, context));
        }
        return "template<" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ">";
    }

    @NlsSafe
    private static final String getTemplateVar(OCTypeParameterSymbol<?> s, PsiElement context) {
        Object object;
        OCResolveContext oCResolveContext = OCResolveContext.forPsi(context);
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forPsi(...)");
        OCResolveContext resolveContext = oCResolveContext;
        OCTypeParameterSymbol<?> oCTypeParameterSymbol = s;
        if (oCTypeParameterSymbol instanceof OCTypeParameterTypeSymbol) {
            String string;
            if (((OCTypeParameterTypeSymbol)s).isConstrained()) {
                OCQualifiedName oCQualifiedName = ((OCTypeParameterTypeSymbol)s).getConstraintName();
                Intrinsics.checkNotNull((Object)oCQualifiedName);
                string = oCQualifiedName.getFullName(resolveContext);
            } else {
                string = ((OCTypeParameterTypeSymbol)s).isSpelledWithTypenameKeyword() ? "typename" : "class";
            }
            object = string + (((OCTypeParameterTypeSymbol)s).isVariadic() ? "..." : "") + (String)(Intrinsics.areEqual((Object)((OCTypeParameterTypeSymbol)s).getName(), (Object)"<unnamed>") || Intrinsics.areEqual((Object)((OCTypeParameterTypeSymbol)s).getName(), (Object)"") ? "" : " " + ((OCTypeParameterTypeSymbol)s).getName());
        } else if (oCTypeParameterSymbol instanceof OCTypeParameterValueSymbol) {
            String string = OCElementFactory.declarationText(((OCTypeParameterValueSymbol)s).getName(), ((OCTypeParameterValueSymbol)s).getType(), null, null, context);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declarationText(...)");
        } else {
            OCLog.LOG.error("Template parameter is not a type nor value");
            object = "UNKNOWN";
        }
        return object;
    }

    private static final OCRequiresClause getRequiresClause(OCStructSymbol structSym, Project project) {
        PsiElement psiElement = structSym.locateDefinition(project);
        OCStruct oCStruct = psiElement instanceof OCStruct ? (OCStruct)psiElement : null;
        if (oCStruct == null) {
            return null;
        }
        OCStruct structDef = oCStruct;
        return structDef.getRequiresClause();
    }

    private static final CharSequence makeTemplateParameters$lambda$0(OCResolveContext $context, OCTypeArgument it) {
        String string = it.getNameForPresentation(OCType.Presentation.BEST, $context, false, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameForPresentation(...)");
        return string;
    }

    private static final CharSequence makeTemplateParameters$lambda$1(OCTypeParameterSymbol it) {
        return it.getName() + (it.isVariadic() ? "..." : "");
    }
}

