/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCGlobalFormatterData;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OCNormalIndentBlock
extends OCCodeBlock {
    OCNormalIndentBlock(@Nullable OCCodeBlock parent, @NotNull CommonCodeStyleSettings settings, @NotNull OCCodeStyleSettings ocSettings, @NotNull Project project, @NotNull ASTNode node, @NotNull OCGlobalFormatterData globalFormatterData, @Nullable Indent indent, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable Alignment alignment) {
        if (settings == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(0);
        }
        if (ocSettings == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(2);
        }
        if (node == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(3);
        }
        if (globalFormatterData == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(4);
        }
        super(parent, settings, ocSettings, project, node, globalFormatterData, indent, childIndent, wrap, alignment);
    }

    @Override
    @Nullable
    protected Indent calcChildIndentBase(@NotNull IElementType thisType, @NotNull ASTNode child, @NotNull IElementType childType) {
        PsiElement ifPsi;
        if (thisType == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(5);
        }
        if (child == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(6);
        }
        if (childType == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(7);
        }
        if (OCFormatterUtil.isStructureOrNamespace(thisType) && childType == OCLexerTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.isControlSection(childType)) {
            return Indent.getNoneIndent();
        }
        OCFormatterUtil.LABEL_TYPE labelType = OCFormatterUtil.getLabelType(this.myNode);
        if (OCFormatterUtil.getLabelType(child) == OCFormatterUtil.LABEL_TYPE.LABEL_LIKE) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.getLabelType(child) == OCFormatterUtil.LABEL_TYPE.CASE_LIKE) {
            return labelType != OCFormatterUtil.LABEL_TYPE.OTHER ? Indent.getNoneIndent() : this.getIndentInsideSwitch(true);
        }
        if (OCFormatterUtil.isDirectlyInsideSwitch(child) && (FormatterUtil.hasPrecedingSiblingOfType((ASTNode)child, (IElementType)OCElementTypes.CASE_STATEMENT, (IElementType[])new IElementType[0]) || FormatterUtil.hasPrecedingSiblingOfType((ASTNode)child, (IElementType)OCElementTypes.LABELED_STATEMENT, (IElementType[])new IElementType[0]))) {
            return this.getIndentInsideSwitch(false);
        }
        if (labelType == OCFormatterUtil.LABEL_TYPE.LABEL_LIKE && this.myNode.getPsi() instanceof OCLabeledStatement) {
            return ((OCLabeledStatement)this.myNode.getPsi()).getLabelElement() == child.getPsi() ? (this.mySettings.getIndentOptions().LABEL_INDENT_ABSOLUTE ? Indent.getAbsoluteLabelIndent() : OCNormalIndentBlock.getSpaceIndentEnforcedToChildren(this.mySettings.getIndentOptions().INDENT_SIZE + this.mySettings.getIndentOptions().LABEL_INDENT_SIZE)) : Indent.getNormalIndent();
        }
        if (labelType == OCFormatterUtil.LABEL_TYPE.CASE_LIKE) {
            return child.getTreePrev() == null || OCFormatterUtil.isBlock(childType) ? Indent.getNoneIndent() : this.myChildIndent;
        }
        if (thisType == OCElementTypes.IF_STATEMENT && childType == OCElementTypes.IF_STATEMENT && this.mySettings.SPECIAL_ELSE_IF_TREATMENT && (ifPsi = this.myNode.getPsi()) instanceof OCIfStatement && ((OCIfStatement)ifPsi).getElseBranch() == child.getPsi()) {
            return Indent.getNoneIndent();
        }
        if (!OCFormatterUtil.isBlock(thisType) && OCFormatterUtil.isKeyword(child) && !OCFormatterUtil.isInsideAnyBraces(child)) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.isControlStatement(thisType) && OCElementTypes.STATEMENTS.contains(childType) && !OCFormatterUtil.isBlock(childType) && (OCElementTypes.FOR_STATEMENT != thisType || OCFormatterUtil.isPrecededBy(child, (IElementType)OCLexerTokenTypes.RPAR))) {
            return this.myChildIndent;
        }
        if (OCFormatterUtil.isBlock(childType)) {
            return OCFormatterUtil.isBlock(thisType) ? this.myChildIndent : Indent.getNoneIndent();
        }
        if (child.getTreePrev() == null) {
            return Indent.getNoneIndent();
        }
        return OCNormalIndentBlock.isInsideBraces(thisType, child) || OCLexerTokenTypes.COMMENTS.contains(childType) ? this.myChildIndent : Indent.getContinuationIndent();
    }

    private Indent getIndentInsideSwitch(boolean caseIndent) {
        if (this.mySettings.INDENT_CASE_FROM_SWITCH) {
            return caseIndent ? this.myChildIndent : OCNormalIndentBlock.getDoubleIndent(this.mySettings);
        }
        return caseIndent ? Indent.getNoneIndent() : this.myChildIndent;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent indent = this.myChildIndent;
        ASTNode prevNode = OCSimpleBlock.extractLastNode((Block)this.getSubBlocks().get(newChildIndex - 1));
        IElementType prevType = OCElementUtil.getElementType(prevNode);
        if (OCElementUtil.getElementType(this.myNode.getTreeParent()) == OCElementTypes.SWITCH_STATEMENT) {
            ASTNode lastChildNode;
            boolean isCase;
            boolean bl = isCase = prevType == OCLexerTokenTypes.LBRACE;
            if ((prevType == OCElementTypes.CASE_STATEMENT || prevType == OCElementTypes.LABELED_STATEMENT) && (lastChildNode = prevNode.getLastChildNode()) != null) {
                IElementType lastChildType = lastChildNode.getElementType();
                isCase = OCFormatterUtil.isBlock(lastChildType) || lastChildType == OCElementTypes.RETURN_STATEMENT || lastChildType == OCElementTypes.BREAK_STATEMENT;
            }
            indent = this.getIndentInsideSwitch(isCase);
        } else if (this.myNode.getElementType() == OCElementTypes.DO_WHILE_STATEMENT && OCElementTypes.STATEMENTS.contains(prevType)) {
            indent = Indent.getNoneIndent();
        }
        return new ChildAttributes(indent, null);
    }

    private static boolean isInsideBraces(@NotNull IElementType thisType, @NotNull ASTNode child) {
        if (thisType == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(8);
        }
        if (child == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(9);
        }
        return OCElementTypes.BLOCK_STATEMENTS.contains(thisType) || thisType == OCElementTypes.INSTANCE_VARIABLES_LIST || OCFormatterUtil.isStructureOrNamespace(thisType) && OCNormalIndentBlock.hasEarlierLBraceSibling(child);
    }

    private static boolean hasEarlierLBraceSibling(@NotNull ASTNode start) {
        ASTNode parent;
        if (start == null) {
            OCNormalIndentBlock.$$$reportNull$$$0(10);
        }
        if ((parent = start.getTreeParent()) == null) {
            return TreeUtil.findSiblingBackward((ASTNode)start, (IElementType)OCLexerTokenTypes.LBRACE) != null;
        }
        for (ASTNode child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child == start) {
                return false;
            }
            if (child.getElementType() != OCLexerTokenTypes.LBRACE) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalFormatterData";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "calcChildIndentBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideBraces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEarlierLBraceSibling";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

