/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.surround.OCExpressionSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class OCTextExpressionSurrounder
extends OCExpressionSurrounder {
    @Override
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull OCExpression expr) throws IncorrectOperationException {
        if (project == null) {
            OCTextExpressionSurrounder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCTextExpressionSurrounder.$$$reportNull$$$0(1);
        }
        if (expr == null) {
            OCTextExpressionSurrounder.$$$reportNull$$$0(2);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        String surroundText = this.getBeforeText() + expr.getTextWithMacros() + this.getAfterText();
        OCExpression element = OCElementFactory.expressionFromText(surroundText, expr);
        if (element == null) {
            OCLog.LOG.error("wrong surround: ", new String[]{surroundText});
        } else {
            PsiElement reformatedExpr = codeStyleManager.reformat((PsiElement)element);
            if (!(reformatedExpr instanceof OCExpression)) {
                OCLog.LOG.error("wrong expression after format: ", new String[]{reformatedExpr.getText()});
            } else {
                expr = (OCExpression)expr.replace(reformatedExpr);
            }
        }
        int offset = expr.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    @NotNull
    @NonNls
    protected abstract String getBeforeText();

    @NotNull
    @NonNls
    protected abstract String getAfterText();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expr";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/surround/OCTextExpressionSurrounder";
        objectArray[2] = "surroundExpression";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

