/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCClassNameMacro
extends Macro {
    @NlsSafe
    public static final String MACRO_NAME = "className";

    public String getName() {
        return MACRO_NAME;
    }

    @NotNull
    public String getDefaultValue() {
        return "NSObject";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        OCStructSymbol structSymbol;
        PsiElement place;
        OCStruct structExpr;
        OCClassSymbol symbol;
        if (params == null) {
            OCClassNameMacro.$$$reportNull$$$0(0);
        }
        if ((symbol = OCClassNameMacro.getExpectedSymbol(context)) == null && (structExpr = (OCStruct)PsiTreeUtil.getParentOfType((PsiElement)(place = OCTemplatesUtil.getInsertionPlace(context)), OCStruct.class)) != null && (structSymbol = (OCStructSymbol)structExpr.getSymbol()) != null) {
            return new TextResult(structSymbol.getName());
        }
        return symbol != null ? new TextResult(symbol.getName()) : null;
    }

    @Nullable
    private static OCClassSymbol getExpectedSymbol(ExpressionContext context) {
        OCType type;
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        OCSendMessageExpression expression = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)place, OCSendMessageExpression.class);
        expression = expression != null && expression.getParent() instanceof OCSendMessageExpression ? (OCSendMessageExpression)expression.getParent() : null;
        OCResolveContext resolveContext = OCResolveContext.forPsi(place);
        OCType oCType = type = expression != null ? OCExpectedTypeUtil.getExpectedType((OCExpression)expression, resolveContext).resolve(resolveContext) : null;
        if (type instanceof OCPointerType && type.isPointerToObject()) {
            return ((OCObjectType)type.getTerminalType()).getClassSymbol();
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            OCClassNameMacro.$$$reportNull$$$0(1);
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
        HashSet names = new HashSet();
        ArrayList<LookupElementBuilder> answer = new ArrayList<LookupElementBuilder>();
        if (file instanceof OCFile) {
            OCClassSymbol expectedSymbol = OCClassNameMacro.getExpectedSymbol(context);
            if (expectedSymbol != null) {
                answer.add(SymbolLookupBuilderUtil.lookup(expectedSymbol, context.getProject()).withInsertHandler(null));
            }
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(file.getProject(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCInterfaceSymbol && !symbol.isPredeclaration() && symbol != expectedSymbol && ((OCInterfaceSymbol)symbol).getCategoryName() == null && names.add(symbol.getName())) {
                    answer.add(SymbolLookupBuilderUtil.lookup(symbol, context.getProject()).withInsertHandler(null));
                }
                return true;
            }), null);
            return answer.toArray(LookupElement.EMPTY_ARRAY);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCClassNameMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

