/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import org.jetbrains.annotations.NotNull;

public final class OCResourceCompletionContributor
extends OCCompletionContributorBase {
    public OCResourceCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                String customPrefix;
                PsiElement expression;
                PsiElement element;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((element = parameters.getRealPosition().getParent()) instanceof OCReferenceElement) {
                    expression = element.getParent();
                    customPrefix = null;
                } else if (element instanceof OCLiteralExpression && ((OCLiteralExpression)element).getTextWithMacros().startsWith("@\"")) {
                    expression = element;
                    customPrefix = parameters.getOffset() > element.getTextOffset() ? ((OCLiteralExpression)element).getTextWithMacros().substring(2, parameters.getOffset() - element.getTextOffset()) : null;
                } else {
                    expression = null;
                    customPrefix = null;
                }
                if (expression != null) {
                    @NotNull @NlsSafe String openingQuote = customPrefix == null ? "@\"" : "";
                    @NotNull @NlsSafe String closingQuote = customPrefix == null ? "\"" : "";
                    CompletionResultSet wrappedResult = customPrefix != null ? result.withPrefixMatcher(customPrefix) : result;
                    OCResourceReferenceContributor.processReferenceProviders((Processor<OCResourceCompletionProvider>)((Processor)provider1 -> {
                        for (PsiReference reference : provider1.getReferencesByElement(expression, new ProcessingContext())) {
                            for (LookupElement variant : ((OCResourceReference)reference).getLookupElements(openingQuote, closingQuote)) {
                                wrappedResult.caseInsensitive().addElement(OCCompletionPriority.elementWithPriority(variant, OCCompletionPriority.HIGHEST_PRIORITY));
                            }
                        }
                        return true;
                    }));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCResourceCompletionContributor$1", "addCompletions"));
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider2);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider2);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider2);
    }
}

