/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.NameSuggestionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class OCNameSuggestionContributor
extends OCCompletionContributorBase
implements NameSuggestionContributor {
    public static final OCCompletionPriority PRIORITY = OCCompletionPriority.HIGH_KEYWORDS_PRIORITY;
    @NonNls
    private static final String SELF = "self";
    @NonNls
    private static final String SUPER = "super";

    public OCNameSuggestionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_DECLARATION, new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                OCDeclarator declarator = (OCDeclarator)parameters.getPosition().getParent();
                OCTypeElement typeElement = null;
                if (declarator.getParent() instanceof OCDeclaration && ((typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement()) == null || typeElement.isEmpty())) {
                    return;
                }
                OCType type = declarator.getResolvedType();
                if (type instanceof OCReferenceType) {
                    List<OCSymbol> symbols = ((OCReferenceType)type).getReference(declarator.getContainingFile()).resolveToSymbols(OCResolveContext.forPsi((PsiElement)parameters.getOriginalFile()));
                    String name = type.getName();
                    if (!symbols.isEmpty() || OCNameSuggestionContributor.SELF.equals(name) || OCNameSuggestionContributor.SUPER.equals(name)) {
                        OCExpression expression = OCElementFactory.expressionFromText(name, declarator, false);
                        MethodSelectorCompletionContributor.addCompletionsForReceiver(expression, "", parameters, result, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        return;
                    }
                }
                if (type instanceof OCObjectType) {
                    if (typeElement != null) {
                        OCObjectTypeContext typeContext = new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type, type);
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context("", typeElement, typeContext, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        MethodSelectorCompletionContributor.addCompletionForReceiverContext(parameters, result, ctx);
                    }
                } else {
                    String originalName = declarator.getName();
                    int fakePartIndex = originalName.lastIndexOf("CIDR_RULE_ZZZ");
                    if (fakePartIndex >= 0) {
                        originalName = originalName.substring(0, fakePartIndex);
                    }
                    List<String> predefinedNames = originalName.isEmpty() ? Collections.emptyList() : Collections.singletonList(originalName);
                    for (String name : OCNameSuggester.suggestForDeclaration(declarator, true, predefinedNames)) {
                        result.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$1", "addCompletions"));
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement((IElementType)OCLexerTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class), new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PsiElement ident;
                OCMethodSelectorPart declarator;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((declarator = (OCMethodSelectorPart)(ident = parameters.getPosition()).getParent()).getParameter() == ident) {
                    OCResolveContext resolveContext = OCResolveContext.forPsi(ident);
                    OCType type = declarator.getType().resolve(resolveContext);
                    for (String name : OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, type, ident, "", Collections.emptyList(), resolveContext)) {
                        result.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$2", "addCompletions"));
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_CLASS_DECLARATION, new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                PsiElement element = parameters.getPosition().getParent();
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(element.getProject(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                    if (symbol instanceof OCClassSymbol && element instanceof OCProtocol == symbol instanceof OCProtocolSymbol) {
                        result.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)symbol.getName()), PRIORITY));
                    }
                    return true;
                }), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$3", "addCompletions"));
            }
        });
    }
}

