/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCodeContextType
extends TemplateContextType {
    @NotNull
    protected final OCLanguageKind myNeedKind;

    protected OCCodeContextType(@NotNull OCLanguageKind needKind, @NotNull @NonNls String id, @NlsContexts.Label @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (needKind == null) {
            OCCodeContextType.$$$reportNull$$$0(0);
        }
        if (id == null) {
            OCCodeContextType.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            OCCodeContextType.$$$reportNull$$$0(2);
        }
        super(id, presentableName, baseContextType);
        this.myNeedKind = needKind;
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        PsiFile file;
        if (templateActionContext == null) {
            OCCodeContextType.$$$reportNull$$$0(3);
        }
        if (!((file = templateActionContext.getFile()) instanceof OCFile) || !FileSymbolTablesCache.getInstance(file.getProject()).areSymbolsLoaded()) {
            return false;
        }
        if (((OCFile)file).getKind().conforms(this.myNeedKind)) {
            PsiElement element = file.findElementAt(templateActionContext.getStartOffset());
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected boolean isInContext(@NotNull PsiElement element) {
        if (element == null) {
            OCCodeContextType.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new OCFileHighlighter(OCLexerSettings.forLanguage((OCLanguageKind)this.myNeedKind).forHighlighting().build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class LanguageInfo {
        private static final Map<OCLanguageKind, LanguageInfo> LANGUAGE_INFO = new HashMap<OCLanguageKind, LanguageInfo>(3);
        @NotNull
        @NonNls
        private final String languageContextName;
        @NotNull
        private final String languageSuffixName;
        @NotNull
        private final Class<? extends LanguageBase> baseContextType;

        private LanguageInfo(@NotNull @NonNls String context, @NotNull @NonNls String suffix, @NotNull Class<? extends LanguageBase> baseClass) {
            if (context == null) {
                LanguageInfo.$$$reportNull$$$0(0);
            }
            if (suffix == null) {
                LanguageInfo.$$$reportNull$$$0(1);
            }
            if (baseClass == null) {
                LanguageInfo.$$$reportNull$$$0(2);
            }
            this.languageContextName = context;
            this.languageSuffixName = suffix;
            this.baseContextType = baseClass;
        }

        @NotNull
        @NonNls
        public static String getContextName(@NotNull OCLanguageKind kind) {
            if (kind == null) {
                LanguageInfo.$$$reportNull$$$0(3);
            }
            String string = LanguageInfo.LANGUAGE_INFO.get((Object)kind).languageContextName;
            if (string == null) {
                LanguageInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public static String getSuffix(@NotNull OCLanguageKind kind) {
            if (kind == null) {
                LanguageInfo.$$$reportNull$$$0(5);
            }
            String string = LanguageInfo.LANGUAGE_INFO.get((Object)kind).languageSuffixName;
            if (string == null) {
                LanguageInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public static Class<? extends LanguageBase> getBaseContext(@NotNull OCLanguageKind kind) {
            if (kind == null) {
                LanguageInfo.$$$reportNull$$$0(7);
            }
            Class<? extends LanguageBase> clazz = LanguageInfo.LANGUAGE_INFO.get((Object)kind).baseContextType;
            if (clazz == null) {
                LanguageInfo.$$$reportNull$$$0(8);
            }
            return clazz;
        }

        static {
            LANGUAGE_INFO.put((OCLanguageKind)CLanguageKind.C, new LanguageInfo("c", "_C", LanguageC.class));
            LANGUAGE_INFO.put((OCLanguageKind)CLanguageKind.CPP, new LanguageInfo("cpp", "_CPP", LanguageCPP.class));
            LANGUAGE_INFO.put((OCLanguageKind)CLanguageKind.OBJ_C, new LanguageInfo("objc", "", LanguageObjC.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClass";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$LanguageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$LanguageInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getContextName";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuffix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getBaseContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static final class DeclarationC
    extends DeclarationBase {
        public DeclarationC() {
            super((OCLanguageKind)CLanguageKind.C);
        }
    }

    public static final class DeclarationCPP
    extends DeclarationBase {
        public DeclarationCPP() {
            super((OCLanguageKind)CLanguageKind.CPP);
        }
    }

    public static final class DeclarationObjC
    extends DeclarationBase {
        public DeclarationObjC() {
            super((OCLanguageKind)CLanguageKind.OBJ_C);
        }
    }

    public static class DeclarationBase
    extends OCCodeContextType {
        public DeclarationBase(@NotNull OCLanguageKind needKind) {
            if (needKind == null) {
                DeclarationBase.$$$reportNull$$$0(0);
            }
            super(needKind, "OC_DECLARATION" + LanguageInfo.getSuffix(needKind), OCBundle.message("declaration.name", new Object[0]), LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                DeclarationBase.$$$reportNull$$$0(1);
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$DeclarationBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ExpressionC
    extends ExpressionBase {
        public ExpressionC() {
            super((OCLanguageKind)CLanguageKind.C);
        }
    }

    public static final class ExpressionCPP
    extends ExpressionBase {
        public ExpressionCPP() {
            super((OCLanguageKind)CLanguageKind.CPP);
        }
    }

    public static final class ExpressionObjC
    extends ExpressionBase {
        public ExpressionObjC() {
            super((OCLanguageKind)CLanguageKind.OBJ_C);
        }
    }

    public static class ExpressionBase
    extends OCCodeContextType {
        public ExpressionBase(@NotNull OCLanguageKind needKind) {
            if (needKind == null) {
                ExpressionBase.$$$reportNull$$$0(0);
            }
            super(needKind, "OC_EXPRESSION" + LanguageInfo.getSuffix(needKind), OCBundle.message("expression.name", new Object[0]), LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                ExpressionBase.$$$reportNull$$$0(1);
            }
            return ExpressionBase.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            if (!((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.andNot(OCCompletionPatterns.AFTER_DOT)).accepts((Object)element) && !((PsiElementPattern.Capture)OCCompletionPatterns.TYPE_IN_DECLARATION.andNot(OCCompletionPatterns.AFTER_DOT)).accepts((Object)element)) {
                return false;
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCExpression.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarationStatement.class) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$ExpressionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class StatementC
    extends StatementBase {
        public StatementC() {
            super((OCLanguageKind)CLanguageKind.C);
        }
    }

    public static final class StatementCPP
    extends StatementBase {
        public StatementCPP() {
            super((OCLanguageKind)CLanguageKind.CPP);
        }
    }

    public static final class StatementObjC
    extends StatementBase {
        public StatementObjC() {
            super((OCLanguageKind)CLanguageKind.OBJ_C);
        }
    }

    public static class StatementBase
    extends OCCodeContextType {
        public StatementBase(@NotNull OCLanguageKind needKind) {
            if (needKind == null) {
                StatementBase.$$$reportNull$$$0(0);
            }
            super(needKind, "OC_STATEMENT" + LanguageInfo.getSuffix(needKind), OCBundle.message("statement.name", new Object[0]), LanguageInfo.getBaseContext(needKind));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                StatementBase.$$$reportNull$$$0(1);
            }
            return StatementBase.isStatementContext(element);
        }

        private static boolean isStatementContext(PsiElement element) {
            if (!ExpressionBase.isExpressionContext(element)) {
                return false;
            }
            if (OCCompletionPatterns.AT_STATEMENT_LEVEL.accepts((Object)element)) {
                return true;
            }
            OCExpressionStatement expressionStatement = (OCExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCExpressionStatement.class, (boolean)true);
            return expressionStatement != null && TreeUtil.findFirstLeaf((ASTNode)expressionStatement.getNode()) == element.getNode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$StatementBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class LanguageC
    extends LanguageBase {
        public LanguageC() {
            super((OCLanguageKind)CLanguageKind.C);
        }
    }

    public static final class LanguageCPP
    extends LanguageBase {
        public LanguageCPP() {
            super((OCLanguageKind)CLanguageKind.CPP);
        }
    }

    public static final class LanguageObjC
    extends LanguageBase {
        public LanguageObjC() {
            super((OCLanguageKind)CLanguageKind.OBJ_C);
        }
    }

    public static class LanguageBase
    extends OCCodeContextType {
        public LanguageBase(@NotNull OCLanguageKind needKind) {
            if (needKind == null) {
                LanguageBase.$$$reportNull$$$0(0);
            }
            super(needKind, LanguageInfo.getContextName(needKind), needKind.getDisplayName(), EverywhereContextType.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needKind", "com/jetbrains/cidr/lang/editor/completion/OCCodeContextType$LanguageBase", "<init>"));
        }
    }
}

