/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodSelectorCompletionContributor
extends OCCompletionContributorBase {
    @NonNls
    public static final String CIDR_RULE_ZZZ = "CIDR_RULE_ZZZ";
    @NonNls
    public static final String NSOBJECT = "NSObject";
    public static final ElementPattern<PsiElement> PLACE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(OCArgumentSelector.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCLexerTokenTypes.IDENTIFIER).withParent(PsiErrorElement.class)).withSuperParent(2, OCMessageArgument.class)});
    public static final Key<PsiElement> POSSIBLE_RECEIVER_KEY = new Key("POSSIBLE_SELECTOR");
    public static final PsiElementPattern.Capture<PsiElement> POSSIBLE_PLACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiComment())).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.IDENTIFIER, OCLexerTokenTypes.RBRACKET, OCLexerTokenTypes.RPAR, OCLexerTokenTypes.RBRACE}))).save(POSSIBLE_RECEIVER_KEY));
    private static final InsertHandler<LookupElement> REMOVE_EXTRA_COLON_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            int offset = context.getEditor().getCaretModel().getOffset();
            if (document.getCharsSequence().charAt(offset) == ':') {
                document.deleteString(offset, offset + 1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final Key<Context> CONTEXT = new Key("CONTEXT");

    public MethodSelectorCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                SendMessagePlace place;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((place = MethodSelectorCompletionContributor.findSendMessageCompletionPlace(parameters.getPosition())) == null) {
                    return;
                }
                StringBuilder exactSelectorPrefixBuilder = new StringBuilder();
                OCSendMessageExpression expr = place.expression;
                for (OCMessageArgument arg : expr.getArguments()) {
                    if (arg == place.argument) break;
                    exactSelectorPrefixBuilder.append(arg.getArgumentSelector().getSelectorName());
                }
                String exactSelectorPrefix = exactSelectorPrefixBuilder.toString();
                OCExpression receiver = expr.getReceiverExpression();
                Condition<OCMethodSymbol> condition = MethodSelectorCompletionContributor.getTypeFilter(expr, parameters.getCompletionType());
                MethodSelectorCompletionContributor.addCompletionsForReceiver(receiver, exactSelectorPrefix, parameters, result, condition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$2", "addCompletions"));
            }
        };
        this.register(CompletionType.BASIC, PLACE, provider2);
        this.register(CompletionType.SMART, PLACE, provider2);
        OCCompletionProvider provider22 = new OCCompletionProvider(this){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                SendMessagePlace place;
                PsiElement element;
                OCExpression expr;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((expr = MethodSelectorCompletionContributor.getMethodReceiverExpression(element = parameters.getPosition())) == null) {
                    return;
                }
                if (PLACE.accepts((Object)element) && (place = MethodSelectorCompletionContributor.findSendMessageCompletionPlace(element)) != null && place.expression == expr.getParent()) {
                    return;
                }
                MethodSelectorCompletionContributor.addMethodCompletionsForExpression(expr, parameters, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$3", "addCompletions"));
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)POSSIBLE_PLACE, provider22);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)POSSIBLE_PLACE, provider22);
    }

    @Nullable
    private static SendMessagePlace findSendMessageCompletionPlace(PsiElement position) {
        OCMessageArgument arg = (OCMessageArgument)PsiTreeUtil.getParentOfType((PsiElement)position, OCMessageArgument.class);
        return arg != null ? new SendMessagePlace(arg) : null;
    }

    public static void addCompletionsForReceiver(OCExpression receiver, String exactSelectorPrefix, OCCompletionParameters parameters, CompletionResultSet result, Condition<OCMethodSymbol> condition) {
        if (receiver == null) {
            return;
        }
        OCObjectTypeContext receiverContext = receiver.getTypeContext(true, true);
        OCLanguageKind languageKind = receiver.getContainingOCFile().getKind();
        if (receiverContext == null || receiverContext.getOriginalType().isUnknown()) {
            if (receiver instanceof OCReferenceExpression) {
                OCType type;
                OCSymbol symbol;
                OCReferenceElement referenceElement = ((OCReferenceExpression)receiver).getReferenceElement();
                OCSymbol oCSymbol = symbol = referenceElement != null ? referenceElement.resolveToSymbol(OCSymbolGroupContext.typeContext(languageKind)) : null;
                if (symbol != null && (type = symbol.getEffectiveResolvedType(OCResolveContext.forPsi(receiver))) instanceof OCObjectType) {
                    receiverContext = new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type, symbol.getType());
                }
            }
            if (receiverContext == null) {
                return;
            }
        }
        Context context = new Context(exactSelectorPrefix, receiver, receiverContext, condition);
        MethodSelectorCompletionContributor.addCompletionForReceiverContext(parameters, result, context);
    }

    public static void addCompletionForReceiverContext(@NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull Context context) {
        if (parameters == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!context.getExactSelectorPrefix().isEmpty() && result.getPrefixMatcher().getPrefix().isEmpty() && !(PsiTreeUtil.prevLeaf((PsiElement)parameters.getPosition(), (boolean)true) instanceof PsiWhiteSpace)) {
            return;
        }
        MethodSelectorCompletionContributor.doAddCompletions(result, parameters, context);
    }

    private static void doAddCompletions(@NotNull CompletionResultSet result, @NotNull OCCompletionParameters parameters, @NotNull Context context) {
        if (result == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(5);
        }
        OCObjectTypeContext receiverContext = context.getReceiverContext();
        Condition<OCMethodSymbol> condition = context.getCondition();
        Processor<OCMethodSymbol> processor2 = MethodSelectorCompletionContributor.getProcessor(parameters, result, context);
        if (receiverContext.getType().getName().equals(NSOBJECT)) {
            if (condition instanceof OCSmartCompletionContributor.TypeMatchingCondition) {
                ((OCSmartCompletionContributor.TypeMatchingCondition)condition).avoidNSObjectMethods(false);
            }
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(parameters.getOriginalFile().getProject(), new OCCommonProcessors.TypeFilteredProcessor(processor2, OCMethodSymbol.class), null);
        } else {
            if (condition instanceof OCSmartCompletionContributor.TypeMatchingCondition) {
                ((OCSmartCompletionContributor.TypeMatchingCondition)condition).setReceiverContext(receiverContext);
            }
            receiverContext.getType().processMembers(OCMethodSymbol.class, processor2);
        }
    }

    public static Processor<OCMethodSymbol> getProcessor(final @NotNull OCCompletionParameters parameters, final @NotNull CompletionResultSet result, final @NotNull Context context) {
        if (parameters == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(8);
        }
        final OCObjectTypeContext receiverContext = context.getReceiverContext();
        final String exactSelectorPrefix = context.getExactSelectorPrefix();
        final Icon icon = OCIcons.getMethodIcon(receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC, false, false);
        final boolean completeFullSelector = exactSelectorPrefix.isEmpty();
        Processor<OCMethodSymbol> processor2 = new Processor<OCMethodSymbol>(){
            private Set<String> names = new HashSet<String>();

            public boolean process(OCMethodSymbol symbol) {
                String tail;
                OCFile file;
                String name = symbol.getName();
                if (!receiverContext.fitsStaticness(symbol)) {
                    return true;
                }
                if (symbol.isUnavailable() || symbol.isForbiddenByARC((PsiElement)parameters.getOriginalFile())) {
                    return true;
                }
                PsiFile original = parameters.getOriginalFile();
                if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file = symbol.getContainingOCFile(original.getProject())) == null || file.isHeader())) {
                    return true;
                }
                if (!this.names.add(name)) {
                    return true;
                }
                if (completeFullSelector) {
                    LookupElement lookup;
                    boolean isFromCurClass = Objects.equals(symbol.getParent().getName(), receiverContext.getType().getClassName());
                    PsiElement position = parameters.getPosition();
                    LookupElement l = lookup = SymbolLookupBuilderUtil.lookup((OCSymbol)symbol, null, receiverContext.getType(), position, isFromCurClass, null, original.getProject());
                    CONTEXT.set((UserDataHolder)l, (Object)context);
                    while (l instanceof LookupElementDecorator) {
                        l = ((LookupElementDecorator)l).getDelegate();
                        CONTEXT.set((UserDataHolder)l, (Object)context);
                    }
                    if (result.getPrefixMatcher().prefixMatches(lookup)) {
                        result.addElement(lookup);
                    }
                } else if (name.startsWith(exactSelectorPrefix) && !(tail = name.substring(exactSelectorPrefix.length())).isEmpty()) {
                    int colonIndex = tail.indexOf(58);
                    String lookup = colonIndex >= 0 ? tail.substring(0, colonIndex + 1) : tail;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)lookup).withIcon(icon).withInsertHandler(REMOVE_EXTRA_COLON_HANDLER));
                }
                return true;
            }
        };
        return new FilteringProcessor(context.getCondition(), (Processor)processor2);
    }

    public static void addMethodCompletionsIfAppropriate(@NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
        OCExpression expr;
        if (parameters == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(9);
        }
        if (result == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(10);
        }
        if (element == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(11);
        }
        if ((expr = MethodSelectorCompletionContributor.getMethodReceiverExpression(element)) != null) {
            MethodSelectorCompletionContributor.addMethodCompletionsForExpression(expr, parameters, result);
        }
    }

    private static void addMethodCompletionsForExpression(OCExpression expr, @NotNull OCCompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(12);
        }
        if (result == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(13);
        }
        Condition<OCMethodSymbol> condition = MethodSelectorCompletionContributor.getTypeFilter(expr, parameters.getCompletionType());
        MethodSelectorCompletionContributor.addCompletionsForReceiver(expr, "", parameters, result, condition);
    }

    @NotNull
    private static Condition<OCMethodSymbol> getTypeFilter(@NotNull OCExpression expr, @NotNull CompletionType completionType) {
        if (expr == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(14);
        }
        if (completionType == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(15);
        }
        OCSmartCompletionContributor.TypeMatchingCondition condition = Conditions.alwaysTrue();
        if (completionType == CompletionType.SMART) {
            OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)expr, OCDeclarator.class);
            OCSymbol ownSymbol = declarator != null ? declarator.getSymbol() : null;
            OCResolveContext context = OCResolveContext.forPsi(expr);
            OCType expectedType = OCExpectedTypeUtil.getExpectedType(expr, context).resolve(context);
            if (expectedType != OCUnknownType.INSTANCE) {
                condition = new OCSmartCompletionContributor.TypeMatchingCondition(expr, expectedType, false, ownSymbol);
            }
        }
        OCSmartCompletionContributor.TypeMatchingCondition typeMatchingCondition = condition;
        if (typeMatchingCondition == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(16);
        }
        return typeMatchingCondition;
    }

    public static OCExpression getMethodReceiverExpression(@NotNull PsiElement element) {
        OCReferenceElement ref;
        ProcessingContext match;
        if (element == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(17);
        }
        if (!POSSIBLE_PLACE.accepts((Object)element, match = new ProcessingContext())) {
            return null;
        }
        PsiElement receiver = (PsiElement)match.get(POSSIBLE_RECEIVER_KEY);
        ASTNode receiverLeaf = receiver.getNode();
        OCLanguageKind languageKind = ((OCFile)receiver.getContainingFile()).getKind();
        IElementType type = receiverLeaf.getElementType();
        OCExpression expr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)receiverLeaf.getPsi(), OCExpression.class);
        if (type == OCLexerTokenTypes.RPAR && expr instanceof OCCastExpression) {
            return null;
        }
        if (expr == null) {
            return null;
        }
        if (expr instanceof OCBlockExpression && PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)element, (boolean)true)) {
            return null;
        }
        OCObjectTypeContext typeContext = expr.getTypeContext(true, true);
        OCType resolvedType = typeContext == null ? expr.getResolvedType() : typeContext.getOriginalType();
        OCExpression result = null;
        if (resolvedType.isPointerToObjectCompatible()) {
            result = expr;
        } else if (expr instanceof OCReferenceExpression && (ref = ((OCReferenceExpression)expr).getReferenceElement()) != null && ref.resolveToSymbol(OCSymbolGroupContext.typeContext(languageKind)) != null) {
            result = expr;
        }
        while (result != null && result.getParent() instanceof OCUnaryExpression) {
            result = (OCExpression)result.getParent();
        }
        return result;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement element;
        PsiElement id;
        int endRegion;
        if (context == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(18);
        }
        Object dummy = CIDR_RULE_ZZZ;
        if (context.getDummyIdentifier().contains((CharSequence)dummy)) {
            return;
        }
        int offset = context.getStartOffset();
        String docText = context.getEditor().getDocument().getText();
        if (docText.regionMatches(offset, "<#", 0, 2) && (endRegion = docText.indexOf("#>", offset)) > offset) {
            context.setReplacementOffset(endRegion + 2);
        }
        if ((id = context.getFile().findElementAt(offset - 1)) != null && id.getNode().getElementType() == OCLexerTokenTypes.IDENTIFIER) {
            dummy = id.getText().substring(offset - id.getTextOffset()) + CIDR_RULE_ZZZ;
        }
        if (MethodSelectorCompletionContributor.isPartOfMacroCall(element = context.getFile().findElementAt(offset)) || MethodSelectorCompletionContributor.isAtRPar(element) || MethodSelectorCompletionContributor.isInsideSendMessage(context)) {
            context.setDummyIdentifier((String)dummy);
        } else if (context.getCompletionType() == CompletionType.SMART) {
            context.setDummyIdentifier((String)dummy + ")");
        } else {
            context.setDummyIdentifier((String)dummy + ";");
        }
    }

    private static boolean isPartOfMacroCall(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCall.class) != null;
    }

    private static boolean isAtRPar(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = TreeUtil.skipElements((ASTNode)element.getNode(), (TokenSet)OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        return node != null && node.getElementType() == OCLexerTokenTypes.RPAR;
    }

    private static boolean isInsideSendMessage(@NotNull CompletionInitializationContext context) {
        OCSendMessageExpression message;
        if (context == null) {
            MethodSelectorCompletionContributor.$$$reportNull$$$0(19);
        }
        if ((message = (OCSendMessageExpression)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)context.getFile(), (int)context.getStartOffset(), OCSendMessageExpression.class, (boolean)false, (Class[])new Class[]{OCCallable.class})) != null && message.getTextRange().getStartOffset() == context.getStartOffset()) {
            message = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)message, OCSendMessageExpression.class, (boolean)true, (Class[])new Class[]{OCCallable.class});
        }
        return message != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionForReceiverContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProcessor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMethodCompletionsIfAppropriate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMethodCompletionsForExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFilter";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReceiverExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSendMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }

    private static class SendMessagePlace {
        @NotNull
        public final OCSendMessageExpression expression;
        @NotNull
        public final OCMessageArgument argument;

        SendMessagePlace(@NotNull OCMessageArgument argument) {
            if (argument == null) {
                SendMessagePlace.$$$reportNull$$$0(0);
            }
            this.expression = (OCSendMessageExpression)argument.getParent();
            this.argument = argument;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$SendMessagePlace", "<init>"));
        }
    }

    public static class Context {
        @NotNull
        private final String myExactSelectorPrefix;
        @NotNull
        private final OCObjectTypeContext myReceiverContext;
        @NotNull
        private final Condition<OCMethodSymbol> myCondition;
        @Nullable
        private final PsiElement myReceiver;

        public Context(@NotNull String prefix, @Nullable PsiElement receiver, @NotNull OCObjectTypeContext context, @NotNull Condition<OCMethodSymbol> condition) {
            if (prefix == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (condition == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.myExactSelectorPrefix = prefix;
            this.myReceiver = receiver;
            this.myReceiverContext = context;
            this.myCondition = condition;
        }

        @NotNull
        public String getExactSelectorPrefix() {
            String string = this.myExactSelectorPrefix;
            if (string == null) {
                Context.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public OCObjectTypeContext getReceiverContext() {
            OCObjectTypeContext oCObjectTypeContext = this.myReceiverContext;
            if (oCObjectTypeContext == null) {
                Context.$$$reportNull$$$0(4);
            }
            return oCObjectTypeContext;
        }

        @NotNull
        public Condition<OCMethodSymbol> getCondition() {
            Condition<OCMethodSymbol> condition = this.myCondition;
            if (condition == null) {
                Context.$$$reportNull$$$0(5);
            }
            return condition;
        }

        @Nullable
        public PsiElement getReceiver() {
            return this.myReceiver;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/MethodSelectorCompletionContributor$Context";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExactSelectorPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReceiverContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

