/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.colors;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private final Map<CidrLexerSettings, OCFileHighlighter> myHighlighters = FactoryMap.create(key -> new OCFileHighlighter((CidrLexerSettings)key));

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        CLanguageKind languageKind = CLanguageKind.maxLanguage();
        if (virtualFile != null && !(virtualFile instanceof VirtualFileWindow) && virtualFile.isValid() && project != null && FileSymbolTableHelper.isSourceFile(virtualFile, project)) {
            languageKind = OCLanguageKindCalculator.calculateLanguageKindFast(virtualFile, project);
        }
        OCLanguageStandard languageStandard = languageKind.isCpp() || languageKind.isCuda() ? OCLanguageStandard.latestCpp() : OCLanguageStandard.latestC();
        CidrLexerSettings settings = OCLexerSettings.forLanguage((OCLanguageKind)languageKind).forHighlighting().allowNullabilityKeywords().allowNullabilityNullableResultKeywords().allowGccAutoType().allowAvailabilityExpression().allowMsvcExtensions().setLanguageStandard(languageStandard).build();
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myHighlighters.get(settings);
        if (syntaxHighlighter == null) {
            OCSyntaxHighlighterFactory.$$$reportNull$$$0(0);
        }
        return syntaxHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCSyntaxHighlighterFactory", "getSyntaxHighlighter"));
    }
}

