/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.documentation.CidrVirtualDocComment;
import com.jetbrains.cidr.lang.documentation.ClangdBridgeCompletionItem;
import com.jetbrains.cidr.lang.documentation.CppReferenceDocumentationUtil;
import com.jetbrains.cidr.lang.documentation.DoxygenRender;
import com.jetbrains.cidr.lang.documentation.HtmlHelper;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    @NonNls
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    private final Map<String, CodeStyleSettings> mySettings = new HashMap<String, CodeStyleSettings>();

    @Nullable
    public Flow<String> getAsyncDocumentationFlow(@NotNull String ignoredBaseDoc, @NotNull PsiElement ignoredElement, @Nullable PsiElement ignoredOriginalElement) {
        if (ignoredBaseDoc == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (ignoredElement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nls
    protected String getEvaluatedExpressionInfo(@NotNull PsiElement originalElement) throws ExecutionException {
        if (originalElement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfoInner(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        return this.quickDocContent(element, OCPsiFile.tryGetElementFromOCFile(originalElement), false);
    }

    @Nullable
    @Nls
    public String generateDocInner(PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression) {
            return CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element);
        }
        return this.generateDocInnerHtml(element, OCPsiFile.tryGetElementFromOCFile(originalElement), false);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (psiManager != null) {
            if (object instanceof OCSymbol) {
                return ((OCSymbol)object).locateDefinition(psiManager.getProject());
            }
            if (object instanceof ClangdBridgeCompletionItem) {
                return ExternalResolveUtils.clangdCompletionItem2PsiElement(psiManager.getProject(), (ClangdBridgeCompletionItem)object);
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if ((link = StringUtil.trimStart((String)link, (String)"psi_element://")).startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts.size() == 3) {
                PsiElement elementAt;
                PsiFile file;
                String path = (String)parts.get(1);
                String offset = (String)parts.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid() && (elementAt = file.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(',').append(file.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @NotNull
    @Nls
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        if (sme == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(4);
        }
        OCPolyVariantReference<OCMethodSymbol> reference = sme.getReference();
        List<OCMethodSymbol> list = reference.resolveToSymbols();
        HtmlBuilder builder = new HtmlBuilder();
        for (OCMethodSymbol symbol : list) {
            OCClassSymbol parent = symbol.getParent();
            String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
            if (link == null) continue;
            builder.append((HtmlChunk)HtmlChunk.link((String)link, (String)(symbol.getSignature(sme.getProject()) + " (" + parent.getPresentableName() + ")")));
            builder.append((HtmlChunk)HtmlChunk.br());
        }
        String string = CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(OCResolveContext.forPsi(sme)), builder.toString()});
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    @Nls
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        if (comment == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(6);
        }
        DoxygenRender dxRender = new DoxygenRender((PsiElement)comment);
        @Nls StringBuilder sb = new StringBuilder();
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(sb);
        }
        return sb.isEmpty() ? (DumbService.getInstance((Project)comment.getProject()).isDumb() ? CodeInsightBundle.message((String)"doc.render.loading.text", (Object[])new Object[0]) : null) : CidrDocumentationProvider.cleanEmptyLinesInDoc(sb.toString());
    }

    @Nls
    @NotNull
    private static String cleanEmptyLinesInDoc(@NotNull @Nls String htmlDoc) {
        if (htmlDoc == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(7);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)htmlDoc, (String)"<br/>"), (String)"<br/>").replace("<td> </td>", "<td></td>").replace("</td> </tr>", "</td></tr>").replace("<table><tr valign=\"top\"><td><code></code></td><td></td></tr></table>", "").trim();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (range == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(10);
        }
        ArrayList<PsiDocCommentBase> comments = new ArrayList<PsiDocCommentBase>();
        for (PsiElement element = file.findElementAt(range.getStartOffset()); element != null && element.getTextRange().getStartOffset() < range.getEndOffset(); element = element.getNextSibling()) {
            if (!(element instanceof PsiDocCommentBase)) continue;
            comments.add((PsiDocCommentBase)element);
        }
        Ref docComment = new Ref();
        CidrDocumentationProvider.processMergedComments(comments, base -> docComment.set(base));
        return (PsiDocCommentBase)docComment.get();
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (sink == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(12);
        }
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiDocCommentBase.class);
        CidrDocumentationProvider.processMergedComments(comments, sink);
    }

    private static void processMergedComments(@NotNull Collection<? extends PsiComment> comments, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (comments == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (sink == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(14);
        }
        ArrayList<PsiComment> group = new ArrayList<PsiComment>();
        for (PsiComment psiComment : comments) {
            if (group.isEmpty()) {
                group.add(psiComment);
                continue;
            }
            if (!CidrDocumentationProvider.canMergeComments((PsiComment)group.get(group.size() - 1), psiComment)) {
                sink.accept(new CidrVirtualDocComment(group));
                group = new ArrayList();
            }
            group.add(psiComment);
        }
        if (!group.isEmpty()) {
            sink.accept(new CidrVirtualDocComment(group));
        }
    }

    public static boolean canMergeComments(@NotNull PsiComment comment, @NotNull PsiComment nextComment) {
        IElementType commentType;
        if (comment == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (nextComment == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(16);
        }
        if ((commentType = comment.getTokenType()) == OCLexerTokenTypes.BLOCK_COMMENT || commentType != nextComment.getTokenType()) {
            return false;
        }
        PsiElement nextElement = comment.getNextSibling();
        while (nextElement instanceof PsiWhiteSpace) {
            nextElement = nextElement.getNextSibling();
        }
        return nextElement == nextComment;
    }

    @Nullable
    @Nls
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        Project project = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(originalElement != null ? originalElement : element);
        HtmlChunk.Element location = null;
        HtmlBuilder signature2 = new HtmlBuilder();
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            OCNamespaceSymbol symbol = (OCNamespaceSymbol)((OCCppNamespace)element).getSymbol();
            if (symbol != null) {
                location = CidrDocumentationProvider.declaredInHint(element.getContainingFile());
                if (symbol.isInlineNamespace()) {
                    signature2.append(OCLexerTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                signature2.append(symbol.getKindLowercase(context)).append(" ");
                @NlsSafe String namespace = OCDocUtil.getNamespace(symbol, context);
                if (!namespace.isEmpty()) {
                    signature2.append(namespace).append("::");
                }
                signature2.append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
            }
        } else if (element instanceof OCClassDeclaration) {
            OCFile file;
            OCInterfaceSymbol anInterface;
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file = anInterface.getContainingOCFile(project)) != null) {
                location = CidrDocumentationProvider.declaredInHint(file);
            }
            signature2.append(CidrDocumentationProvider.classHintDoc(cd));
        } else {
            if (element instanceof OCMethodSelectorPart) {
                HtmlBuilder answer = new HtmlBuilder();
                CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
                answer.append((HtmlChunk)HtmlChunk.text((String)StringUtil.notNullize((String)((OCMethodSelectorPart)element).getName())).bold());
                return answer.toString();
            }
            if (element instanceof OCTypeParameterDeclaration) {
                return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
            }
            if (element instanceof OCCategoryName) {
                OCCategoryName category = (OCCategoryName)element;
                PsiElement parent = category.getParent();
                if (parent instanceof OCClassDeclaration) {
                    OCClassDeclaration cd = (OCClassDeclaration)parent;
                    return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
                }
                return null;
            }
            if (element instanceof OCDeclarator) {
                PsiReference reference;
                OCDeclarator declarator = (OCDeclarator)element;
                OCSymbol symbol = null;
                PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
                if (reference instanceof OCReference) {
                    symbol = ((OCReference)reference).resolveToSymbol();
                }
                if (symbol == null) {
                    symbol = declarator.getSymbol();
                }
                return this.getSymbolDoc(element, context, symbol);
            }
            if (element instanceof OCSymbolHolderVirtualPsiElement) {
                List<OCFunctionSymbol> overloads;
                Object symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol();
                if (symbol instanceof OCFunctionGroupSymbol && (overloads = ((OCFunctionGroupSymbol)symbol).getOverloads()).size() == 1) {
                    symbol = overloads.get(0);
                }
                return this.getSymbolDoc(element, context, (OCSymbol)symbol);
            }
            if (element instanceof OCDefineDirective) {
                PsiFile file = element.getContainingFile();
                OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
                if (symbol == null) {
                    return "";
                }
                location = CidrDocumentationProvider.declaredInHint(file);
                signature2.append("#define ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
                if (symbol.hasParameterList()) {
                    signature2.append("(").append(StringUtil.join(symbol.getParameterNames(), (String)", ")).append(")");
                }
                signature2.append(" ").append(HtmlChunk.text((String)symbol.getSubstitution()));
            } else if (element instanceof OCCppUsingStatement) {
                location = CidrDocumentationProvider.declaredInHint(element.getContainingFile());
                OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
                if (symbol instanceof OCAliasUsingSymbol) {
                    signature2.append("using ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold()).append(" = ").appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context));
                }
            } else if (element instanceof OCCppNamespaceAlias) {
                OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
                location = CidrDocumentationProvider.declaredInHint(element.getContainingFile());
                OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
                if (OCLog.LOG.assertTrue(symbol != null)) {
                    OCSymbolKind kind = symbol.getKind();
                    OCSymbolReference ref = symbol.getNamespaceReference();
                    signature2.append(kind.getNameLowercase()).append(" ").append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold()).append(" = ").append(ref.getQualifiedName().getFullName(OCResolveContext.forPsi(element)));
                }
            } else if (element instanceof OCStructLike) {
                OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
                location = CidrDocumentationProvider.declaredInHint(element.getContainingFile());
                if (symbol != null) {
                    CidrDocumentationProvider.addNamespace(symbol, signature2, context);
                    CidrDocumentationProvider.addVisibility(symbol, signature2, project);
                    if (symbol.isPredeclaration()) {
                        OCDocUtil.extractModifiers(symbol, signature2);
                    } else {
                        signature2.append(CidrDocumentationProvider.getTemplateParameters(symbol, context));
                    }
                    signature2.append(symbol.getKindLowercase(context)).append(" ");
                    if (symbol.isEnumClass()) {
                        signature2.append("class ");
                    }
                    signature2.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(symbol, context)).append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
                    CidrDocumentationProvider.extractTemplateSpecialization(symbol, signature2, context);
                    if (symbol.isFinal()) {
                        signature2.append(" ").append(OCLexerTokenTypes.FINAL_CPP_KEYWORD.getName());
                    }
                    signature2.appendRaw(CidrDocumentationProvider.getBaseClassesHtml(symbol, context));
                    signature2 = new HtmlBuilder().appendRaw(signature2.toString().replaceAll("\\s+", " "));
                }
            } else {
                OCFindUsagesProvider common = new OCFindUsagesProvider();
                if (common.canFindUsagesFor(element)) {
                    location = CidrDocumentationProvider.declaredInHint(element.getContainingFile());
                    signature2.append(common.getType(element)).append(" ").append((HtmlChunk)HtmlChunk.text((String)common.getDescriptiveName(element)).bold());
                }
            }
        }
        return CidrDocumentationProvider.buildResult(signature2, location);
    }

    @Nullable
    @Nls
    private String getSymbolDoc(@NotNull PsiElement element, @NotNull OCResolveContext context, OCSymbol symbol) {
        OCClassDeclaration container;
        PsiElement parent;
        PsiElement grandParent;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(19);
        }
        HtmlBuilder signature2 = new HtmlBuilder();
        Project project = element.getProject();
        OCFile containingFile = symbol == null ? null : symbol.getContainingOCFile(project);
        OCDeclarator declarator = (OCDeclarator)ObjectUtils.tryCast((Object)element, OCDeclarator.class);
        HtmlChunk.Element location = null;
        if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            location = CidrDocumentationProvider.declaredInHint(containingFile);
        }
        if (symbol != null) {
            CidrDocumentationProvider.addNamespace(symbol, signature2, context);
            CidrDocumentationProvider.addVisibility(symbol, signature2, project);
        }
        PsiElement psiElement = grandParent = (parent = element.getParent()) != null ? parent.getParent() : null;
        if (grandParent instanceof OCProperty) {
            OCProperty property = (OCProperty)grandParent;
            String iVarDoc = this.propertyIVarDoc(property);
            if (iVarDoc != null) {
                return iVarDoc;
            }
            OCClassDeclaration container2 = property.getContainingClass();
            if (container2 != null) {
                signature2.append(CidrDocumentationProvider.classHintDoc(container2)).append((HtmlChunk)HtmlChunk.br());
            }
            signature2.append("@property ");
            OCPropertyAttributesList attrs = property.getPropertyAttributesList();
            if (attrs != null) {
                String attrsStr = StringUtil.join(attrs.getAttributes(), attribute -> attribute.getText(), (String)", ");
                signature2.append("(").append(attrsStr).append(") ");
            }
        } else if (grandParent instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            signature2.append(CidrDocumentationProvider.classHintDoc(container)).append((HtmlChunk)HtmlChunk.br());
        }
        if (symbol != null) {
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                signature2.append("ivar ");
            } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                signature2.append("typedef ");
            }
        }
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol definition;
            OCFunctionSymbol func = (OCFunctionSymbol)symbol;
            if (func.isFriend() && (definition = (OCFunctionSymbol)func.getDefinitionSymbol(project)) != null) {
                func = definition;
            }
            signature2.append(CidrDocumentationProvider.getTemplateParameters(func, context));
            OCFunctionDeclaration functionDeclaration = func.locateFunctionDefinition(project);
            OCDocUtil.extractModifiers(func, functionDeclaration, signature2);
            if (!func.isCppConstructor() && !func.isCppDestructor()) {
                signature2.appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(func, context)).append(OCDocUtil.delimiter(CidrDocumentationProvider.effectiveTypeStringHtml(func, context)));
            }
            signature2.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(func, context)).append((HtmlChunk)HtmlChunk.text((String)func.getName()).bold());
            this.extractFunctionSignature(declarator, func, signature2, context);
        } else if (symbol instanceof OCDeclaratorSymbol) {
            signature2.append(CidrDocumentationProvider.getTemplateParameters(symbol, context));
            OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, signature2);
            boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
            signature2.appendRaw(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context)).append(OCDocUtil.delimiter(CidrDocumentationProvider.effectiveTypeStringHtml(symbol, context), isEnumConst ? "::" : " "));
            if (!isEnumConst) {
                signature2.appendRaw(CidrDocumentationProvider.getCanonicalNamePrefixHtml(symbol, context));
            }
            signature2.append((HtmlChunk)HtmlChunk.text((String)symbol.getName()).bold());
        } else if (declarator != null) {
            CidrDocumentationProvider.appendType(signature2, declarator.getRawType(), element.getContainingFile(), false);
            signature2.append(" ").append((HtmlChunk)HtmlChunk.text((String)declarator.getName()).bold());
        }
        if (declarator != null) {
            this.processInitializer(declarator, signature2);
        }
        return CidrDocumentationProvider.buildResult(signature2, location);
    }

    @NotNull
    @NlsSafe
    private static String getBaseClassesHtml(@NotNull OCStructSymbol symbol, @NotNull OCResolveContext context) {
        Collection<Pair<OCType, OCVisibility>> baseClasses;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (!(baseClasses = symbol.getBaseCppClassesWithVisibility(context)).isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            String baseClassesStr = StringUtil.join(baseClasses, pair -> {
                OCVisibility visibility = (OCVisibility)((Object)((Object)pair.getSecond()));
                Object visibilityStr = "";
                if (visibility != null) {
                    visibilityStr = String.valueOf((Object)visibility) + " ";
                }
                OCType type = (OCType)pair.getFirst();
                return (String)visibilityStr + OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context);
            }, (String)", ");
            String string = " : " + baseClassesStr;
            if (string == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(22);
            }
            return string;
        }
        return "";
    }

    @NlsSafe
    @Nullable
    private static String buildResult(@NotNull HtmlBuilder signature2, @Nullable HtmlChunk.Element location) {
        if (signature2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (signature2.isEmpty() && location == null) {
            return null;
        }
        HtmlBuilder result = new HtmlBuilder();
        if (location != null) {
            result.append((HtmlChunk)location);
        }
        return result.append((HtmlChunk)signature2.wrapWith(DocumentationMarkup.PRE_ELEMENT).wrapWith(DocumentationMarkup.DEFINITION_ELEMENT)).toString();
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull HtmlBuilder answer) {
        OCExpression initializer;
        if (declarator == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(25);
        }
        if ((initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer()) != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull HtmlBuilder answer) {
        String text;
        int idx;
        if (initializer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(27);
        }
        if ((idx = (text = initializer.getTextWithMacros()).indexOf(10)) != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(HtmlChunk.text((String)part)).append("...");
        } else {
            answer.append(HtmlChunk.text((String)text));
        }
    }

    private void extractFunctionSignature(@Nullable OCDeclarator declarator, @NotNull OCFunctionSymbol symbol, @NotNull HtmlBuilder answer, @NotNull OCResolveContext context) {
        Collection<OCTypeArgument> substitutionTypes;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (declarator != null) {
            declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        }
        if ((substitutionTypes = symbol.getSubstitution().getSubstitutedTypes()) != null && !substitutionTypes.isEmpty()) {
            answer.appendRaw(OCDocUtil.getParametersSignatureHtml(symbol, false, context));
        } else {
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, context);
            answer.appendRaw(OCDocUtil.getParametersSignatureHtml(symbol, true, context));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    @NlsSafe
    private static HtmlBuilder getTemplateParameters(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(32);
        }
        HtmlBuilder sb = new HtmlBuilder();
        if (symbol instanceof OCTemplateSymbol) {
            OCTemplateSymbol templateSymbol = (OCTemplateSymbol)symbol;
            if (symbol instanceof OCSymbolWithQualifiedName && templateSymbol.isTemplateSymbol()) {
                List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), context);
                List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
                OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, context, sb);
                HtmlBuilder htmlBuilder = sb.append((HtmlChunk)HtmlChunk.br());
                if (htmlBuilder == null) {
                    CidrDocumentationProvider.$$$reportNull$$$0(33);
                }
                return htmlBuilder;
            }
        }
        HtmlBuilder htmlBuilder = sb;
        if (htmlBuilder == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(34);
        }
        return htmlBuilder;
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> ignore) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(35);
        }
        PsiElement copy2 = element.copy();
        final ArrayList comments = new ArrayList();
        copy2.accept((PsiElementVisitor)new OCRecursiveVisitor(this){

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                comments.add(comment);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider$1", "visitComment"));
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)copy2) && (result = SourceTreeToPsiMap.treeElementToPsi((ASTNode)(formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy2.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree((PsiElement)copy2)))) != null) {
            PsiElement psiElement = result;
            if (psiElement == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(36);
            }
            return (T)psiElement;
        }
        PsiElement psiElement = copy2;
        if (psiElement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(37);
        }
        return (T)psiElement;
    }

    private CodeStyleSettings getSettings(@NotNull Language lang) {
        String langID;
        if (lang == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (!this.mySettings.containsKey(langID = lang.getID())) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@NotNull OCSymbolWithQualifiedName symbol, @NotNull HtmlBuilder sb, @NotNull OCResolveContext context) {
        List<OCTypeArgument> specialization;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (sb == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(40);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (symbol instanceof OCTemplateSymbol && (specialization = ((OCTemplateSymbol)((Object)symbol)).getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, context, sb);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull HtmlBuilder answer, @NotNull OCResolveContext context) {
        String namespace;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(42);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(43);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(44);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && !(namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol, context)).isEmpty()) {
            answer.append("namespace ").append(namespace).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br());
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, HtmlBuilder answer, Project project) {
        OCSymbolWithQualifiedName symbolWithQualifiedName;
        OCVisibility visibility;
        OCFile file;
        boolean showVisibility;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(45);
        }
        boolean bl = showVisibility = (file = symbol.getContainingOCFile(project)) != null && (file.isCpp() || file.getKind().isObjC());
        if (showVisibility && symbol instanceof OCSymbolWithQualifiedName && (visibility = (symbolWithQualifiedName = (OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC) {
            answer.append(visibility.toString()).append(":").append((HtmlChunk)HtmlChunk.br());
        }
    }

    @NotNull
    @NlsSafe
    private static String getCanonicalNamePrefixHtml(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(46);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefixHtml((OCSymbolWithQualifiedName)symbol, context);
            Object object = prefix.isEmpty() ? "" : prefix + "::";
            if (object == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(48);
            }
            return object;
        }
        return "";
    }

    @NotNull
    @NlsSafe
    private static String effectiveTypeStringHtml(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        OCType effectiveType;
        OCType type;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(49);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(50);
        }
        if ((type = (effectiveType = symbol.getEffectiveType(context.getProject())).accept(new OCTypeParameterResolveVisitor(context.getFile()))) instanceof OCMagicType) {
            type = effectiveType;
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, context);
            String string = OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalNameHtml(type, contextNamespace, context));
            if (string == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type.getBestNameInContext(context)));
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(52);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar;
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(53);
        }
        if ((iVar = CidrDocumentationProvider.getPropertyIVar(p)) != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(54);
        }
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        Project project = p.getProject();
        if (ps != null) {
            iVar = ps.getAssociatedIvar(project);
        }
        return iVar == null ? null : iVar.locateDefinition(project);
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd;
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(55);
        }
        if ((pd = p.getDeclaration()) == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.isEmpty()) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    @NlsSafe
    private static HtmlChunk.Element declaredInHint(@NotNull PsiFile file) {
        if (file == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(56);
        }
        return CidrDocumentationProvider.declaredInHint(file.getName());
    }

    @NotNull
    @Nls
    private static HtmlChunk.Element declaredInHint(@NotNull @NlsSafe String fileName) {
        if (fileName == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(57);
        }
        HtmlChunk.Element element = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.declared.in", new Object[0])).bold()).append(" ").append(fileName).wrapWith(DocumentationMarkup.TOP_ELEMENT);
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(58);
        }
        return element;
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        OCExpression functionRef;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(59);
        }
        Project project = element.getProject();
        if (element instanceof OCReferenceElement) {
            OCSymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty(project);
                if (property2 != null) {
                    return property2.locateDefinition(project);
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getOriginalSymbol()) != null) {
                return property.locateDefinition(project);
            }
        } else if (element instanceof OCCallExpression && (functionRef = ((OCCallExpression)element).getFunctionReferenceExpression()) instanceof OCReferenceExpression && (element = ((OCReferenceExpression)functionRef).getReferenceElement()) != null) {
            return ((OCReferenceElement)element).resolve();
        }
        return element;
    }

    @Nullable
    @Nls
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        if (type == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(60);
        }
        return type.getText();
    }

    @NotNull
    @Nls
    private static String classHintDoc(@NotNull OCClassDeclaration<?> classDeclaration) {
        if (classDeclaration == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(61);
        }
        String string = (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String methodHintDoc(@NotNull OCMethod method) {
        if (method == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(63);
        }
        HtmlBuilder answer = new HtmlBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append((HtmlChunk)HtmlChunk.br());
        }
        answer.append(method.isInstanceMethod() ? "-" : "+").append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append((HtmlChunk)HtmlChunk.text((String)StringUtil.notNullize((String)part.getSelectorPart())).bold());
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        String string = answer.toString();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(64);
        }
        return string;
    }

    private static void appendType(@NotNull HtmlBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(65);
        }
        if (type == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(66);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(67);
        }
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getBestNameInContext((PsiElement)context);
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(HtmlChunk.text((String)typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    private static boolean canUseOriginalElementForExprEval(@Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return false;
        }
        IElementType elementType = originalElement.getNode().getElementType();
        return !OCLexerTokenTypes.PUNCTUATORS.contains(elementType);
    }

    @Nullable
    @Nls
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        List<String> externalDocumentation;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(68);
        }
        HtmlBuilder answer = new HtmlBuilder();
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (!skipQuickDoc && answer.isEmpty()) {
            this.addQuickDoc(element, originalElement, answer);
        }
        try {
            PsiElement targetElem;
            String exprInfo;
            if (!answer.isEmpty() && !StringUtil.isEmptyOrSpaces((String)(exprInfo = this.getEvaluatedExpressionInfo(targetElem = CidrDocumentationProvider.canUseOriginalElementForExprEval(originalElement) ? originalElement : element)))) {
                HtmlChunk.Element content = HtmlChunk.p().addRaw(exprInfo);
                answer.append((HtmlChunk)content.wrapWith(DocumentationMarkup.CONTENT_ELEMENT));
            }
        }
        catch (ExecutionException targetElem) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        this.addCommentDoc(element, sb);
        if (!sb.isEmpty()) {
            answer.append(HtmlChunk.raw((String)sb.toString()));
        }
        if ((externalDocumentation = this.getUrlFor(element, originalElement)) != null && externalDocumentation.size() == 1) {
            OCSymbolWithQualifiedName symbol = CppReferenceDocumentationUtil.getSymbolWithQualifiedName(element, false);
            String symbolName = Objects.requireNonNull(symbol).getPresentableName();
            String text = OCBundle.message("qdoc.on.cppreference", symbolName);
            answer.append((HtmlChunk)HtmlChunk.link((String)externalDocumentation.get(0), (String)text).wrapWith(DocumentationMarkup.BOTTOM_ELEMENT));
        }
        return answer.isEmpty() ? null : answer.toString().replace("<p><br/>", "<p>");
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull HtmlBuilder answer) {
        String quickDoc;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(69);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(70);
        }
        if ((quickDoc = this.quickDocContent(element, originalElement, true)) != null) {
            answer.append(HtmlChunk.raw((String)quickDoc));
        }
    }

    private void addMacroDoc(@Nullable PsiElement originalElement, @NotNull HtmlBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file;
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(71);
        }
        if (define == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(72);
        }
        if (answer.isEmpty() && (file = define.getContainingFile()) != null) {
            answer.append((HtmlChunk)CidrDocumentationProvider.declaredInHint(file));
        }
        answer.append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.definition", new Object[0])).bold().wrapWith(DocumentationMarkup.TOP_ELEMENT)).append((HtmlChunk)HtmlChunk.raw((String)HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros()).replaceAll("[ ]+\n", "\n")).wrapWith(DocumentationMarkup.DEFINITION_ELEMENT));
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)OCPsiFile.tryGetElementFromOCFile(originalElement), (Class[])new Class[]{OCMacroCall.class});
        if (macroCall != null) {
            answer.append((HtmlChunk)HtmlChunk.text((String)OCBundle.message("qdoc.replacement", new Object[0])).bold().wrapWith(DocumentationMarkup.TOP_ELEMENT)).append((HtmlChunk)HtmlChunk.raw((String)HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)CidrDocumentationProvider.getFormattedText(macroCall, macroCall.getReplacementText())).trim()).wrapWith(DocumentationMarkup.DEFINITION_ELEMENT));
        }
    }

    @NotNull
    private static String getFormattedText(@NotNull PsiElement context, @NotNull String replacement) {
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(73);
        }
        if (replacement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(74);
        }
        OCCodeFragment fragment = OCElementFactory.codeFragment(replacement, context.getProject(), context, PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCExpression.class, OCStatement.class}) != null ? OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT : OCTokenTypes.OC_FILE, false, true);
        Document document = FileDocumentManager.getInstance().getDocument(fragment.getViewProvider().getVirtualFile());
        String formattedText = document == null || PsiDocumentManager.getInstance((Project)fragment.getProject()).isCommitted(document) ? fragment.getText() : document.getText();
        String string = formattedText.replaceAll("(\n[ \t\r]*)+\n", "\n");
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String escapeHTML(@NlsSafe @NotNull String text) {
        if (text == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(76);
        }
        String string = StringUtil.escapeXmlEntities((String)text);
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String wrapDocInHtml(@Nls @NotNull String doc) {
        if (doc == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(78);
        }
        String string = "<html><body>" + doc + "</body></html>";
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(79);
        }
        return string;
    }

    private void addCommentDoc(@NotNull PsiElement element, @NlsSafe @NotNull StringBuilder answer) {
        boolean added;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(80);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(81);
        }
        if (!(added = this.addCommentDocForElement(element, answer, null))) {
            List<OCSymbolWithParent> elements = OCDocUtil.getSuperSymbols(element);
            for (OCSymbolWithParent s : elements) {
                PsiElement psiElement = s.locateDefinition(element.getProject());
                if (psiElement == null) continue;
                if (psiElement instanceof OCDeclarator) {
                    psiElement = psiElement.getParent();
                }
                if (!this.addCommentDocForElement(psiElement, answer, (Pair<String, String>)Pair.pair((Object)OCBundle.message("qdoc.description.copied.from", new Object[0]), (Object)OCDocUtil.getLinkHtml(s)))) continue;
                break;
            }
        }
    }

    private boolean addCommentDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer, @Nullable Pair<@NotNull String, @NotNull String> additionalSection) {
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(82);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(83);
        }
        int length = answer.length();
        DoxygenRender dxRender = new DoxygenRender(element);
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(answer, additionalSection);
        } else {
            StringBuilder description = new StringBuilder();
            this.addDocForElement(element, description);
            if (!description.isEmpty()) {
                if (additionalSection != null) {
                    HtmlHelper.renderSections(answer, (String)additionalSection.first, (String)additionalSection.second);
                }
                answer.append("<div class='content'>").append((CharSequence)description).append("</div>");
            }
        }
        return answer.length() > length;
    }

    protected void addDocForElement(@NotNull PsiElement element, @NlsSafe @NotNull StringBuilder answer) {
        String data;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(84);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(85);
        }
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiComment comment : this.findCommentsFor(element)) {
            IElementType type = comment.getTokenType();
            comments.add(comment);
            if (type == OCLexerTokenTypes.EOL_COMMENT) continue;
            content.add(this.processComments(comments));
            comments.clear();
        }
        if (!comments.isEmpty()) {
            content.add(this.processComments(comments));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(data = StringUtil.join(content, (String)"\n")))) {
            answer.append(HtmlChunk.tag((String)"pre").addRaw(data));
        }
    }

    @NotNull
    private String processComments(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(86);
        }
        int commonPaddingIdx = 0x3FFFFFFF;
        ArrayList content = new ArrayList();
        for (PsiComment comment : comments) {
            String text = CidrDocumentationProvider.escapeHTML(this.stripCommentBegin(comment.getText()));
            ArrayList<CallSite> lines = new ArrayList<CallSite>(StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false));
            assert (!lines.isEmpty());
            String fistLine = (String)lines.get(0);
            if (!fistLine.isEmpty()) {
                lines.set(0, (CallSite)((Object)("  " + fistLine)));
            }
            for (String string : lines) {
                int padding = CidrDocumentationProvider.indent(string, comment.getTokenType() != OCLexerTokenTypes.EOL_COMMENT);
                if (padding >= commonPaddingIdx) continue;
                commonPaddingIdx = padding;
            }
            content.addAll(lines);
        }
        int padding = commonPaddingIdx;
        List result = ContainerUtil.map(content, s -> s.substring(Math.min(s.length(), padding)));
        String string = StringUtil.join((Collection)result, (String)"\n");
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(87);
        }
        return string;
    }

    private static int indent(@NotNull String line, boolean processAsterisk) {
        int i;
        if (line == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(88);
        }
        if (line.isEmpty()) {
            return 0x3FFFFFFF;
        }
        for (i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (!processAsterisk || ch != '*') break;
            processAsterisk = false;
        }
        return i < line.length() ? i : 0x3FFFFFFF;
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(89);
        }
        if ("/**/".equals(text)) {
            text = "";
        } else if (text.startsWith("/**") || text.startsWith("/*!") || text.startsWith("///") || text.startsWith("//!")) {
            text = text.substring(3);
        } else if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        String string = text = StringUtil.trimTrailing((String)text, (char)' ');
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(90);
        }
        return string;
    }

    @NotNull
    protected List<PsiComment> findCommentsFor(@Nullable PsiElement element) {
        List<PsiComment> comments = CidrDocumentationProvider.findOCCommentFor(element);
        if (comments.isEmpty() && element instanceof OCSymbolDeclarator) {
            PsiElement associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project);
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition(project)) != null) {
                comments = CidrDocumentationProvider.findOCCommentFor(associatedElement);
            }
        }
        List<PsiComment> list = comments;
        if (list == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(91);
        }
        return list;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return CppReferenceDocumentationUtil.getUrlFor(element);
    }

    @NotNull
    private static List<PsiComment> findOCCommentFor(@Nullable PsiElement elt) {
        if (elt == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(92);
            }
            return list;
        }
        List<PsiComment> list = DoxygenFacade.getCommentScope(elt);
        if (list == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(93);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 22, 33, 34, 36, 37, 48, 51, 52, 58, 62, 64, 75, 77, 79, 87, 90, 91, 92, 93 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredBaseDoc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 3: 
            case 20: 
            case 28: 
            case 31: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sme";
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 48: 
            case 51: 
            case 52: 
            case 58: 
            case 62: 
            case 64: 
            case 75: 
            case 77: 
            case 79: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDoc";
                break;
            }
            case 9: 
            case 11: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 13: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextComment";
                break;
            }
            case 17: 
            case 18: 
            case 35: 
            case 59: 
            case 68: 
            case 69: 
            case 80: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 21: 
            case 30: 
            case 32: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 67: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 43: 
            case 65: 
            case 70: 
            case 71: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 76: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "methodCandidates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanEmptyLinesInDoc";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClassesHtml";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameters";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanAndReformat";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNamePrefixHtml";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "effectiveTypeStringHtml";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "declaredInHint";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "classHintDoc";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "methodHintDoc";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedText";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeHTML";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDocInHtml";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "processComments";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "stripCommentBegin";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsFor";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncDocumentationFlow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluatedExpressionInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildLinkForMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "methodCandidates";
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 48: 
            case 51: 
            case 52: 
            case 58: 
            case 62: 
            case 64: 
            case 75: 
            case 77: 
            case 79: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cleanEmptyLinesInDoc";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMergedComments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canMergeComments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "quickDocContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolDoc";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClassesHtml";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildResult";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processInitializer";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractFunctionSignature";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateParameters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndReformat";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "extractTemplateSpecialization";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addVisibility";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNamePrefixHtml";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "effectiveTypeStringHtml";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "propertyIVarDoc";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIVar";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPropertySymbol";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "declaredInHint";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveIfRequired";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterHintDoc";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "classHintDoc";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "methodHintDoc";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "appendType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "generateDocInnerHtml";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addQuickDoc";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addMacroDoc";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getFormattedText";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "escapeHTML";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "wrapDocInHtml";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addCommentDoc";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addCommentDocForElement";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addDocForElement";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processComments";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "stripCommentBegin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 22, 33, 34, 36, 37, 48, 51, 52, 58, 62, 64, 75, 77, 79, 87, 90, 91, 92, 93 -> new IllegalStateException(string);
        };
    }
}

