/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNode {
    private OCControlFlowGraph myGraph;
    private int myIndex;
    private int myId;
    private OCElementsRange myRange;
    private boolean myFake;
    private List<OCNode> myJumpTargets;
    private List<OCNode> myJumpSources;
    private List<OCNode> myFakeJumpTargets;
    private OCNode myNodeAfterReturn;
    private List<OCInstruction> myInstructions;
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructionsByType;

    public OCNode(@NotNull OCControlFlowGraph graph, int index, int id, boolean isFake) {
        if (graph == null) {
            OCNode.$$$reportNull$$$0(0);
        }
        this.myRange = null;
        this.myGraph = graph;
        this.myIndex = index;
        this.myId = id;
        this.myFake = isFake;
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        OCControlFlowGraph oCControlFlowGraph = this.myGraph;
        if (oCControlFlowGraph == null) {
            OCNode.$$$reportNull$$$0(1);
        }
        return oCControlFlowGraph;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getId() {
        return this.myId;
    }

    public boolean isEmpty() {
        return this == this.myGraph.getLastAddedNode() && this.myRange == null && this.myJumpTargets == null && this.myInstructions == null;
    }

    public boolean isFake() {
        return this.myFake;
    }

    public void addBranch(@NotNull OCNode target) {
        if (target == null) {
            OCNode.$$$reportNull$$$0(2);
        }
        this.addBranch(target, false);
    }

    public void addBranch(@NotNull OCNode target, boolean isFake) {
        if (target == null) {
            OCNode.$$$reportNull$$$0(3);
        }
        assert (this.myGraph == target.myGraph);
        if (this.myJumpTargets == null) {
            this.myJumpTargets = new ArrayList<OCNode>(2);
        } else if (this.myJumpTargets.contains(target)) {
            return;
        }
        if (target.myJumpSources == null) {
            target.myJumpSources = new ArrayList<OCNode>(2);
        }
        this.myJumpTargets.add(target);
        target.myJumpSources.add(this);
        if (isFake) {
            if (this.myFakeJumpTargets == null) {
                this.myFakeJumpTargets = new ArrayList<OCNode>(2);
            }
            this.myFakeJumpTargets.add(target);
        }
    }

    public void enlarge(@NotNull PsiElement element, @NotNull PsiElement parent) {
        if (element == null) {
            OCNode.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            OCNode.$$$reportNull$$$0(5);
        }
        TextRange range = element.getTextRange();
        if (this.myRange == null) {
            this.myRange = new OCElementsRange(this, element, element){

                @Override
                @NotNull
                public TextRange getTextRange() {
                    return new TextRange(this.getStartOffset(), this.getEndOffset());
                }
            };
        } else if (this.myRange.getStartOffset() > range.getStartOffset()) {
            this.myRange.setFirstElement(element);
        } else if (this.myRange.getEndOffset() < range.getEndOffset()) {
            this.myRange.setLastElement(element);
        }
        if (this.myRange.getTextRange().contains(parent.getTextRange())) {
            this.myRange.setContainsCompositeElement(true);
        }
    }

    public void addInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNode.$$$reportNull$$$0(6);
        }
        if (this.myInstructions == null) {
            this.myInstructions = new ArrayList<OCInstruction>();
            this.myInstructionsByType = new MultiMap();
        }
        this.myInstructions.add(instruction);
        this.myInstructionsByType.putValue((Object)instruction.getKind(), (Object)instruction);
    }

    @Nullable
    public List<OCInstruction> getInstructions() {
        return this.myInstructions;
    }

    @Nullable
    public List<OCNode> getJumpTargets() {
        return this.myJumpTargets;
    }

    @Nullable
    public List<OCNode> getJumpSources() {
        return this.myJumpSources;
    }

    @Nullable
    public List<OCNode> getFakeJumpTargets() {
        return this.myFakeJumpTargets;
    }

    @Nullable
    public OCElementsRange getRange() {
        return this.myRange;
    }

    public int getEndOffset() {
        return this.myRange != null ? this.myRange.getEndOffset() : -1;
    }

    @Nullable
    public OCNode getNodeAfterReturn() {
        return this.myNodeAfterReturn;
    }

    public void setNodeAfterReturn(@NotNull OCNode node) {
        if (node == null) {
            OCNode.$$$reportNull$$$0(7);
        }
        this.myNodeAfterReturn = node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBranch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enlarge";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setNodeAfterReturn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

