/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCIncludeCPPAnnotatorKt;
import com.jetbrains.cidr.lang.daemon.OCNavigateIncludeCPP;
import com.jetbrains.cidr.lang.parser.OCPreprocessorDirectiveElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/daemon/OCIncludeCPPAnnotator;", "Lcom/jetbrains/cidr/lang/daemon/OCAnnotator;", "<init>", "()V", "isEnabled", "", "file", "Lcom/intellij/psi/PsiFile;", "visitImportDirective", "", "directive", "Lcom/jetbrains/cidr/lang/psi/OCIncludeDirective;", "doAnnotate", "includeChild", "Lcom/intellij/psi/PsiElement;", "cppChild", "doColorText", "includeRange", "Lcom/intellij/openapi/util/TextRange;", "cppRange", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nOCIncludeCPPAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCIncludeCPPAnnotator.kt\ncom/jetbrains/cidr/lang/daemon/OCIncludeCPPAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n295#2,2:115\n295#2,2:117\n*S KotlinDebug\n*F\n+ 1 OCIncludeCPPAnnotator.kt\ncom/jetbrains/cidr/lang/daemon/OCIncludeCPPAnnotator\n*L\n40#1:115,2\n44#1:117,2\n*E\n"})
public final class OCIncludeCPPAnnotator
extends OCAnnotator {
    @Override
    protected boolean isEnabled(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.isEnabled(file) && PlatformUtils.isCLion();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitImportDirective(@NotNull OCIncludeDirective directive) {
        Object v5;
        PsiElement includeChild;
        block9: {
            void $this$firstOrNull$iv;
            Object v2;
            block8: {
                void $this$firstOrNull$iv2;
                block11: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                        if (this.getHolder() == null) break block10;
                        String string = directive.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!(((CharSequence)string).length() == 0) && directive.getDelimiters() == OCIncludeDirective.Delimiters.ANGLE_BRACKETS && directive.getContainingOCFile().getKind().isCpp() && directive.getIncludedFile() == null) break block11;
                    }
                    return;
                }
                SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)directive);
                Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
                Iterable iterable = (Iterable)syntaxTraverser;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv2) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(OCElementUtil.getElementType(it) instanceof OCPreprocessorDirectiveElementType)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            PsiElement psiElement = v2;
            if (psiElement == null) {
                return;
            }
            includeChild = psiElement;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)directive);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Iterable $i$f$firstOrNull = (Iterable)syntaxTraverser;
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)OCElementUtil.getElementType(it), (Object)OCTokenTypes.HEADER_PATH_LITERAL)) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        PsiElement psiElement = v5;
        if (psiElement == null) {
            return;
        }
        PsiElement cppChild = psiElement;
        if (Intrinsics.areEqual((Object)includeChild.getText(), (Object)"#include") && StringUtil.equalsIgnoreCase((CharSequence)directive.getReferenceText(), (CharSequence)"C++")) {
            this.doAnnotate(directive, includeChild, cppChild);
        }
    }

    private final void doAnnotate(OCIncludeDirective directive, PsiElement includeChild, PsiElement cppChild) {
        OCElementsRange oCElementsRange = new OCElementsRange(directive, directive).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange == null || (oCElementsRange = oCElementsRange.getTextRange()) == null) {
            return;
        }
        OCElementsRange range = oCElementsRange;
        OCElementsRange oCElementsRange2 = new OCElementsRange(includeChild, includeChild).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange2 == null || (oCElementsRange2 = oCElementsRange2.getTextRange()) == null) {
            return;
        }
        OCElementsRange includeRange = oCElementsRange2;
        OCElementsRange oCElementsRange3 = new OCElementsRange(cppChild, cppChild).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange3 == null || (oCElementsRange3 = oCElementsRange3.getTextRange()) == null) {
            return;
        }
        OCElementsRange cppRange = oCElementsRange3;
        AnnotationHolder annotationHolder = this.getHolder();
        Intrinsics.checkNotNull((Object)annotationHolder);
        annotationHolder.newAnnotation(OCIncludeCPPAnnotatorKt.access$getINCLUDE_CPP_HIGHLIGHT_SEVERITY$p(), OCBundle.message("include.cpp.message", new Object[0])).range((TextRange)range).withFix((IntentionAction)new OCNavigateIncludeCPP(directive)).create();
        this.doColorText((TextRange)includeRange, (TextRange)cppRange);
    }

    private final void doColorText(TextRange includeRange, TextRange cppRange) {
        int n = includeRange.getLength();
        for (int r = 0; r < n; ++r) {
            TextRange subRange = new TextRange(r, r + 1);
            TextAttributes attributes = new TextAttributes();
            attributes.setForegroundColor((Color)OCIncludeCPPAnnotatorKt.access$getRAINBOW_COLORS$p()[r % OCIncludeCPPAnnotatorKt.access$getRAINBOW_COLORS$p().length]);
            AnnotationHolder annotationHolder = this.getHolder();
            Intrinsics.checkNotNull((Object)annotationHolder);
            annotationHolder.newAnnotation(HighlightSeverity.INFORMATION, "").range(includeRange.cutOut(subRange)).enforcedTextAttributes(attributes).create();
        }
        TextAttributes attributes = new TextAttributes();
        attributes.setForegroundColor((Color)OCIncludeCPPAnnotatorKt.access$getCPP_COLOR$p());
        AnnotationHolder annotationHolder = this.getHolder();
        Intrinsics.checkNotNull((Object)annotationHolder);
        annotationHolder.newAnnotation(HighlightSeverity.INFORMATION, "").range(cppRange).enforcedTextAttributes(attributes).create();
    }
}

