/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGetSymbolVisitor
extends OCVisitor {
    private OCSymbol mySymbol;
    private int numOfDereferences;
    private boolean wasUnresolvedSymbol;
    private final boolean myProcessCalls;
    @NotNull
    private final OCResolveContext myContext;

    public OCGetSymbolVisitor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCGetSymbolVisitor.$$$reportNull$$$0(0);
        }
        this(false, context);
    }

    public OCGetSymbolVisitor(boolean processCalls, @NotNull OCResolveContext context) {
        if (context == null) {
            OCGetSymbolVisitor.$$$reportNull$$$0(1);
        }
        this.myProcessCalls = processCalls;
        this.myContext = context;
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        expression.processTargets(expression.getSymbolName(), (Processor<OCSymbol>)collector, false, null, true, false, null, this.myContext);
        this.mySymbol = (OCSymbol)collector.getFoundValue();
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        OCElementTypes.SelfSuperToken token = expression.getSelfSuperToken();
        if (token != null) {
            this.wasUnresolvedSymbol = token == OCElementTypes.SelfSuperToken.SELF;
            return;
        }
        this.mySymbol = expression.resolveToSymbol(this.myContext);
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        if (this.myProcessCalls) {
            expression.getFunctionReferenceExpression().accept(this);
        } else if (expression.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        if (expression.getOperationSign() == OCLexerTokenTypes.EQ) {
            expression.getReceiverExpression().accept(this);
        }
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        if (this.myProcessCalls) {
            List<OCMethodSymbol> symbols = expression.getProbableResponders().getFilteredByStaticnessResponders();
            if (symbols.size() == 1) {
                this.mySymbol = symbols.get(0);
            }
        } else if (expression.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        OCElementType sign = expression.getOperationSign();
        OCExpression operand = expression.getOperand();
        if (sign == OCLexerTokenTypes.MUL) {
            ++this.numOfDereferences;
            if (operand != null) {
                operand.accept(this);
            }
        } else if ((sign == OCLexerTokenTypes.__IMAG__KEYWORD || sign == OCLexerTokenTypes.__REAL__KEYWORD) && operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        ++this.numOfDereferences;
        expression.getArrayExpression().accept(this);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.mySymbol = lambdaExpression.getSymbol();
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public int getNumOfDereferences() {
        return this.numOfDereferences;
    }

    public boolean wasUnresolvedSymbol() {
        return this.wasUnresolvedSymbol;
    }

    @Nullable
    public static OCSymbol getSymbol(OCExpression expr) {
        return expr == null ? null : OCGetSymbolVisitor.getSymbol(expr, OCResolveContext.forPsi(expr));
    }

    @Nullable
    public static OCSymbol getSymbol(OCExpression expr, @NotNull OCResolveContext context) {
        if (context == null) {
            OCGetSymbolVisitor.$$$reportNull$$$0(2);
        }
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(context);
        if (expr != null) {
            expr.accept(visitor);
        }
        return visitor.getSymbol();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCGetSymbolVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

