/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCAutoImportHelper {
    public static final ExtensionPointName<OCAutoImportHelper> EP_NAME = ExtensionPointName.create((String)"cidr.lang.autoImportHelper");

    public boolean supports(@NotNull OCResolveRootAndConfiguration var1);

    public boolean processPathSpecificationToInclude(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3, @NotNull OCResolveRootAndConfiguration var4, @NotNull Processor<ImportSpecification> var5);

    public void addHeaderSearchPath(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3);

    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3);

    public static class ImportSpecification {
        @NotNull
        private final String myPath;
        @NotNull
        private final Kind myKind;
        private final boolean myAddSearchPath;
        @NotNull
        private final EnumSet<OCIncludeDirective.Delimiters> myPossibleDelimiters;
        private final boolean myUnderSearchPath;

        public ImportSpecification(@NotNull String path, @NotNull Kind kind) {
            if (path == null) {
                ImportSpecification.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(1);
            }
            this(path, kind, false);
        }

        public ImportSpecification(@NotNull String path, @NotNull Kind kind, boolean addSearchPath) {
            if (path == null) {
                ImportSpecification.$$$reportNull$$$0(2);
            }
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(3);
            }
            this(path, kind, addSearchPath, true);
        }

        public ImportSpecification(@NotNull String path, @NotNull Kind kind, boolean addSearchPath, boolean underSearchPath) {
            if (path == null) {
                ImportSpecification.$$$reportNull$$$0(4);
            }
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(5);
            }
            this.myPath = path;
            this.myKind = kind;
            this.myAddSearchPath = addSearchPath;
            this.myUnderSearchPath = underSearchPath;
            EnumSet<OCIncludeDirective.Delimiters> possibleDelimiters = kind.isSystemHeaderSearchPath() ? EnumSet.of(OCIncludeDirective.Delimiters.ANGLE_BRACKETS, OCIncludeDirective.Delimiters.QUOTES) : EnumSet.of(OCIncludeDirective.Delimiters.QUOTES);
            possibleDelimiters.add(OCIncludeDirective.Delimiters.NONE);
            this.myPossibleDelimiters = possibleDelimiters;
            assert (this.myPossibleDelimiters.contains((Object)this.getPreferredDelimiters()));
        }

        @NotNull
        public String getImportText() {
            String string = this.getImportText(this.getPreferredDelimiters());
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getImportText(@NotNull OCIncludeDirective.Delimiters delimiters) {
            int dotIndex;
            if (delimiters == null) {
                ImportSpecification.$$$reportNull$$$0(7);
            }
            String importText = this.getImportPath();
            if (delimiters == OCIncludeDirective.Delimiters.NONE && (dotIndex = importText.lastIndexOf(46)) > 0) {
                importText = importText.substring(0, dotIndex);
            }
            String string = delimiters.getBeforeText() + importText + delimiters.getAfterText();
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getImportPath() {
            String string = this.myPath;
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        public Kind getKind() {
            Kind kind = this.myKind;
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(10);
            }
            return kind;
        }

        public boolean shouldAddSearchPath() {
            return this.myAddSearchPath;
        }

        public boolean isUnderSearchPath() {
            return this.myUnderSearchPath;
        }

        public boolean areDelimitersAllowed(OCIncludeDirective.Delimiters d) {
            return this.myPossibleDelimiters.contains((Object)d);
        }

        @NotNull
        public OCIncludeDirective.Delimiters getPreferredDelimiters() {
            OCIncludeDirective.Delimiters delimiters = this.myKind.isSystemHeaderSearchPath() ? OCIncludeDirective.Delimiters.ANGLE_BRACKETS : OCIncludeDirective.Delimiters.QUOTES;
            if (delimiters == null) {
                ImportSpecification.$$$reportNull$$$0(11);
            }
            return delimiters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportText";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredDelimiters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getImportText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }

        public static enum Kind {
            PROJECT_HEADER,
            USER_HEADER_SEARCH_PATH,
            SYSTEM_HEADER_SEARCH_PATH,
            BUILTIN_HEADER_SEARCH_PATH,
            USER_FRAMEWORK_HEADER_SEARCH_PATH,
            FRAMEWORK_HEADER_SEARCH_PATH;


            @NotNull
            public static Kind fromHeaderSearchPathKind(@NotNull HeadersSearchPath.Kind kind) {
                if (kind == null) {
                    Kind.$$$reportNull$$$0(0);
                }
                Kind kind2 = switch (kind) {
                    default -> throw new MatchException(null, null);
                    case HeadersSearchPath.Kind.BUILTIN -> BUILTIN_HEADER_SEARCH_PATH;
                    case HeadersSearchPath.Kind.SYSTEM -> SYSTEM_HEADER_SEARCH_PATH;
                    case HeadersSearchPath.Kind.USER -> USER_HEADER_SEARCH_PATH;
                    case HeadersSearchPath.Kind.FRAMEWORK -> FRAMEWORK_HEADER_SEARCH_PATH;
                    case HeadersSearchPath.Kind.USER_FRAMEWORK -> USER_FRAMEWORK_HEADER_SEARCH_PATH;
                };
                if (kind2 == null) {
                    Kind.$$$reportNull$$$0(1);
                }
                return kind2;
            }

            public boolean isSystemHeaderSearchPath() {
                return this == BUILTIN_HEADER_SEARCH_PATH || this == SYSTEM_HEADER_SEARCH_PATH || this == FRAMEWORK_HEADER_SEARCH_PATH;
            }

            public boolean isFrameworkSearchPath() {
                return this == FRAMEWORK_HEADER_SEARCH_PATH || this == USER_FRAMEWORK_HEADER_SEARCH_PATH;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification$Kind";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification$Kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fromHeaderSearchPathKind";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fromHeaderSearchPathKind";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }
}

