/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.components;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.clangFormat.ClangFormatCoroutineScope;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.fus.ClangFormatUsageCollector;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/clangFormat/components/ClangFormatTracker;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.cidr.clangFormat.common"})
public final class ClangFormatTracker
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String clangFormatFirstCheck = "cf.first.check.clang-format";

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        CoroutineScope coroutineScope = ClangFormatCoroutineScope.Companion.getInstance(project).getCoroutineScope();
        Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope);
        Companion.activateClangFormatTracker(project, disposable);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @VisibleForTesting
    public static final void activateClangFormatTracker(@NotNull Project project, @NotNull Disposable disposable) {
        Companion.activateClangFormatTracker(project, disposable);
    }

    @JvmStatic
    public static final void activateClangFormatFileTracker(@NotNull Project project, @NotNull Disposable disposable) {
        Companion.activateClangFormatFileTracker(project, disposable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/clangFormat/components/ClangFormatTracker$Companion;", "", "<init>", "()V", "activateClangFormatTracker", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "checkClangFormatIsOnByDefaultIfClangFormatFileExists", "clangFormatFirstCheck", "", "Lorg/jetbrains/annotations/NonNls;", "isFirstCheck", "", "activateClangdTracker", "notifyClangdAboutFormatActivity", "pluginOn", "activateClangFormatFileTracker", "intellij.cidr.clangFormat.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        public final void activateClangFormatTracker(@NotNull Project project, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.notifyClangdAboutFormatActivity(project, true);
            this.activateClangdTracker(project, disposable);
            this.activateClangFormatFileTracker(project, disposable);
            this.checkClangFormatIsOnByDefaultIfClangFormatFileExists(project);
        }

        private final void checkClangFormatIsOnByDefaultIfClangFormatFileExists(Project project) {
            VirtualFile clangFormatRootDir = ClangFormatUtils.getClangFormatRootDir(project);
            if (clangFormatRootDir != null && this.isFirstCheck(project)) {
                if (ClangFormatFileUtils.hasClangFormatFileInDirectory(clangFormatRootDir, ".clang-format") || ClangFormatFileUtils.hasClangFormatFileInDirectory(clangFormatRootDir, "_clang-format")) {
                    ClangFormatUsageCollector.clangFormatFileExistsInImportedProject.log(project, (Object)true);
                    if (!((ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ClangFormatSettings.class)).ENABLED) {
                        ApplicationManager.getApplication().invokeLater(() -> Companion.checkClangFormatIsOnByDefaultIfClangFormatFileExists$lambda$0(project));
                    }
                } else {
                    ClangFormatUsageCollector.clangFormatFileExistsInImportedProject.log(project, (Object)false);
                }
            }
        }

        private final boolean isFirstCheck(Project project) {
            PropertiesComponent projectProperties = PropertiesComponent.getInstance((Project)project);
            if (!projectProperties.getBoolean(ClangFormatTracker.clangFormatFirstCheck, true)) {
                return false;
            }
            projectProperties.setValue(ClangFormatTracker.clangFormatFirstCheck, false, true);
            return true;
        }

        private final void activateClangdTracker(Project project, Disposable disposable) {
            CodeStyleSettingsListener listener = arg_0 -> Companion.activateClangdTracker$lambda$0(project, arg_0);
            CodeStyleSettingsManager.getInstance((Project)project).subscribe(listener, disposable);
            Disposer.register((Disposable)disposable, () -> Companion.activateClangdTracker$lambda$1(project));
            MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
            Topic topic = ClangdSettingsListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ClangdSettingsListener(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public void onClangdOnChanged(boolean clangdOn) {
                    if (!clangdOn && ((ClangFormatSettings)CodeStyle.getSettings((Project)this.$project).getCustomSettings(ClangFormatSettings.class)).ENABLED) {
                        ClangFormatUtils.setClangFormatEnabled(this.$project, false, false);
                    } else {
                        ClangFormatUtils.fireClangFormatChanged(this.$project);
                    }
                }
            });
        }

        private final void notifyClangdAboutFormatActivity(Project project, boolean pluginOn) {
            if (project.isDisposed()) {
                return;
            }
            ClangFormatSettings cf = (ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettingsIfCreated(ClangFormatSettings.class);
            boolean formatViaClangd = cf != null && cf.ENABLED && pluginOn;
            ClangdSettings clangdSettings = ClangdSettings.getInstance((Project)project);
            clangdSettings.setFormatViaClangd(formatViaClangd);
            if (formatViaClangd && ApplicationKt.getApplication().isUnitTestMode()) {
                clangdSettings.setClangdEnabled(true);
            }
        }

        @JvmStatic
        public final void activateClangFormatFileTracker(@NotNull Project project, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public void propertyChanged(VirtualFilePropertyEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName()) && (ClangFormatFileUtils.isClangFormatName((String)event.getNewValue()) || ClangFormatFileUtils.isClangFormatName((String)event.getOldValue()))) {
                        ClangFormatUtils.fireClangFormatChanged(this.$project);
                    }
                }

                public void fileCreated(VirtualFileEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.notifyMaybeClangFormatFileChange(event);
                }

                public void fileDeleted(VirtualFileEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.notifyMaybeClangFormatFileChange(event);
                }

                public void contentsChanged(VirtualFileEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.notifyMaybeClangFormatFileChange(event);
                }

                public final void notifyMaybeClangFormatFileChange(VirtualFileEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    VirtualFile vfChangedFile = virtualFile;
                    if (ClangFormatFileUtils.isClangFormatConfig(vfChangedFile)) {
                        ClangFormatUtils.fireClangFormatChanged(this.$project);
                    }
                }
            }, disposable);
        }

        private static final void checkClangFormatIsOnByDefaultIfClangFormatFileExists$lambda$0(Project $project) {
            ClangFormatUtils.setClangFormatEnabled($project, true, true);
        }

        private static final void activateClangdTracker$lambda$0(Project $project, CodeStyleSettingsChangeEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ClangFormatChangeSettingsProvider.syncCurrentClangFormatSettings($project, CodeStyle.getSettings((Project)$project), false);
            Companion.notifyClangdAboutFormatActivity($project, true);
        }

        private static final void activateClangdTracker$lambda$1(Project $project) {
            Companion.notifyClangdAboutFormatActivity($project, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

