/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.table.JBTable;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionActionStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lastEditor", "Lcom/intellij/openapi/editor/Editor;", "getLastEditor", "()Lcom/intellij/openapi/editor/Editor;", "setLastEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "fileStats", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "getFileStats", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "setFileStats", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;)V", "createTable", "Ljavax/swing/JPanel;", "Columns", "EditorEventListener", "FileStats", "intellij.cidr.clangd.toolwindow"})
@SourceDebugExtension(value={"SMAP\nClangdTimingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdTimingsPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1011#2,2:131\n*S KotlinDebug\n*F\n+ 1 ClangdTimingsPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel\n*L\n113#1:131,2\n*E\n"})
public final class ClangdTimingsPanel
extends ClangdPanelBase {
    @Nullable
    private volatile Editor lastEditor;
    @Nullable
    private volatile FileStats fileStats;

    public ClangdTimingsPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.add(this.createTable(project));
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)new EditorEventListener(), (Disposable)this);
        }
    }

    @Nullable
    public final Editor getLastEditor() {
        return this.lastEditor;
    }

    public final void setLastEditor(@Nullable Editor editor) {
        this.lastEditor = editor;
    }

    @Nullable
    public final FileStats getFileStats() {
        return this.fileStats;
    }

    public final void setFileStats(@Nullable FileStats fileStats) {
        this.fileStats = fileStats;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createTable(Project project) {
        void it;
        JPanel jPanel;
        JLabel fileLabel = new JLabel("File: ");
        AbstractTableModel tableModel2 = new AbstractTableModel(this){
            final /* synthetic */ ClangdTimingsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public int getRowCount() {
                Object object = this.this$0.getFileStats();
                return (object != null && (object = ((FileStats)object).getActions()) != null ? object.size() : 0) + 1;
            }

            public int getColumnCount() {
                return 5;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                Object object;
                if (rowIndex == 0) {
                    int n = columnIndex;
                    return n == Columns.NAME.getIndex() ? "Action" : (n == Columns.AVERAGE.getIndex() ? "Avg." : (n == Columns.LAST.getIndex() ? "Last" : (n == Columns.TOTAL.getIndex() ? "Total" : (n == Columns.COUNT.getIndex() ? "Count" : null))));
                }
                int row = rowIndex - 1;
                int n = columnIndex;
                if (n == Columns.NAME.getIndex()) {
                    object = this.this$0.getFileStats();
                    if (object == null || (object = ((FileStats)object).getActions()) == null || (object = (ClionActionStats)object.get(row)) == null || (object = object.getName()) == null) {
                        object = "Impossible";
                    }
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    object = n == Columns.AVERAGE.getIndex() ? this.formatMs(this.average((object5 = this.this$0.getFileStats()) != null && (object5 = ((FileStats)object5).getActions()) != null ? (ClionActionStats)object5.get(row) : null)) : (n == Columns.LAST.getIndex() ? this.formatMs((object4 = this.this$0.getFileStats()) != null && (object4 = ((FileStats)object4).getActions()) != null && (object4 = (ClionActionStats)object4.get(row)) != null ? Long.valueOf(object4.getLastTimeMs()) : null) : (n == Columns.TOTAL.getIndex() ? this.formatMs((object3 = this.this$0.getFileStats()) != null && (object3 = ((FileStats)object3).getActions()) != null && (object3 = (ClionActionStats)object3.get(row)) != null ? Long.valueOf(object3.getTotalTimeMs()) : null) : (n == Columns.COUNT.getIndex() ? Integer.valueOf((object2 = this.this$0.getFileStats()) != null && (object2 = ((FileStats)object2).getActions()) != null && (object2 = (ClionActionStats)object2.get(row)) != null ? object2.getCounter() : 0) : null)));
                }
                return object;
            }

            public final String formatMs(Long time) {
                if (time == null) {
                    return "0 ms";
                }
                return time + " ms";
            }

            public final String formatMs(double time) {
                String string = "%.2f";
                Object[] objectArray = new Object[]{time};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2 + " ms";
            }

            public final double average(ClionActionStats stats) {
                return stats == null ? 0.0 : (double)stats.getTotalTimeMs() / (double)stats.getCounter();
            }
        };
        JBTable table = new JBTable((TableModel)tableModel2);
        table.setTableHeader(new JTableHeader());
        JButton button = new JButton("Refresh!");
        button.addActionListener(arg_0 -> ClangdTimingsPanel.createTable$lambda$0(this, project, fileLabel, table, arg_0));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)button, "First");
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        JPanel jPanel3 = centerPanel;
        boolean bl = false;
        it.add((Component)fileLabel, "First");
        it.add((Component)table, "Center");
        jPanel3.add((Component)jPanel, "Center");
        return centerPanel;
    }

    private static final void createTable$lambda$0(ClangdTimingsPanel this$0, Project $project, JLabel $fileLabel, JBTable $table, ActionEvent it) {
        block3: {
            Editor editor = this$0.lastEditor;
            if (editor == null) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (!ClangdBridge.isSupported((Project)$project, (VirtualFile)virtualFile)) break block3;
            if (virtualFile == null) {
                return;
            }
            Object object = ClangLanguageServiceProvider.getIfStarted((Project)$project);
            if (object != null && (object = object.requestTimingStats(virtualFile)) != null) {
                ((CompletableFuture)object).thenAccept(arg_0 -> ClangdTimingsPanel.createTable$lambda$0$1(arg_0 -> ClangdTimingsPanel.createTable$lambda$0$0(this$0, $fileLabel, $table, arg_0), arg_0));
            }
        }
    }

    private static final Unit createTable$lambda$0$0(ClangdTimingsPanel this$0, JLabel $fileLabel, JBTable $table, ClionFileStats it) {
        if (it == null) {
            return Unit.INSTANCE;
        }
        Map map = it.getActions();
        Intrinsics.checkNotNull((Object)map);
        ArrayList sortedActionsStats = new ArrayList(map.values());
        List $this$sortBy$iv = sortedActionsStats;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ClionActionStats it = (ClionActionStats)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ClionActionStats)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }
        String string = it.getFileName();
        Intrinsics.checkNotNull((Object)string);
        this$0.fileStats = new FileStats(string, sortedActionsStats);
        $fileLabel.setText("File: " + it.getFileName());
        $table.updateUI();
        return Unit.INSTANCE;
    }

    private static final void createTable$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$Columns;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "NAME", "AVERAGE", "LAST", "TOTAL", "COUNT", "intellij.cidr.clangd.toolwindow"})
    private static final class Columns
    extends Enum<Columns> {
        private final int index;
        public static final /* enum */ Columns NAME = new Columns(0);
        public static final /* enum */ Columns AVERAGE = new Columns(1);
        public static final /* enum */ Columns LAST = new Columns(2);
        public static final /* enum */ Columns TOTAL = new Columns(3);
        public static final /* enum */ Columns COUNT = new Columns(4);
        private static final /* synthetic */ Columns[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Columns(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Columns[] values() {
            return (Columns[])$VALUES.clone();
        }

        public static Columns valueOf(String value) {
            return Enum.valueOf(Columns.class, value);
        }

        @NotNull
        public static EnumEntries<Columns> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = columnsArray = new Columns[]{Columns.NAME, Columns.AVERAGE, Columns.LAST, Columns.TOTAL, Columns.COUNT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$EditorEventListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel;)V", "focusGained", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "intellij.cidr.clangd.toolwindow"})
    public final class EditorEventListener
    implements FocusChangeListener {
        public void focusGained(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ClangdTimingsPanel.this.setLastEditor(editor);
        }

        public void focusLost(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdTimingsPanel$FileStats;", "", "fileName", "", "actions", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionActionStats;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getFileName", "()Ljava/lang/String;", "getActions", "()Ljava/util/List;", "intellij.cidr.clangd.toolwindow"})
    public static final class FileStats {
        @NotNull
        private final String fileName;
        @NotNull
        private final List<ClionActionStats> actions;

        public FileStats(@NotNull String fileName, @NotNull List<ClionActionStats> actions) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            this.fileName = fileName;
            this.actions = actions;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final List<ClionActionStats> getActions() {
            return this.actions;
        }
    }
}

