/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ChangeCpp20ModuleMapAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ChangeStdLibModuleMapAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangExecuteCommandAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdDumpServerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdLogPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.CloseClangdToolWindowAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetClangdProjectData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetInputMirrorFileAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetTraceFileAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lastEditor", "Lcom/intellij/openapi/editor/Editor;", "SetCompileCommandAction", "intellij.cidr.clangd.toolwindow"})
public final class ClangdLogPanel
extends ClangdPanelBase {
    @Nullable
    private Editor lastEditor;

    public ClangdLogPanel(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        final ConsoleView consoleView2 = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)consoleView2));
        this.add(consoleView2.getComponent());
        ConsoleViewImpl consoleViewImpl = consoleView2 instanceof ConsoleViewImpl ? (ConsoleViewImpl)consoleView2 : null;
        if (consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null && (consoleViewImpl = consoleViewImpl.getSettings()) != null) {
            consoleViewImpl.setUseSoftWraps(false);
        }
        TextAttributes methodHighlightAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Pattern methodPattern = Pattern.compile("\"method\": \"(.*?)\"");
        consoleView2.addMessageFilter((arg_0, arg_1) -> ClangdLogPanel._init_$lambda$0(methodPattern, methodHighlightAttrs, arg_0, arg_1));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangServerListener(){

            public void onMessage(Message message, boolean incoming) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String string = message.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String contents = string;
                ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted((Project)project);
                if (clangLanguageService != null && (clangLanguageService = clangLanguageService.getContext()) != null && (clangLanguageService = clangLanguageService.getMessagesFilter()) != null) {
                    boolean it = clangLanguageService.matchesBlockedCommunication(contents);
                    boolean bl = false;
                    if (it) {
                        return;
                    }
                }
                Function0 edt = () -> 2.onMessage$lambda$1(incoming, consoleView2, contents, this);
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> 2.onMessage$lambda$2(edt));
            }

            private static final Unit onMessage$lambda$1(boolean $incoming, ConsoleView $consoleView, String $contents, ClangdLogPanel this$0) {
                String string = ClangdLogPanelKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis());
                Intrinsics.checkNotNull((Object)string);
                String linkText = string + " " + ($incoming ? "-->" : "<--");
                $consoleView.printHyperlink(linkText, arg_0 -> 2.onMessage$lambda$1$0(this$0, $contents, linkText, arg_0));
                $consoleView.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                $consoleView.print(ClangdLogPanelKt.access$toOneLine($contents), ConsoleViewContentType.NORMAL_OUTPUT);
                $consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                return Unit.INSTANCE;
            }

            private static final void onMessage$lambda$1$0(ClangdLogPanel this$0, String $contents, String $linkText, Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClangdLogPanelKt.access$showJsonInEditor(it, this$0.truncateIfNecessary($contents), $linkText);
            }

            private static final void onMessage$lambda$2(Function0 $tmp0) {
                $tmp0.invoke();
            }
        });
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener(new FocusChangeListener(){

                public void focusGained(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    lastEditor = editor;
                }
            }, (Disposable)this);
        }
        AnAction[] anActionArray = new AnAction[9];
        Intrinsics.checkNotNullExpressionValue((Object)ActionManager.getInstance().getAction("ClangdCrashServer"), (String)"getAction(...)");
        anActionArray[1] = new ClangdDumpServerState();
        anActionArray[2] = new SetInputMirrorFileAction();
        anActionArray[3] = new SetTraceFileAction();
        anActionArray[4] = new SetCompileCommandAction();
        anActionArray[5] = new ClangExecuteCommandAction();
        anActionArray[6] = new ChangeCpp20ModuleMapAction();
        anActionArray[7] = new ChangeStdLibModuleMapAction();
        anActionArray[8] = new CloseClangdToolWindowAction();
        this.createToolbarWithActions(anActionArray);
    }

    private static final Filter.Result _init_$lambda$0(Pattern $methodPattern, TextAttributes $methodHighlightAttrs, String line, int length) {
        Filter.Result result;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = $methodPattern.matcher(line);
        int lineStartOffset = length - line.length();
        if (matcher.find()) {
            int groupStart = lineStartOffset + matcher.start(1);
            int groupEnd = lineStartOffset + matcher.end(1);
            result = new Filter.Result(groupStart, groupEnd, null, $methodHighlightAttrs);
        } else {
            result = null;
        }
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J$\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u0012\u001a\u00020\u00032\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel$SetCompileCommandAction;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/SetClangdProjectData;", "", "", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel;)V", "getDialogTitle", "project", "Lcom/intellij/openapi/project/Project;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "getValue", "setValue", "", "text", "getCommandsMap", "", "text2CommandLine", "commandLine2Text", "commandLine", "currentFilePath", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.cidr.clangd.toolwindow"})
    public final class SetCompileCommandAction
    extends SetClangdProjectData<List<? extends String>> {
        public SetCompileCommandAction() {
            Icon icon = AllIcons.Actions.Properties;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Properties");
            super("Set compilation command for the current file", icon, "Enter compilation command", "Compilation command for ");
        }

        @Override
        @NotNull
        protected String getDialogTitle(@NotNull Project project, @NotNull DataContext dc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            return super.getDialogTitle(project, dc) + this.currentFilePath(ClangdLogPanel.this.lastEditor);
        }

        @Override
        @NotNull
        protected String getValue(@NotNull Project project, @NotNull DataContext dc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            String filePath = this.currentFilePath(ClangdLogPanel.this.lastEditor);
            if (filePath == null) {
                return "";
            }
            Map<String, List<String>> commandsMap = this.getCommandsMap(project);
            List<String> commandLine = commandsMap.get(filePath);
            return this.commandLine2Text(commandLine);
        }

        @Override
        protected void setValue(@NotNull Project project, @NotNull DataContext dc, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String filePath = this.currentFilePath(ClangdLogPanel.this.lastEditor);
            if (filePath == null) {
                return;
            }
            Map<String, List<String>> commandsMap = this.getCommandsMap(project);
            commandsMap.put(filePath, this.text2CommandLine(text));
        }

        private final Map<String, List<String>> getCommandsMap(Project project) {
            Map commandsMap = (Map)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
            if (commandsMap != null) {
                return commandsMap;
            }
            commandsMap = new HashMap();
            project.putUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS, (Object)commandsMap);
            return commandsMap;
        }

        private final List<String> text2CommandLine(String text) {
            if (text == null) {
                return null;
            }
            return ClangUtils.splitCommandLine((String)text);
        }

        private final String commandLine2Text(List<String> commandLine) {
            if (commandLine == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            boolean rest = false;
            for (String option : commandLine) {
                if (rest) {
                    sb.append(" ");
                }
                sb.append(option);
                rest = true;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String currentFilePath(Editor editor) {
            if (editor == null) {
                return null;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            return virtualFile != null ? virtualFile.getPath() : null;
        }
    }
}

