/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.BuildPreambleError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0002\u001a\u00020\u0003J3\u0010\u0016\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0017\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\u0011\u001a\u00020\tH\u0002J\u0015\u0010\u0018\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u0019\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u001a\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\t\u00a2\u0006\u0002\b\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdInfoPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "mainStatus", "", "getMainStatus", "()Ljava/lang/String;", "setMainStatus", "(Ljava/lang/String;)V", "indexerStatus", "getIndexerStatus", "setIndexerStatus", "statelessIndexerStatus", "getStatelessIndexerStatus", "setStatelessIndexerStatus", "makePreambleStatsText", "Lcom/intellij/openapi/util/NlsSafe;", "makePidText", "status", "makeClangdModulesLine", "makeCpp20ModulesLine", "copyableLabel", "Ljavax/swing/JTextPane;", "text", "intellij.cidr.clangd.toolwindow"})
public final class ClangdInfoPanel
extends ClangdPanelBase {
    @NotNull
    private final Project project;
    @NotNull
    private volatile String mainStatus;
    @NotNull
    private volatile String indexerStatus;
    @NotNull
    private volatile String statelessIndexerStatus;

    /*
     * WARNING - void declaration
     */
    public ClangdInfoPanel(@NotNull Project project) {
        ClangLanguageService clangLanguageService;
        ClangdIndexerService clangdIndexerService;
        ClangdIndexerService clangdIndexerService2;
        void tablesPanel;
        JPanel jPanel;
        void cpp20PathPanel;
        JPanel jPanel2;
        void modulesPathPanel;
        JPanel jPanel3;
        void pidPanel;
        JPanel jPanel4;
        void preamblePanel;
        JPanel jPanel5;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainStatus = "Stopped";
        this.indexerStatus = "Stopped";
        this.statelessIndexerStatus = "Stopped";
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)this.project);
        ClangLanguageService service = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        ClangLanguageServiceProvider clangLanguageServiceProvider2 = ClangLanguageServiceProvider.getProvider((Project)this.project);
        ClangdIndexerService indexer = clangLanguageServiceProvider2 != null ? clangLanguageServiceProvider2.getIfStartedIndexer() : null;
        ClangLanguageServiceProvider clangLanguageServiceProvider3 = ClangLanguageServiceProvider.getProvider((Project)this.project);
        ClangdIndexerService statelessIndexer = clangLanguageServiceProvider3 != null ? clangLanguageServiceProvider3.getIfStartedStatelessIndexer() : null;
        ClangLanguageService clangLanguageService2 = service;
        if (!(clangLanguageService2 != null ? clangLanguageService2.getServerPid() == -1 : false)) {
            this.mainStatus = "Running";
        }
        ClangdIndexerService clangdIndexerService3 = indexer;
        if (!(clangdIndexerService3 != null ? clangdIndexerService3.getServerPid() == -1 : false)) {
            this.indexerStatus = "Running";
        }
        ClangdIndexerService clangdIndexerService4 = statelessIndexer;
        if (!(clangdIndexerService4 != null ? clangdIndexerService4.getServerPid() == -1 : false)) {
            this.statelessIndexerStatus = "Running";
        }
        final JTextPane memoryLabel = this.copyableLabel("Memory usage info: N/A");
        final JTextPane preambleLabel = this.copyableLabel(this.makePreambleStatsText(this.project));
        final JTextPane pidLabel = this.copyableLabel(this.makePidText(this.project, this.mainStatus, this.indexerStatus, this.statelessIndexerStatus));
        JTextPane modulesPathLabel = this.copyableLabel(this.makeClangdModulesLine(this.project));
        JTextPane cpp20ModulesPathLabel = this.copyableLabel(this.makeCpp20ModulesLine(this.project));
        AbstractTableModel perFileModel2 = new AbstractTableModel(){
            private List<ClangMemoryUsageInfo.PerFile> perFile;
            {
                this.perFile = CollectionsKt.emptyList();
            }

            public final List<ClangMemoryUsageInfo.PerFile> getPerFile() {
                return this.perFile;
            }

            public final void setPerFile(List<ClangMemoryUsageInfo.PerFile> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.perFile = list;
            }

            public int getRowCount() {
                return this.perFile.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public String getValueAt(int rowIndex, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> this.perFile.get(rowIndex).getPath();
                    case 1 -> ClangdInfoPanelKt.access$kb2Mb(this.perFile.get(rowIndex).getKb());
                    default -> null;
                };
            }
        };
        AbstractTableModel perModuleModel2 = new AbstractTableModel(){
            private List<Pair<String, Integer>> perModule;
            {
                this.perModule = CollectionsKt.emptyList();
            }

            public final List<Pair<String, Integer>> getPerModule() {
                return this.perModule;
            }

            public final void setPerModule(List<Pair<String, Integer>> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.perModule = list;
            }

            public int getRowCount() {
                return this.perModule.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public String getValueAt(int rowIndex, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> (String)this.perModule.get(rowIndex).getFirst();
                    case 1 -> String.valueOf(((Number)this.perModule.get(rowIndex).getSecond()).intValue());
                    default -> null;
                };
            }
        };
        JBTable modulesTable = new JBTable((TableModel)perModuleModel2);
        JBTable table = new JBTable((TableModel)perFileModel2);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)memoryLabel, "First");
        JPanel jPanel6 = jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel7 = centerPanel;
        boolean bl = false;
        preamblePanel.add((Component)preambleLabel, "First");
        JPanel jPanel8 = jPanel4 = new JPanel(new BorderLayout());
        void var20_21 = preamblePanel;
        boolean bl2 = false;
        pidPanel.add((Component)pidLabel, "First");
        JPanel jPanel9 = jPanel3 = new JPanel(new BorderLayout());
        void var24_25 = pidPanel;
        boolean bl3 = false;
        modulesPathPanel.add((Component)modulesPathLabel, "First");
        JPanel jPanel10 = jPanel2 = new JPanel(new BorderLayout());
        void var28_29 = modulesPathPanel;
        boolean bl4 = false;
        cpp20PathPanel.add((Component)cpp20ModulesPathLabel, "First");
        JPanel jPanel11 = jPanel = new JPanel();
        void var32_33 = cpp20PathPanel;
        boolean bl5 = false;
        tablesPanel.setLayout(new BoxLayout((Container)tablesPanel, 3));
        JLabel modulesLabel = new JLabel(ClangdBundle.message((String)"language.cpp.clangd.info.panel.per.module.label", (Object[])new Object[0]));
        modulesLabel.setAlignmentX(0.0f);
        JLabel filesLabel = new JLabel(ClangdBundle.message((String)"language.cpp.clangd.info.panel.per.file.label", (Object[])new Object[0]));
        filesLabel.setAlignmentX(0.0f);
        modulesTable.setAlignmentX(0.0f);
        table.setAlignmentX(0.0f);
        tablesPanel.add(modulesLabel);
        tablesPanel.add((Component)modulesTable);
        tablesPanel.add(filesLabel);
        tablesPanel.add((Component)table);
        var32_33.add(jPanel);
        var28_29.add(jPanel2);
        var24_25.add(jPanel3);
        var20_21.add(jPanel4);
        jPanel7.add((Component)jPanel5, "Center");
        this.add(centerPanel);
        ClangLanguageService clangLanguageService3 = service;
        if (clangLanguageService3 != null && (clangLanguageService3 = clangLanguageService3.getMessageBus()) != null && (clangLanguageService3 = clangLanguageService3.connect((Disposable)this)) != null) {
            Topic topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            clangLanguageService3.subscribe(topic, (Object)new ClangServerListener(perFileModel2, table){
                final /* synthetic */ perFileModel.1 $perFileModel;
                final /* synthetic */ JBTable $table;
                {
                    this.$perFileModel = $perFileModel;
                    this.$table = $table;
                }

                public void onServerRunning() {
                    this.setMainStatus("Running");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerFailure() {
                    this.setMainStatus("Failure");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerShutDown() {
                    this.setMainStatus("Shut Down");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onMemoryUsageInfoReceived(ClangMemoryUsageInfo info) {
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    memoryLabel.setText("Memory usage info: working set: " + ClangdInfoPanelKt.access$kb2Mb(info.getWorkingSet()) + ", drafts: " + ClangdInfoPanelKt.access$kb2Mb(info.getDrafts()) + ", unsaved: " + ClangdInfoPanelKt.access$kb2Mb(info.getUnsaved()));
                    this.$perFileModel.setPerFile(info.getPerFile());
                    this.$table.updateUI();
                }
            });
        }
        if ((clangdIndexerService2 = indexer) != null && (clangdIndexerService2 = clangdIndexerService2.getMessageBus()) != null && (clangdIndexerService2 = clangdIndexerService2.connect((Disposable)this)) != null) {
            Topic topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            clangdIndexerService2.subscribe(topic, (Object)new ClangServerListener(){

                public void onServerRunning() {
                    this.setIndexerStatus("Running");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerFailure() {
                    this.setIndexerStatus("Failure");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerShutDown() {
                    this.setIndexerStatus("Shut Down");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }
            });
        }
        if ((clangdIndexerService = statelessIndexer) != null && (clangdIndexerService = clangdIndexerService.getMessageBus()) != null && (clangdIndexerService = clangdIndexerService.connect((Disposable)this)) != null) {
            Topic topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            clangdIndexerService.subscribe(topic, (Object)new ClangServerListener(){

                public void onServerRunning() {
                    this.setStatelessIndexerStatus("Running");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerFailure() {
                    this.setStatelessIndexerStatus("Failure");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }

                public void onServerShutDown() {
                    this.setStatelessIndexerStatus("Shut Down");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus(), this.getStatelessIndexerStatus()));
                }
            });
        }
        if ((clangLanguageService = service) != null && (clangLanguageService = clangLanguageService.getMessageBus()) != null && (clangLanguageService = clangLanguageService.connect((Disposable)this)) != null) {
            Topic topic = ClangTelemetryListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            clangLanguageService.subscribe(topic, (Object)new ClangTelemetryListener(perModuleModel2, modulesTable){
                final /* synthetic */ perModuleModel.1 $perModuleModel;
                final /* synthetic */ JBTable $modulesTable;
                {
                    this.$perModuleModel = $perModuleModel;
                    this.$modulesTable = $modulesTable;
                }

                public void onPreambleTelemetry(ClangTelemetry telemetry) {
                    Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
                    preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
                }

                public void onGeneralTelemetry(ClangTelemetry telemetry) {
                    Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
                    ArrayList newPerModuleInfo = new ArrayList();
                    telemetry.getGeneralTelemetry().forEachCompiledModule((arg_0, arg_1) -> 5.onGeneralTelemetry$lambda$0(newPerModuleInfo, arg_0, arg_1));
                    this.$perModuleModel.setPerModule(newPerModuleInfo);
                    this.$modulesTable.updateUI();
                }

                private static final void onGeneralTelemetry$lambda$0(ArrayList $newPerModuleInfo, String name, Integer counter) {
                    $newPerModuleInfo.add(new Pair((Object)name, (Object)counter));
                }
            });
        }
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getMainStatus() {
        return this.mainStatus;
    }

    public final void setMainStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mainStatus = string;
    }

    @NotNull
    public final String getIndexerStatus() {
        return this.indexerStatus;
    }

    public final void setIndexerStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indexerStatus = string;
    }

    @NotNull
    public final String getStatelessIndexerStatus() {
        return this.statelessIndexerStatus;
    }

    public final void setStatelessIndexerStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.statelessIndexerStatus = string;
    }

    @NotNull
    public final String makePreambleStatsText(@NotNull Project project) {
        ClangTelemetry telemetry;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
        String curFile = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getPath() : null;
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted((Project)project);
        Object object = telemetry = clangLanguageService != null ? clangLanguageService.getTelemetry() : null;
        if (curFile != null && telemetry != null) {
            ClangPreambleTelemetry clangPreambleTelemetry = telemetry.getPreambleTelemetry();
            Intrinsics.checkNotNullExpressionValue((Object)clangPreambleTelemetry, (String)"getPreambleTelemetry(...)");
            ClangPreambleTelemetry preambleTelemetry = clangPreambleTelemetry;
            int preambleParses = preambleTelemetry.getPreambleParses(curFile);
            int preambleReuses = preambleTelemetry.getPreambleReuses(curFile);
            int preambleFailures = preambleTelemetry.getPreambleFailures(curFile);
            BuildPreambleError[] buildPreambleErrorArray = new BuildPreambleError[]{BuildPreambleError.DidntHitTargetFile};
            int preambleDidntHitTarget = preambleTelemetry.getPreambleFailures(curFile, buildPreambleErrorArray);
            int preambleCancels = preambleTelemetry.getPreambleCancels(curFile);
            return "Preamble [reparsed: " + (preambleParses - preambleCancels) + ", cancelled: " + preambleCancels + ", reused: " + preambleReuses + ", failed: " + preambleFailures + " (" + preambleDidntHitTarget + " didn't hit)]";
        }
        return "Preamble [reparsed: N/A, cancelled: N/A, reused: N/A, failed: N/A, empty: N/A]";
    }

    private final String makePidText(Project project, @Nls String status, @Nls String indexerStatus, @Nls String statelessIndexerStatus) {
        Object object;
        Object object2;
        Integer statelessIndexerPid;
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)project);
        Integer pid = clangLanguageServiceProvider != null && (clangLanguageServiceProvider = clangLanguageServiceProvider.getIfStarted()) != null ? Integer.valueOf(clangLanguageServiceProvider.getServerPid()) : null;
        ClangLanguageServiceProvider clangLanguageServiceProvider2 = ClangLanguageServiceProvider.getProvider((Project)project);
        Integer indexerPid = clangLanguageServiceProvider2 != null && (clangLanguageServiceProvider2 = clangLanguageServiceProvider2.getIfStartedIndexer()) != null ? Integer.valueOf(clangLanguageServiceProvider2.getServerPid()) : null;
        ClangLanguageServiceProvider clangLanguageServiceProvider3 = ClangLanguageServiceProvider.getProvider((Project)project);
        Integer n = statelessIndexerPid = clangLanguageServiceProvider3 != null && (clangLanguageServiceProvider3 = clangLanguageServiceProvider3.getIfStartedStatelessIndexer()) != null ? Integer.valueOf(clangLanguageServiceProvider3.getServerPid()) : null;
        Object object3 = pid;
        if (object3 == null || (object3 = String.valueOf((Integer)object3)) == null) {
            object3 = "Unknown";
        }
        if ((object2 = indexerPid) == null || (object2 = String.valueOf((Integer)object2)) == null) {
            object2 = "Unknown";
        }
        if ((object = statelessIndexerPid) == null || (object = String.valueOf((Integer)object)) == null) {
            object = "Unknown";
        }
        return "Clangd server PID: " + (String)object3 + " [" + status + "], Clangd indexer PID: " + (String)object2 + " [" + indexerStatus + "], Clangd stateless indexer PID: " + (String)object + " [" + statelessIndexerStatus + "]";
    }

    private final String makeClangdModulesLine(Project project) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)project);
        return "Clangd modules path: " + (clangLanguageServiceProvider != null && (clangLanguageServiceProvider = clangLanguageServiceProvider.getIfStarted()) != null ? clangLanguageServiceProvider.getClangdModulesPath() : null);
    }

    private final String makeCpp20ModulesLine(Project project) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)project);
        return "C++20 modules path: " + (clangLanguageServiceProvider != null && (clangLanguageServiceProvider = clangLanguageServiceProvider.getIfStarted()) != null ? clangLanguageServiceProvider.getCpp20ModulesPath() : null);
    }

    private final JTextPane copyableLabel(String text) {
        JLabel label = new JLabel("Dummy");
        JTextPane pane = new JTextPane();
        pane.setPreferredSize(new Dimension(Integer.MAX_VALUE, label.getPreferredSize().height));
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.setBackground(null);
        pane.setBorder(null);
        pane.setText(text);
        return pane;
    }
}

