/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u001a \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001aC\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"getIfStartedIndexer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "project", "Lcom/intellij/openapi/project/Project;", "isStateful", "", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "WHITESPACES", "Lkotlin/text/Regex;", "printConsole", "", "console", "Lcom/intellij/execution/ui/ConsoleView;", "message", "", "toOneLine", "s", "showJsonInEditor", "text", "caption", "showNotification", "createIndexOptionsPanel", "Ljavax/swing/JComponent;", "runIndexerCommand", "Ljava/util/concurrent/CompletableFuture;", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "actWithService", "block", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "Lkotlin/ParameterName;", "name", "service", "intellij.cidr.clangd.toolwindow"})
public final class ClangdIndexerPanelKt {
    @NotNull
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH.mm.ss.SSS");
    @NotNull
    private static final Regex WHITESPACES = new Regex("(\\n|\\r|\\s)+");

    private static final ClangLanguageService getIfStartedIndexer(Project project, boolean isStateful) {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)project);
        if (clangLanguageServiceProvider == null) {
            return null;
        }
        ClangLanguageServiceProvider provider = clangLanguageServiceProvider;
        if (isStateful) {
            return (ClangLanguageService)provider.getIfStartedIndexer();
        }
        return (ClangLanguageService)provider.getIfStartedStatelessIndexer();
    }

    private static final void printConsole(ConsoleView console, String message) {
        Function0 edt = () -> ClangdIndexerPanelKt.printConsole$lambda$0(console, message);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ClangdIndexerPanelKt.printConsole$lambda$1(edt));
    }

    private static final String toOneLine(String s) {
        String string = StringUtil.shortenTextWithEllipsis((String)s, (int)320, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        CharSequence charSequence = string;
        Regex regex = WHITESPACES;
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }

    private static final void showJsonInEditor(Project project, String text, String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)JsonLanguage.INSTANCE, (CharSequence)text), true);
    }

    private static final void showNotification(Project project, @Nls String message) {
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("Clang Execute Command");
        group.createNotification(message, NotificationType.ERROR).notify(project);
    }

    private static final JComponent createIndexOptionsPanel(Project project) {
        Ref.ObjectRef dialogPanel = new Ref.ObjectRef();
        Ref.ObjectRef enableModulesCheck = new Ref.ObjectRef();
        dialogPanel.element = BuilderKt.panel(arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0(enableModulesCheck, project, dialogPanel, arg_0));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = ClangdSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangdSettingsListener((Ref.ObjectRef<JBCheckBox>)enableModulesCheck){
            final /* synthetic */ Ref.ObjectRef<JBCheckBox> $enableModulesCheck;
            {
                this.$enableModulesCheck = $enableModulesCheck;
            }

            public void onIndexerUseModulesChanged(boolean value) {
                block1: {
                    JBCheckBox jBCheckBox = (JBCheckBox)this.$enableModulesCheck.element;
                    if (jBCheckBox != null ? jBCheckBox.isSelected() == value : false) break block1;
                    JBCheckBox jBCheckBox2 = (JBCheckBox)this.$enableModulesCheck.element;
                    if (jBCheckBox2 != null) {
                        jBCheckBox2.setSelected(value);
                    }
                }
            }
        });
        return InspectionUiUtilKt.addScrollPaneIfNecessary((JComponent)((JComponent)dialogPanel.element));
    }

    private static final CompletableFuture<Boolean> runIndexerCommand(Project project, ConsoleView console, boolean isStateful, ClangIndexerCommand command) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!ClangdIndexerPanelKt.actWithService(project, console, isStateful, (Function1<? super ClangdIndexerService, Unit>)((Function1)arg_0 -> ClangdIndexerPanelKt.runIndexerCommand$lambda$0(command, console, result, arg_0)))) {
            result.complete(false);
        }
        return result;
    }

    private static final boolean actWithService(Project project, ConsoleView console, boolean isStateful, Function1<? super ClangdIndexerService, Unit> block) {
        ClangLanguageService service = ClangdIndexerPanelKt.getIfStartedIndexer(project, isStateful);
        if (service == null) {
            console.print("Service is not started yet!\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        if (!(service instanceof ClangdIndexerService)) {
            console.print("Service is not an instance of " + ClangdIndexerService.class.getSimpleName() + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        block.invoke((Object)service);
        return true;
    }

    private static final Unit printConsole$lambda$0(ConsoleView $console, String $message) {
        $console.print($message, ConsoleViewContentType.NORMAL_OUTPUT);
        $console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return Unit.INSTANCE;
    }

    private static final void printConsole$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit createIndexOptionsPanel$lambda$0(Ref.ObjectRef $enableModulesCheck, Project $project, Ref.ObjectRef $dialogPanel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$0($enableModulesCheck, $project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$1($project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$2($project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$3($project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$4($dialogPanel, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$0(Ref.ObjectRef $enableModulesCheck, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.indexer.opt.modules", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $enableModulesCheck.element = Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$0$0($project), arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$0$1($project, arg_0)), (String)ClangdBundle.message((String)"clangd.indexer.opt.modules.comment", (Object[])new Object[0]), (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean createIndexOptionsPanel$lambda$0$0$0(Project $project) {
        return ClangdSettings.getInstance((Project)$project).getIndexerUseModules();
    }

    private static final Unit createIndexOptionsPanel$lambda$0$0$1(Project $project, boolean enabled) {
        ClangdSettings.getInstance((Project)$project).setIndexerUseModules(enabled);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$1(Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.indexer.opt.dynamic.index", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$1$0($project), arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$1$1($project, arg_0)), (String)ClangdBundle.message((String)"clangd.indexer.opt.dynamic.index.comment", (Object[])new Object[0]), (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean createIndexOptionsPanel$lambda$0$1$0(Project $project) {
        return !ClangdSettings.getInstance((Project)$project).getIndexerStaticOnly();
    }

    private static final Unit createIndexOptionsPanel$lambda$0$1$1(Project $project, boolean enabled) {
        ClangdSettings.getInstance((Project)$project).setIndexerStaticOnly(!enabled);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$2(Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.indexer.opt.optimize.include.graph", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$2$0($project), arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$2$1($project, arg_0)), (String)ClangdBundle.message((String)"clangd.indexer.opt.optimize.include.graph.comment", (Object[])new Object[0]), (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean createIndexOptionsPanel$lambda$0$2$0(Project $project) {
        return ClangdSettings.getInstance((Project)$project).getIndexerOptimizeIncludeGraph();
    }

    private static final Unit createIndexOptionsPanel$lambda$0$2$1(Project $project, boolean enabled) {
        ClangdSettings.getInstance((Project)$project).setIndexerOptimizeIncludeGraph(enabled);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$3(Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.indexer.opt.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$3$0($project), arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$3$1($project, arg_0)), (String)ClangdBundle.message((String)"clangd.indexer.opt.progress.comment", (Object[])new Object[0]), (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean createIndexOptionsPanel$lambda$0$3$0(Project $project) {
        return ClangdSettings.getInstance((Project)$project).getIndexerShowProgress();
    }

    private static final Unit createIndexOptionsPanel$lambda$0$3$1(Project $project, boolean enabled) {
        ClangdSettings.getInstance((Project)$project).setIndexerShowProgress(enabled);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$4(Ref.ObjectRef $dialogPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.indexer.apply", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> ClangdIndexerPanelKt.createIndexOptionsPanel$lambda$0$4$0($dialogPanel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createIndexOptionsPanel$lambda$0$4$0(Ref.ObjectRef $dialogPanel, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = (DialogPanel)$dialogPanel.element;
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ApplicationManager.getApplication().invokeLater(ClangdIndexerPanelKt::createIndexOptionsPanel$lambda$0$4$0$0, ModalityState.nonModal());
        return Unit.INSTANCE;
    }

    private static final void createIndexOptionsPanel$lambda$0$4$0$0() {
        RegistryBooleanOptionDescriptor.suggestRestart(null);
    }

    private static final Unit runIndexerCommand$lambda$0(ClangIndexerCommand $command, ConsoleView $console, CompletableFuture $result, ClangdIndexerService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.executeCommand($command).whenComplete((arg_0, arg_1) -> ClangdIndexerPanelKt.runIndexerCommand$lambda$0$1((arg_0, arg_1) -> ClangdIndexerPanelKt.runIndexerCommand$lambda$0$0($console, $command, $result, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit runIndexerCommand$lambda$0$0(ConsoleView $console, ClangIndexerCommand $command, CompletableFuture $result, Boolean res, Throwable ex) {
        if (ex != null || res != null && !res.booleanValue()) {
            $console.print($command.getCommand() + ": failed\n", ConsoleViewContentType.NORMAL_OUTPUT);
            v0 = $result.complete(false);
        } else {
            $console.print($command.getCommand() + ": success\n", ConsoleViewContentType.NORMAL_OUTPUT);
            v0 = $result.complete(true);
        }
        return Unit.INSTANCE;
    }

    private static final void runIndexerCommand$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ JComponent access$createIndexOptionsPanel(Project project) {
        return ClangdIndexerPanelKt.createIndexOptionsPanel(project);
    }

    public static final /* synthetic */ CompletableFuture access$runIndexerCommand(Project project, ConsoleView console, boolean isStateful, ClangIndexerCommand command) {
        return ClangdIndexerPanelKt.runIndexerCommand(project, console, isStateful, command);
    }

    public static final /* synthetic */ void access$printConsole(ConsoleView console, String message) {
        ClangdIndexerPanelKt.printConsole(console, message);
    }

    public static final /* synthetic */ SimpleDateFormat access$getDATE_FORMAT$p() {
        return DATE_FORMAT;
    }

    public static final /* synthetic */ String access$toOneLine(String s) {
        return ClangdIndexerPanelKt.toOneLine(s);
    }

    public static final /* synthetic */ void access$showJsonInEditor(Project project, String text, String caption) {
        ClangdIndexerPanelKt.showJsonInEditor(project, text, caption);
    }

    public static final /* synthetic */ ClangLanguageService access$getIfStartedIndexer(Project project, boolean isStateful) {
        return ClangdIndexerPanelKt.getIfStartedIndexer(project, isStateful);
    }

    public static final /* synthetic */ void access$showNotification(Project project, String message) {
        ClangdIndexerPanelKt.showNotification(project, message);
    }
}

