/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelKt;
import java.awt.Component;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "output", "Ljavax/swing/JTextPane;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "setupTextPane", "", "EditorEventListener", "ViewUpdate", "intellij.cidr.clangd.toolwindow"})
public final class ClangdCaretPanel
extends ClangdPanelBase {
    @NotNull
    private final Project project;
    @NotNull
    private final JTextPane output;
    @NotNull
    private final MergingUpdateQueue updateQueue;

    public ClangdCaretPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.output = new JTextPane(new DefaultStyledDocument());
        this.updateQueue = new MergingUpdateQueue("Clang Caret Context Queue", 600, true, null, (Disposable)this, null, false);
        this.setupTextPane();
        this.add((Component)new JBScrollPane((Component)this.output));
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        EditorEventListener listener = new EditorEventListener();
        eventMulticaster.addCaretListener((CaretListener)listener, (Disposable)this);
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)listener, (Disposable)this);
        }
    }

    private final void setupTextPane() {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet attrs = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.FontFamily, "Lucida Console");
        attrs = sc.addAttribute(attrs, StyleConstants.Alignment, 3);
        this.output.setCharacterAttributes(attrs, false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$EditorEventListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "focusGained", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "update", "intellij.cidr.clangd.toolwindow"})
    public final class EditorEventListener
    implements CaretListener,
    FocusChangeListener {
        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            this.update(editor);
        }

        public void focusGained(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.update(editor);
        }

        public void focusLost(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        }

        private final void update(Editor editor) {
            if (ClangdPanelKt.isPanelActive(ClangdCaretPanel.this.project, "clangd", Reflection.getOrCreateKotlinClass(ClangdCaretPanel.class))) {
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                int hash = document2.hashCode();
                ClangdCaretPanel.this.updateQueue.queue((Update)new ViewUpdate(document2, editor.getCaretModel().getOffset(), hash));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$ViewUpdate;", "Lcom/intellij/util/ui/update/Update;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "hash", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel;Lcom/intellij/openapi/editor/Document;II)V", "run", "", "intellij.cidr.clangd.toolwindow"})
    @SourceDebugExtension(value={"SMAP\nClangdCaretPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdCaretPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$ViewUpdate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1869#2,2:114\n1869#2:116\n1869#2,2:117\n1870#2:119\n*S KotlinDebug\n*F\n+ 1 ClangdCaretPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdCaretPanel$ViewUpdate\n*L\n72#1:114,2\n90#1:116\n91#1:117,2\n90#1:119\n*E\n"})
    public final class ViewUpdate
    extends Update {
        @NotNull
        private final Document document;
        private final int offset;

        public ViewUpdate(Document document, int offset, int hash) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            super((Object)("USRs View Update: " + hash), false, 0, 6, null);
            this.document = document;
            this.offset = offset;
        }

        public void run() {
            VirtualFile virtualFile;
            PsiFile psiFile;
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)ClangdCaretPanel.this.project);
            PsiFile psiFile2 = psiFile = (PsiFile)ActionsKt.runReadAction(() -> ViewUpdate.run$lambda$0(ClangdCaretPanel.this, this));
            Object object = virtualFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
            if (virtualFile != null) {
                try {
                    Ref.ObjectRef gotoResult = new Ref.ObjectRef();
                    gotoResult.element = "";
                    ClangLanguageService clangLanguageService = service;
                    if (clangLanguageService != null) {
                        clangLanguageService.gotoDefinition(virtualFile, this.offset, arg_0 -> ViewUpdate.run$lambda$1(gotoResult, arg_0));
                    }
                    Ref.ObjectRef entryPoint = new Ref.ObjectRef();
                    entryPoint.element = "";
                    ClangLanguageService clangLanguageService2 = service;
                    if (clangLanguageService2 != null) {
                        clangLanguageService2.findEntryPoint(virtualFile, arg_0 -> ViewUpdate.run$lambda$2(entryPoint, arg_0));
                    }
                    Ref.ObjectRef markersResult = new Ref.ObjectRef();
                    markersResult.element = "";
                    int lineNumber = this.document.getLineNumber(this.offset);
                    ClangLanguageService clangLanguageService3 = service;
                    if (clangLanguageService3 != null) {
                        clangLanguageService3.getSlowLineMarkers(virtualFile, this.document.getLineStartOffset(lineNumber), this.document.getLineEndOffset(lineNumber), arg_0 -> ViewUpdate.run$lambda$3(markersResult, arg_0));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> ViewUpdate.run$lambda$4(ClangdCaretPanel.this, gotoResult, entryPoint, markersResult));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private static final PsiFile run$lambda$0(ClangdCaretPanel this$0, ViewUpdate this$1) {
            return PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile(this$1.document);
        }

        private static final void run$lambda$1(Ref.ObjectRef $gotoResult, ClangResult it) {
            block1: {
                List clangSyms;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List list = clangSyms = (List)it.waitForResult(3000L);
                if (list == null) break block1;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClangSym it2 = (ClangSym)element$iv;
                    boolean bl = false;
                    $gotoResult.element = $gotoResult.element + it2.name + " at " + it2.startLoc.getPath() + ":" + it2.startLoc.position.getLine() + ":" + it2.startLoc.position.getColumn() + "\n";
                }
            }
        }

        private static final void run$lambda$2(Ref.ObjectRef $entryPoint, ClangResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ClangSym ep = (ClangSym)it.waitForResult(3000L);
            $entryPoint.element = ep != null ? "Entry point at: " + ep.startLoc + "\n" : "No entry point in this file\n";
        }

        private static final void run$lambda$3(Ref.ObjectRef $markersResult, ClangResult resHandler) {
            block2: {
                List markers;
                Intrinsics.checkNotNullParameter((Object)resHandler, (String)"resHandler");
                List list = markers = (List)resHandler.waitForResult(5000L);
                if (list == null) break block2;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClionLineMarker marker = (ClionLineMarker)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = marker.getTargets();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CLionSymbolInformation it = (CLionSymbolInformation)element$iv2;
                        boolean bl2 = false;
                        $markersResult.element = $markersResult.element + it + "\n";
                    }
                }
            }
        }

        private static final void run$lambda$4(ClangdCaretPanel this$0, Ref.ObjectRef $gotoResult, Ref.ObjectRef $entryPoint, Ref.ObjectRef $markersResult) {
            this$0.output.setText($gotoResult.element + "\n" + $entryPoint.element + "\n" + $markersResult.element);
        }
    }
}

