/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelKt;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J$\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "output", "Ljavax/swing/JTextPane;", "showAST", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorOffset", "", "ast", "", "append", "tp", "msg", "c", "Ljava/awt/Color;", "ASTViewSynchronizer", "Companion", "intellij.cidr.clangd.toolwindow"})
public final class ClangdASTPanel
extends ClangdPanelBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JTextPane output;
    private static final Pattern COLORED_TEXT_PATTERN = Pattern.compile("<color name=([\\w]+)>(.*?)</color>");

    public ClangdASTPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.output = new JTextPane(new DefaultStyledDocument());
        this.add((Component)new JBScrollPane((Component)this.output));
        this.output.setBackground(Color.DARK_GRAY);
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        ASTViewSynchronizer viewSynchronizer = new ASTViewSynchronizer(this, this.project);
        eventMulticaster.addCaretListener((CaretListener)viewSynchronizer, (Disposable)this);
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)viewSynchronizer, (Disposable)this);
        }
    }

    private final void showAST(Editor editor, int editorOffset) {
        block1: {
            ClangLanguageService service;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null) break block1;
            ClangLanguageService clangLanguageService = service = ClangLanguageServiceProvider.getIfStarted((Project)this.project);
            if (clangLanguageService != null) {
                clangLanguageService.dumpAST(virtualFile, editorOffset, arg_0 -> ClangdASTPanel.showAST$lambda$0(this, arg_0));
            }
        }
    }

    private final void showAST(String ast) {
        if (ast == null) {
            this.output.setText("");
            String string = ClangdBundle.message((String)"clangd.panel.ast.unavailable", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.append(this.output, string, Color.RED);
        } else if (ast.length() >= 1000000) {
            this.output.setText("");
            String string = ClangdBundle.message((String)"clangd.panel.ast.is.too.long", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.append(this.output, string, Color.RED);
        } else {
            List textWithColors = ClangdASTPanel.Companion.processColorsInAST(ast);
            this.output.setText("");
            for (Pair coloredPart : textWithColors) {
                this.append(this.output, (String)coloredPart.getFirst(), (Color)coloredPart.getSecond());
            }
        }
    }

    private final void append(JTextPane tp, @Nls String msg, Color c) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet attrSet = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.FontFamily, "Lucida Console");
        attrSet = sc.addAttribute(attrSet, StyleConstants.Alignment, 3);
        if (c != null) {
            attrSet = sc.addAttribute(attrSet, StyleConstants.Foreground, c);
        }
        int len = tp.getDocument().getLength();
        tp.setCaretPosition(len);
        tp.setCharacterAttributes(attrSet, false);
        tp.replaceSelection(msg);
    }

    private static final void showAST$lambda$0(ClangdASTPanel this$0, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            String ast = (String)it.waitForResult(5000L);
            ApplicationManager.getApplication().invokeLater(() -> ClangdASTPanel.showAST$lambda$0$0(this$0, ast));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void showAST$lambda$0$0(ClangdASTPanel this$0, String $ast) {
        this$0.showAST($ast);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u00013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u00100\u001a\u00020\u0014H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u00100\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0016\"\u0004\b*\u0010\u0018\u00a8\u00064"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "panel", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;Lcom/intellij/openapi/project/Project;)V", "getPanel", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getUpdateQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "setUpdateQueue", "(Lcom/intellij/util/ui/update/MergingUpdateQueue;)V", "curEditor", "Lcom/intellij/openapi/editor/Editor;", "getCurEditor", "()Lcom/intellij/openapi/editor/Editor;", "setCurEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "curLine", "", "getCurLine", "()I", "setCurLine", "(I)V", "curClangFileVersion", "getCurClangFileVersion", "setCurClangFileVersion", "counter", "", "getCounter", "()J", "setCounter", "(J)V", "focusedEditor", "getFocusedEditor", "setFocusedEditor", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "focusGained", "editor", "focusLost", "refreshIfNeed", "ASTViewUpdate", "intellij.cidr.clangd.toolwindow"})
    private static final class ASTViewSynchronizer
    implements CaretListener,
    FocusChangeListener {
        @NotNull
        private final ClangdASTPanel panel;
        @NotNull
        private final Project project;
        @NotNull
        private MergingUpdateQueue updateQueue;
        @Nullable
        private Editor curEditor;
        private int curLine;
        private int curClangFileVersion;
        private long counter;
        @Nullable
        private Editor focusedEditor;

        public ASTViewSynchronizer(@NotNull ClangdASTPanel panel, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)panel), (String)"panel");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.panel = panel;
            this.project = project;
            this.updateQueue = new MergingUpdateQueue("Clang AST View queue", 600, true, null, (Disposable)this.panel, null, false);
            this.curLine = -1;
            this.curClangFileVersion = -1;
            this.counter = -1L;
        }

        @NotNull
        public final ClangdASTPanel getPanel() {
            return this.panel;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final MergingUpdateQueue getUpdateQueue() {
            return this.updateQueue;
        }

        public final void setUpdateQueue(@NotNull MergingUpdateQueue mergingUpdateQueue) {
            Intrinsics.checkNotNullParameter((Object)mergingUpdateQueue, (String)"<set-?>");
            this.updateQueue = mergingUpdateQueue;
        }

        @Nullable
        public final Editor getCurEditor() {
            return this.curEditor;
        }

        public final void setCurEditor(@Nullable Editor editor) {
            this.curEditor = editor;
        }

        public final int getCurLine() {
            return this.curLine;
        }

        public final void setCurLine(int n) {
            this.curLine = n;
        }

        public final int getCurClangFileVersion() {
            return this.curClangFileVersion;
        }

        public final void setCurClangFileVersion(int n) {
            this.curClangFileVersion = n;
        }

        public final long getCounter() {
            return this.counter;
        }

        public final void setCounter(long l) {
            this.counter = l;
        }

        @Nullable
        public final Editor getFocusedEditor() {
            return this.focusedEditor;
        }

        public final void setFocusedEditor(@Nullable Editor editor) {
            this.focusedEditor = editor;
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (ClangdPanelKt.isPanelActive(this.project, "clangd", Reflection.getOrCreateKotlinClass(ClangdASTPanel.class))) {
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                this.refreshIfNeed(editor);
            }
        }

        public void focusGained(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (ClangdPanelKt.isPanelActive(this.project, "clangd", Reflection.getOrCreateKotlinClass(ClangdASTPanel.class))) {
                this.refreshIfNeed(editor);
            }
        }

        public void focusLost(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        }

        private final void refreshIfNeed(Editor editor) {
            int offset = editor.getCaretModel().getOffset();
            int line = editor.offsetToLogicalPosition((int)offset).line;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (ClangdBridge.isSupported((Project)this.project, (VirtualFile)virtualFile)) {
                ++this.counter;
                long newCounter = this.counter;
                VirtualFile virtualFile2 = virtualFile;
                Intrinsics.checkNotNull((Object)virtualFile2);
                this.updateQueue.queue((Update)new ASTViewUpdate(virtualFile2, editor, newCounter, offset, line));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer$ASTViewUpdate;", "Lcom/intellij/util/ui/update/Update;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "myCounter", "", "newOffset", "", "newLine", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;JII)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getMyCounter", "()J", "getNewOffset", "()I", "getNewLine", "run", "", "canEat", "", "update", "intellij.cidr.clangd.toolwindow"})
        public final class ASTViewUpdate
        extends Update {
            @NotNull
            private final VirtualFile virtualFile;
            @NotNull
            private final Editor editor;
            private final long myCounter;
            private final int newOffset;
            private final int newLine;

            public ASTViewUpdate(@NotNull VirtualFile virtualFile, Editor editor, long myCounter, int newOffset, int newLine) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                super((Object)("AST view update: " + myCounter), false, 0, 6, null);
                this.virtualFile = virtualFile;
                this.editor = editor;
                this.myCounter = myCounter;
                this.newOffset = newOffset;
                this.newLine = newLine;
            }

            @NotNull
            public final VirtualFile getVirtualFile() {
                return this.virtualFile;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final long getMyCounter() {
                return this.myCounter;
            }

            public final int getNewOffset() {
                return this.newOffset;
            }

            public final int getNewLine() {
                return this.newLine;
            }

            public void run() {
                ClangParseResponse response;
                ClangLanguageService service;
                ClangLanguageService clangLanguageService = service = ClangLanguageServiceProvider.getIfStarted((Project)ASTViewSynchronizer.this.getProject());
                ClangParseResponse clangParseResponse = response = clangLanguageService != null ? clangLanguageService.getParsed(this.virtualFile) : null;
                if (response == null) {
                    return;
                }
                if (Intrinsics.areEqual((Object)ASTViewSynchronizer.this.getCurEditor(), (Object)this.editor) && ASTViewSynchronizer.this.getCurLine() == this.newLine && ASTViewSynchronizer.this.getCurClangFileVersion() == response.getVersion()) {
                    return;
                }
                ASTViewSynchronizer.this.setCurEditor(this.editor);
                ASTViewSynchronizer.this.setCurLine(this.newLine);
                ASTViewSynchronizer.this.setCurClangFileVersion(response.getVersion());
                ApplicationManager.getApplication().runReadAction(() -> ASTViewUpdate.run$lambda$0(ASTViewSynchronizer.this, this));
            }

            public boolean canEat(@NotNull Update update) {
                Intrinsics.checkNotNullParameter((Object)update, (String)"update");
                return ((ASTViewUpdate)update).myCounter < this.myCounter;
            }

            private static final void run$lambda$0(ASTViewSynchronizer this$0, ASTViewUpdate this$1) {
                this$0.getPanel().showAST(this$1.editor, this$1.newOffset);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0007\u001a\u001b\u0012\u0017\u0012\u0015\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t0\b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$Companion;", "", "<init>", "()V", "COLORED_TEXT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "processColorsInAST", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/util/NlsSafe;", "Ljava/awt/Color;", "ast", "toColor", "name", "intellij.cidr.clangd.toolwindow"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Pair<String, Color>> processColorsInAST(String ast) {
            Matcher matcher = COLORED_TEXT_PATTERN.matcher(ast);
            ArrayList<Pair> result = new ArrayList<Pair>();
            int lastMatchEnd = 0;
            while (matcher.find()) {
                int curMatchStart = matcher.start();
                if (lastMatchEnd < curMatchStart) {
                    String string = ast.substring(lastMatchEnd, curMatchStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    result.add(new Pair((Object)string, null));
                }
                String name = matcher.group(1);
                String text = matcher.group(2);
                Intrinsics.checkNotNull((Object)name);
                result.add(new Pair((Object)text, (Object)this.toColor(name)));
                lastMatchEnd = matcher.end();
            }
            if (lastMatchEnd != ast.length()) {
                String string = ast.substring(lastMatchEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result.add(new Pair((Object)string, null));
            }
            return result;
        }

        private final Color toColor(String name) {
            switch (name) {
                case "BLACK": {
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
                    return color;
                }
                case "RED": {
                    Color color = Color.RED;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
                    return color;
                }
                case "GREEN": {
                    Color color = Color.GREEN;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"GREEN");
                    return color;
                }
                case "YELLOW": {
                    Color color = Color.YELLOW;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"YELLOW");
                    return color;
                }
                case "BLUE": {
                    Color color = Color.BLUE;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLUE");
                    return color;
                }
                case "MAGENTA": {
                    Color color = Color.MAGENTA;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"MAGENTA");
                    return color;
                }
                case "CYAN": {
                    Color color = Color.CYAN;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"CYAN");
                    return color;
                }
                case "WHITE": {
                    Color color = Color.WHITE;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
                    return color;
                }
            }
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

