/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangExecuteCommandActionKt;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommandDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommand;", "getCommand", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangCommand;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "executeCommand", "intellij.cidr.clangd.toolwindow"})
final class ClangCommandDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    private DialogPanel panel;
    @NotNull
    private final ClangCommand command;

    public ClangCommandDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.command = new ClangCommand(false, null, null, 7, null);
        this.setTitle(ClangdBundle.message((String)"execute.command.dialog.title", (Object[])new Object[0]));
        this.setOKButtonText(ClangdBundle.message((String)"execute.command.ok.button.text", (Object[])new Object[0]));
        this.init();
        this.initValidation();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ClangCommand getCommand() {
        return this.command;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel(arg_0 -> ClangCommandDialog.createCenterPanel$lambda$0(this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangCommandDialog", this.project)) == null) {
            JBDimension jBDimension = JBUI.size((int)640, (int)480);
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
            dimension = (Dimension)jBDimension;
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.executeCommand();
    }

    private final void executeCommand() {
        JsonElement jsonElement;
        try {
            jsonElement = this.command.parseParams();
        }
        catch (JsonParseException ex) {
            String string = ClangdBundle.message((String)"clangd.execute.command.panel.notify.invalid.json", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ClangExecuteCommandActionKt.access$showNotification(this.project, string);
            return;
        }
        JsonElement params = jsonElement;
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)this.project);
        if (clangLanguageServiceProvider == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ClangLanguageServiceProvider not found");
            return;
        }
        ClangLanguageServiceProvider provider = clangLanguageServiceProvider;
        ClangLanguageService clangLanguageService = provider.getIfStarted();
        ClangdLanguageService clangdLanguageService = clangLanguageService instanceof ClangdLanguageService ? (ClangdLanguageService)clangLanguageService : null;
        if (clangdLanguageService == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ClangdLanguageService not found");
            return;
        }
        ClangdLanguageService service = clangdLanguageService;
        Endpoint endpoint = service.remoteEndpoint();
        if (endpoint == null) {
            ClangExecuteCommandActionKt.access$showNotification(this.project, "ServerConnection not found");
            return;
        }
        Endpoint endpoint2 = endpoint;
        if (this.command.getRequest()) {
            endpoint2.request(this.command.getMethod(), (Object)params);
        } else {
            endpoint2.notify(this.command.getMethod(), (Object)params);
        }
    }

    private static final ValidationInfo createCenterPanel$validator(ValidationInfoBuilder $this$createCenterPanel_u24validator, JTextField it, String message) {
        CharSequence charSequence = it.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$createCenterPanel_u24validator.error(message) : null;
    }

    private static final Unit createCenterPanel$lambda$0(ClangCommandDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = ClangdBundle.message((String)"clangd.execute.command.panel.label.request", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> ClangCommandDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        String string2 = ClangdBundle.message((String)"clangd.execute.command.panel.label.method", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> ClangCommandDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangCommandDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(ClangCommandDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ClangdBundle.message((String)"clangd.execute.command.panel.label.request", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.command){

            public Object get() {
                return ((ClangCommand)this.receiver).getRequest();
            }

            public void set(Object value) {
                ((ClangCommand)this.receiver).setRequest((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(ClangCommandDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithStoredHistory textField = new TextFieldWithStoredHistory("CLANG_METHOD_NAME_FIELD");
        $this$row.cell((JComponent)textField).align((Align)AlignX.FILL.INSTANCE).bind((Function1)createCenterPanel.1.2.1.INSTANCE, (Function2)createCenterPanel.1.2.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.command){

            public Object get() {
                return ((ClangCommand)this.receiver).getMethod();
            }

            public void set(Object value) {
                ((ClangCommand)this.receiver).setMethod((String)value);
            }
        }))).validationOnInput(ClangCommandDialog::createCenterPanel$lambda$0$1$0).validationOnApply(ClangCommandDialog::createCenterPanel$lambda$0$1$1).onApply(() -> ClangCommandDialog.createCenterPanel$lambda$0$1$2(textField)).focused();
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$0(ValidationInfoBuilder $this$validationOnInput, TextFieldWithStoredHistory it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JTextField jTextField = it.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        String string = ClangdBundle.message((String)"execute.command.method.empty.error.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return ClangCommandDialog.createCenterPanel$validator($this$validationOnInput, jTextField, string);
    }

    private static final ValidationInfo createCenterPanel$lambda$0$1$1(ValidationInfoBuilder $this$validationOnApply, TextFieldWithStoredHistory it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JTextField jTextField = it.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextEditor(...)");
        String string = ClangdBundle.message((String)"execute.command.method.empty.error.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return ClangCommandDialog.createCenterPanel$validator($this$validationOnApply, jTextField, string);
    }

    private static final Unit createCenterPanel$lambda$0$1$2(TextFieldWithStoredHistory $textField) {
        $textField.addCurrentTextToHistory();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(ClangCommandDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorTextField textEditor = new EditorTextField(this$0.project, (FileType)JsonFileType.INSTANCE);
        textEditor.setOneLineMode(false);
        textEditor.setFontInheritedFromLAF(false);
        textEditor.setFont(EditorUtil.getEditorFont());
        Cell cell = $this$row.cell((JComponent)textEditor).align(Align.FILL);
        String string = ClangdBundle.message((String)"clangd.execute.command.panel.label.params", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).bind(ClangCommandDialog::createCenterPanel$lambda$0$2$0, ClangCommandDialog::createCenterPanel$lambda$0$2$1, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.command){

            public Object get() {
                return ((ClangCommand)this.receiver).getParams();
            }

            public void set(Object value) {
                ((ClangCommand)this.receiver).setParams((String)value);
            }
        }))).validationOnApply((arg_0, arg_1) -> ClangCommandDialog.createCenterPanel$lambda$0$2$2(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final String createCenterPanel$lambda$0$2$0(EditorTextField editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$0$2$1(EditorTextField editor, String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        editor.setText(text);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$0$2$2(ClangCommandDialog this$0, ValidationInfoBuilder $this$validationOnApply, EditorTextField it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            this$0.command.parseParams();
            validationInfo = null;
        }
        catch (JsonParseException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            validationInfo = $this$validationOnApply.error(string);
        }
        return validationInfo;
    }
}

