/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.console;

import com.intellij.plugins.serialmonitor.service.SerialPortService;
import com.intellij.plugins.serialmonitor.ui.console.JeditermConsoleView;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\b\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/console/SerialTtyConnector;", "Lcom/jediterm/terminal/TtyConnector;", "consoleView", "Lcom/intellij/plugins/serialmonitor/ui/console/JeditermConsoleView;", "connection", "Lcom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection;", "Lcom/intellij/plugins/serialmonitor/service/SerialPortService;", "<init>", "(Lcom/intellij/plugins/serialmonitor/ui/console/JeditermConsoleView;Lcom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection;)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "setCharset", "(Ljava/nio/charset/Charset;)V", "localEcho", "", "getLocalEcho", "()Z", "setLocalEcho", "(Z)V", "read", "", "buf", "", "offset", "length", "write", "", "bytes", "", "string", "", "isConnected", "waitFor", "ready", "getName", "close", "resize", "size", "Lcom/jediterm/core/util/TermSize;", "intellij.serial.monitor"})
public final class SerialTtyConnector
implements TtyConnector {
    @NotNull
    private final JeditermConsoleView consoleView;
    @NotNull
    private final SerialPortService.SerialConnection connection;
    @NotNull
    private Charset charset;
    private boolean localEcho;

    public SerialTtyConnector(@NotNull JeditermConsoleView consoleView, @NotNull SerialPortService.SerialConnection connection) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.consoleView = consoleView;
        this.connection = connection;
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
        this.charset = charset;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final void setCharset(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.charset = charset;
    }

    public final boolean getLocalEcho() {
        return this.localEcho;
    }

    public final void setLocalEcho(boolean bl) {
        this.localEcho = bl;
    }

    public int read(@NotNull char[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return this.consoleView.readChars(buf, offset, length);
    }

    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.connection.write(bytes);
    }

    public void write(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = string.getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.write(byArray);
    }

    public boolean isConnected() {
        return true;
    }

    public int waitFor() {
        return 0;
    }

    public boolean ready() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.connection.getPortName();
    }

    public void close() {
    }

    public void resize(@NotNull TermSize size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
    }
}

