/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.serialmonitor.SerialMonitorException;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.service.PortStatus;
import com.intellij.plugins.serialmonitor.service.SerialPortService;
import com.intellij.plugins.serialmonitor.ui.SerialMonitor;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.plugins.serialmonitor.ui.actions.ConnectDisconnectAction;
import com.intellij.plugins.serialmonitor.ui.actions.SaveHistoryToFileAction;
import com.intellij.plugins.serialmonitor.ui.console.HexConsoleView;
import com.intellij.plugins.serialmonitor.ui.console.JeditermConsoleView;
import com.intellij.ui.components.JBLoadingPanel;
import icons.SerialMonitorIcons;
import java.awt.Component;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class JeditermSerialMonitorDuplexConsoleView
extends DuplexConsoleView<JeditermConsoleView, HexConsoleView>
implements Disposable {
    private static final String STATE_STORAGE_KEY = "SerialMonitorDuplexConsoleViewState";
    @NotNull
    private final SerialPortService.SerialConnection myConnection;
    @NotNull
    private final SerialPortProfile myPortProfile;
    @NotNull
    private final ToggleAction mySwitchConsoleAction;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    private Charset myCharset;

    public @NotNull SerialPortService.SerialConnection getConnection() {
        return this.myConnection;
    }

    @NotNull
    public static JeditermSerialMonitorDuplexConsoleView create(@NotNull Project project, @NotNull SerialPortProfile portProfile, @NotNull JBLoadingPanel loadingPanel) {
        if (project == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(0);
        }
        if (portProfile == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(1);
        }
        if (loadingPanel == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(2);
        }
        SerialPortService.SerialConnection connection = ((SerialPortService)ApplicationManager.getApplication().getService(SerialPortService.class)).newConnection(portProfile.getPortName());
        JeditermConsoleView textConsoleView = new JeditermConsoleView(project, connection);
        HexConsoleView hexConsoleView = new HexConsoleView(project, true);
        if (!PropertiesComponent.getInstance().isValueSet(STATE_STORAGE_KEY)) {
            PropertiesComponent.getInstance().setValue(STATE_STORAGE_KEY, true);
        }
        JeditermSerialMonitorDuplexConsoleView consoleView = new JeditermSerialMonitorDuplexConsoleView(connection, textConsoleView, hexConsoleView, portProfile, loadingPanel);
        connection.setDataListener(consoleView::append);
        JeditermSerialMonitorDuplexConsoleView jeditermSerialMonitorDuplexConsoleView = consoleView;
        if (jeditermSerialMonitorDuplexConsoleView == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(3);
        }
        return jeditermSerialMonitorDuplexConsoleView;
    }

    private JeditermSerialMonitorDuplexConsoleView(@NotNull SerialPortService.SerialConnection connection, JeditermConsoleView textConsoleView, HexConsoleView hexConsoleView, @NotNull SerialPortProfile portProfile, @NotNull JBLoadingPanel loadingPanel) {
        if (portProfile == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(4);
        }
        if (loadingPanel == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(5);
        }
        super((ConsoleView)textConsoleView, (ConsoleView)hexConsoleView, STATE_STORAGE_KEY);
        this.myCharset = StandardCharsets.US_ASCII;
        this.mySwitchConsoleAction = new SwitchConsoleViewAction();
        this.myLoadingPanel = loadingPanel;
        this.myPortProfile = portProfile;
        this.myConnection = connection;
    }

    @NotNull
    public Presentation getSwitchConsoleActionPresentation() {
        Presentation presentation = this.mySwitchConsoleAction.getTemplatePresentation();
        if (presentation == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(6);
        }
        return presentation;
    }

    public boolean isOutputPaused() {
        return ((JeditermConsoleView)this.getPrimaryConsoleView()).isOutputPaused();
    }

    public boolean canPause() {
        return true;
    }

    @NotNull
    public @NotNull AnAction @NotNull [] createConsoleActions() {
        AnAction[] anActionArray = new AnAction[]{new ConnectDisconnectAction(this), this.mySwitchConsoleAction, ((JeditermConsoleView)this.getPrimaryConsoleView()).getScrollToTheEndToolbarAction(), new MyScrollToTheEndToolbarAction(((HexConsoleView)this.getSecondaryConsoleView()).getEditor()), ((JeditermConsoleView)this.getPrimaryConsoleView()).getPrintTimestampsToggleAction(), new SerialPauseAction(), new SaveHistoryToFileAction(((JeditermConsoleView)this.getPrimaryConsoleView()).getTerminalTextBuffer(), this.myPortProfile), new ClearAllAction()};
        if (anActionArray == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    @NotNull
    public PortStatus getStatus() {
        PortStatus portStatus = this.myConnection.getStatus();
        if (portStatus == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(8);
        }
        return portStatus;
    }

    public boolean isTimestamped() {
        return ((JeditermConsoleView)this.getPrimaryConsoleView()).isTimestamped();
    }

    public synchronized void connect(boolean doConnect) {
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.performConnect(doConnect);
            ApplicationManager.getApplication().invokeLater(() -> ((JBLoadingPanel)this.myLoadingPanel).stopLoading());
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performConnect(boolean doConnect) {
        try {
            if (doConnect) {
                this.myConnection.closeSilently(true);
                this.myCharset = Charset.availableCharsets().getOrDefault(this.myPortProfile.getEncoding(), StandardCharsets.US_ASCII);
                if (this.myConnection.getStatus() != PortStatus.DISCONNECTED && this.myConnection.getStatus() != PortStatus.READY) throw new SerialMonitorException(SerialMonitorBundle.message("serial.port.not.found", this.myPortProfile.getPortName()));
                ((JeditermConsoleView)this.getPrimaryConsoleView()).reconnect(this.getCharset(), this.myPortProfile.getNewLine(), this.myPortProfile.getLocalEcho());
                this.myConnection.connect(this.myPortProfile);
                return;
            } else {
                this.myConnection.close(true);
            }
            return;
        }
        catch (SerialMonitorException sme) {
            SerialMonitor.Companion.errorNotification(sme.getMessage(), (Component)((Object)this));
        }
    }

    public void reconnect() {
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.performConnect(false);
                this.performConnect(true);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> ((JBLoadingPanel)this.myLoadingPanel).stopLoading());
            }
        });
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            JeditermSerialMonitorDuplexConsoleView.$$$reportNull$$$0(9);
        }
        return charset;
    }

    public boolean isLoading() {
        return this.myLoadingPanel.isLoading();
    }

    public void append(byte[] dataChunk) {
        ((JeditermConsoleView)this.getPrimaryConsoleView()).output(dataChunk);
        ((HexConsoleView)this.getSecondaryConsoleView()).output(dataChunk);
    }

    public void dispose() {
        super.dispose();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> this.myConnection.closeSilently(true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portProfile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingPanel";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchConsoleActionPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private class SwitchConsoleViewAction
    extends ToggleAction
    implements DumbAware {
        private static Supplier<String> getDynamicText(JeditermSerialMonitorDuplexConsoleView consoleView) {
            return () -> consoleView.isPrimaryConsoleEnabled() ? SerialMonitorBundle.message("switch.console.view.to.hex.title", new Object[0]) : SerialMonitorBundle.message("switch.console.view.off.hex.title", new Object[0]);
        }

        private SwitchConsoleViewAction() {
            super(SwitchConsoleViewAction.getDynamicText(JeditermSerialMonitorDuplexConsoleView.this), () -> "", SerialMonitorIcons.HexSerial);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SwitchConsoleViewAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                SwitchConsoleViewAction.$$$reportNull$$$0(1);
            }
            return !JeditermSerialMonitorDuplexConsoleView.this.isPrimaryConsoleEnabled();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                SwitchConsoleViewAction.$$$reportNull$$$0(2);
            }
            JeditermSerialMonitorDuplexConsoleView.this.enableConsole(!flag);
            PropertiesComponent.getInstance().setValue(JeditermSerialMonitorDuplexConsoleView.STATE_STORAGE_KEY, Boolean.toString(!flag));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$SwitchConsoleViewAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$SwitchConsoleViewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyScrollToTheEndToolbarAction
    extends ScrollToTheEndToolbarAction {
        private final Editor myEditor;

        private MyScrollToTheEndToolbarAction(Editor editor) {
            super(editor);
            this.myEditor = editor;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyScrollToTheEndToolbarAction.$$$reportNull$$$0(0);
            }
            if (this.myEditor.getComponent().isShowing()) {
                super.update(e);
            } else {
                e.getPresentation().setVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$MyScrollToTheEndToolbarAction", "update"));
        }
    }

    private class SerialPauseAction
    extends ToggleAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SerialPauseAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private SerialPauseAction() {
            super(() -> SerialMonitorBundle.message("action.pause.text", new Object[0]), () -> SerialMonitorBundle.message("action.pause.description", new Object[0]), AllIcons.Actions.Pause);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SerialPauseAction.$$$reportNull$$$0(1);
            }
            return JeditermSerialMonitorDuplexConsoleView.this.isOutputPaused();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SerialPauseAction.$$$reportNull$$$0(2);
            }
            JeditermSerialMonitorDuplexConsoleView.this.setOutputPaused(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$SerialPauseAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$SerialPauseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ClearAllAction
    extends DumbAwareAction {
        private ClearAllAction() {
            super(ExecutionBundle.messagePointer((String)"clear.all.from.console.action.name", (Object[])new Object[0]), SerialMonitorBundle.messagePointer("action.clear.contents.console.description", new Object[0]), AllIcons.Actions.GC);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ClearAllAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                ClearAllAction.$$$reportNull$$$0(1);
            }
            boolean bl = enabled = JeditermSerialMonitorDuplexConsoleView.this.getContentSize() > 0;
            if (!enabled) {
                enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor != null && editor.getDocument().getTextLength() == 0) {
                    enabled = false;
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAllAction.$$$reportNull$$$0(2);
            }
            JeditermSerialMonitorDuplexConsoleView.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$ClearAllAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView$ClearAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

