/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.console;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;

public class HexConsoleView
extends ConsoleViewImpl {
    public static final int LINE_LENGTH = 32;
    public static final int SEQUENCE_LENGTH = 8;
    private final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final StringBuffer lineBuffer = new StringBuffer();

    public HexConsoleView(Project project, boolean viewer) {
        super(project, viewer);
    }

    public void output(byte[] dataChunk) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : dataChunk) {
            char c = (char)(b & 0xFF);
            buffer.append(this.hexChar[c >> 4]).append(this.hexChar[c & 0xF]).append(' ');
            this.lineBuffer.append(c);
            if (this.lineBuffer.length() == 32) {
                this.wrapLine(buffer);
                continue;
            }
            if (this.lineBuffer.length() % 8 != 0) continue;
            buffer.append(' ');
        }
        this.print(buffer.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
    }

    private void wrapLine(StringBuilder buffer) {
        buffer.append(" |  ");
        for (int i = 0; i < 32; ++i) {
            char c = this.lineBuffer.charAt(i);
            if (c >= ' ' && c <= '\u007f') {
                buffer.append(c);
                continue;
            }
            buffer.append('.');
        }
        buffer.append('\n');
        this.lineBuffer.setLength(0);
    }

    public void clear() {
        this.lineBuffer.setLength(0);
        super.clear();
    }
}

