/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.console;

import com.intellij.plugins.serialmonitor.SerialProfileService;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.emulator.JediEmulator;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u001f\u001a\u00020\u001a2\n\u0010 \u001a\u00020!\"\u00020\u001cH\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/console/CustomJeditermEmulator;", "Lcom/jediterm/terminal/emulator/JediEmulator;", "dataStream", "Lcom/jediterm/terminal/TerminalDataStream;", "terminal", "Lcom/jediterm/terminal/Terminal;", "<init>", "(Lcom/jediterm/terminal/TerminalDataStream;Lcom/jediterm/terminal/Terminal;)V", "newLine", "Lcom/intellij/plugins/serialmonitor/SerialProfileService$NewLine;", "getNewLine", "()Lcom/intellij/plugins/serialmonitor/SerialProfileService$NewLine;", "setNewLine", "(Lcom/intellij/plugins/serialmonitor/SerialProfileService$NewLine;)V", "isTimestamped", "", "()Z", "setTimestamped", "(Z)V", "lastCharCR", "myFormatter", "Ljava/text/SimpleDateFormat;", "getTimestamp", "", "isOnLineStart", "maybeInsertTimestamp", "", "nextChar", "", "processChar", "ch", "unsupported", "sequenceChars", "", "Companion", "intellij.serial.monitor"})
public final class CustomJeditermEmulator
extends JediEmulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SerialProfileService.NewLine newLine = SerialProfileService.NewLine.CRLF;
    private boolean isTimestamped;
    private boolean lastCharCR;
    @NotNull
    private final SimpleDateFormat myFormatter = new SimpleDateFormat("[HH:mm:ss.SSS] ");
    @NotNull
    public static final String TIMESTAMP_FORMAT = "[HH:mm:ss.SSS] ";

    public CustomJeditermEmulator(@Nullable TerminalDataStream dataStream, @Nullable Terminal terminal) {
        super(dataStream, terminal);
    }

    @NotNull
    public final SerialProfileService.NewLine getNewLine() {
        return this.newLine;
    }

    public final void setNewLine(@NotNull SerialProfileService.NewLine newLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)newLine), (String)"<set-?>");
        this.newLine = newLine;
    }

    public final boolean isTimestamped() {
        return this.isTimestamped;
    }

    public final void setTimestamped(boolean bl) {
        this.isTimestamped = bl;
    }

    private final String getTimestamp() {
        String string = this.myFormatter.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final boolean isOnLineStart(Terminal $this$isOnLineStart) {
        return $this$isOnLineStart.getCursorX() == 1;
    }

    private final void maybeInsertTimestamp(char nextChar, Terminal terminal) {
        if (!this.isTimestamped) {
            return;
        }
        if (!this.isOnLineStart(terminal)) {
            return;
        }
        if (this.lastCharCR && nextChar == '\n' && this.newLine == SerialProfileService.NewLine.CRLF) {
            return;
        }
        terminal.writeCharacters(this.getTimestamp());
    }

    public void processChar(char ch, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.maybeInsertTimestamp(ch, terminal);
        switch (ch) {
            case '\r': {
                terminal.carriageReturn();
                if (this.newLine == SerialProfileService.NewLine.CR) {
                    terminal.newLine();
                    break;
                }
                if (!this.isTimestamped) break;
                terminal.cursorForward(15);
                break;
            }
            case '\n': {
                if (this.newLine == SerialProfileService.NewLine.LF || this.isTimestamped) {
                    terminal.carriageReturn();
                }
                terminal.newLine();
                break;
            }
            default: {
                super.processChar(ch, terminal);
            }
        }
        this.lastCharCR = ch == '\r';
    }

    protected void unsupported(char ... sequenceChars) {
        Intrinsics.checkNotNullParameter((Object)sequenceChars, (String)"sequenceChars");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/console/CustomJeditermEmulator$Companion;", "", "<init>", "()V", "TIMESTAMP_FORMAT", "", "intellij.serial.monitor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

