/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.ui.SerialMonitor;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.plugins.serialmonitor.ui.SerialSettingsUIKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/actions/EditSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myName", "", "Lorg/jetbrains/annotations/Nls;", "serialMonitor", "Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor;", "<init>", "(Ljava/lang/String;Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "SettingsDialog", "intellij.serial.monitor"})
public final class EditSettingsAction
extends DumbAwareAction {
    @NotNull
    private final String myName;
    @NotNull
    private final SerialMonitor serialMonitor;

    public EditSettingsAction(@NotNull String myName, @NotNull SerialMonitor serialMonitor) {
        Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
        Intrinsics.checkNotNullParameter((Object)serialMonitor, (String)"serialMonitor");
        super(SerialMonitorBundle.message("edit-settings.title", new Object[0]), SerialMonitorBundle.message("edit-settings.tooltip", new Object[0]), AllIcons.General.Settings);
        this.myName = myName;
        this.serialMonitor = serialMonitor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SettingsDialog settingsDialog = new SettingsDialog(e.getProject());
        boolean okClicked = settingsDialog.showAndGet();
        if (okClicked) {
            this.serialMonitor.notifyProfileChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/actions/EditSettingsAction$SettingsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/plugins/serialmonitor/ui/actions/EditSettingsAction;Lcom/intellij/openapi/project/Project;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.serial.monitor"})
    private final class SettingsDialog
    extends DialogWrapper {
        public SettingsDialog(Project project) {
            super(project, false, DialogWrapper.IdeModalityType.IDE);
            Object[] objectArray = new Object[]{EditSettingsAction.this.myName};
            this.setTitle(SerialMonitorBundle.message("dialog.title.serial.port.settings", objectArray));
            this.init();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> SettingsDialog.createCenterPanel$lambda$0(this, EditSettingsAction.this, arg_0));
        }

        private static final Unit createCenterPanel$lambda$0(SettingsDialog this$0, EditSettingsAction this$1, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> SettingsDialog.createCenterPanel$lambda$0$0(this$1, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
            Disposable disposable = this$0.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            SerialSettingsUIKt.serialSettings$default($this$panel, disposable, this$1.serialMonitor.getPortProfile(), false, SettingsDialog::createCenterPanel$lambda$0$1, 4, null);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0(EditSettingsAction this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell = $this$row.label(this$0.serialMonitor.getPortProfile().getPortName()).align(Align.FILL).resizableColumn();
            String string = SerialMonitorBundle.message("label.port", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Cell.label$default((Cell)cell, (String)string, null, (int)2, null).applyToComponent(SettingsDialog::createCenterPanel$lambda$0$0$0);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0$0(JLabel $this$applyToComponent) {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            $this$applyToComponent.setBorder(BorderFactory.createLineBorder(JBColor.border()));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$1(SerialPortProfile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }
    }
}

