/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.plugins.serialmonitor.service.PortStatus;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.plugins.serialmonitor.ui.console.JeditermSerialMonitorDuplexConsoleView;
import icons.SerialMonitorIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ConnectDisconnectAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final JeditermSerialMonitorDuplexConsoleView myConsoleView;

    public ConnectDisconnectAction(@NotNull JeditermSerialMonitorDuplexConsoleView consoleView) {
        if (consoleView == null) {
            ConnectDisconnectAction.$$$reportNull$$$0(0);
        }
        super(SerialMonitorBundle.messagePointer("connect.title", new Object[0]), SerialMonitorBundle.messagePointer("connect.tooltip", new Object[0]), SerialMonitorIcons.ConnectActive);
        this.myConsoleView = consoleView;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ConnectDisconnectAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ConnectDisconnectAction.$$$reportNull$$$0(2);
        }
        return this.myConsoleView.getStatus() == PortStatus.CONNECTED;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean doConnect) {
        if (e == null) {
            ConnectDisconnectAction.$$$reportNull$$$0(3);
        }
        this.myConsoleView.connect(doConnect);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConnectDisconnectAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.myConsoleView.isLoading()) {
            presentation.setEnabled(false);
            return;
        }
        PortStatus status = this.myConsoleView.getStatus();
        Icon icon = null;
        String text = null;
        boolean enabled = false;
        switch (status) {
            case UNAVAILABLE_DISCONNECTED: 
            case UNAVAILABLE: {
                icon = SerialMonitorIcons.Invalid;
                text = SerialMonitorBundle.message("connect-invalid-settings.title", new Object[0]);
                break;
            }
            case BUSY: {
                icon = SerialMonitorIcons.Invalid;
                break;
            }
            case READY: 
            case DISCONNECTED: {
                icon = SerialMonitorIcons.ConnectActive;
                text = SerialMonitorBundle.message("connect.title", new Object[0]);
                enabled = true;
                break;
            }
            case CONNECTING: {
                icon = PortStatus.BUSY.getIcon();
                break;
            }
            case CONNECTED: {
                icon = SerialMonitorIcons.ConnectActive;
                text = SerialMonitorBundle.message("disconnect.title", new Object[0]);
                enabled = true;
            }
        }
        presentation.setIcon(icon);
        presentation.setText(text);
        presentation.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/serialmonitor/ui/actions/ConnectDisconnectAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/serialmonitor/ui/actions/ConnectDisconnectAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

