/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.plugins.serialmonitor.SerialMonitorException;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.service.PortStatus;
import com.intellij.plugins.serialmonitor.service.SerialPortService;
import com.intellij.plugins.serialmonitor.service.SerialPortsListener;
import com.intellij.plugins.serialmonitor.ui.SerialMonitor;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.plugins.serialmonitor.ui.actions.EditSettingsAction;
import com.intellij.plugins.serialmonitor.ui.console.JeditermSerialMonitorDuplexConsoleView;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000278B$\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0006\u0010)\u001a\u00020!J\b\u0010*\u001a\u00020!H\u0016J\u0006\u0010+\u001a\u00020!J\r\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020-H\u0000\u00a2\u0006\u0002\b0J\n\u00101\u001a\u0004\u0018\u000102H\u0002J\b\u00103\u001a\u00020!H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020-H\u0002J\b\u00106\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00069"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/plugins/serialmonitor/service/SerialPortsListener;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "portProfile", "Lcom/intellij/plugins/serialmonitor/SerialPortProfile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/plugins/serialmonitor/SerialPortProfile;)V", "getPortProfile", "()Lcom/intellij/plugins/serialmonitor/SerialPortProfile;", "myPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "myTopPanel", "Lcom/intellij/ui/components/JBPanel;", "mySend", "Ljavax/swing/JButton;", "myCommand", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "myLineEnd", "Lcom/intellij/ui/components/JBCheckBox;", "myHardwareControls", "Lcom/intellij/openapi/ui/DialogPanel;", "myHardwareStatusComponents", "Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor$HardwareStatusComponents;", "duplexConsoleView", "Lcom/intellij/plugins/serialmonitor/ui/console/JeditermSerialMonitorDuplexConsoleView;", "getStatus", "Lcom/intellij/plugins/serialmonitor/service/PortStatus;", "portsStatusChanged", "", "notifyProfileChanged", "send", "txt", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "disconnect", "dispose", "connect", "isTimestamped", "", "isTimestamped$intellij_serial_monitor", "isHex", "isHex$intellij_serial_monitor", "toolbarBorder", "Ljavax/swing/border/Border;", "updateHardwareVisibility", "hideSendControls", "q", "updateTopPanelVisibility", "HardwareStatusComponents", "Companion", "intellij.serial.monitor"})
public final class SerialMonitor
implements Disposable,
SerialPortsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SerialPortProfile portProfile;
    @NotNull
    private final JBLoadingPanel myPanel;
    @NotNull
    private final JBPanel<JBPanel<?>> myTopPanel;
    @NotNull
    private final JButton mySend;
    @NotNull
    private final TextFieldWithStoredHistory myCommand;
    @NotNull
    private final JBCheckBox myLineEnd;
    @NotNull
    private final DialogPanel myHardwareControls;
    @NotNull
    private final HardwareStatusComponents myHardwareStatusComponents;
    @NotNull
    private final JeditermSerialMonitorDuplexConsoleView duplexConsoleView;
    @NotNull
    private static final String SERIAL_NOTIFICATION_GROUP_NAME = "Serial Monitor Notification";
    private static final int SIZE_POLICY_RESIZEABLE = 7;

    public SerialMonitor(@NotNull Project project, @NotNull String name, @NotNull SerialPortProfile portProfile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)portProfile, (String)"portProfile");
        this.project = project;
        this.portProfile = portProfile;
        this.myPanel = new JBLoadingPanel((LayoutManager)new GridLayoutManager(2, 2, (Insets)JBUI.emptyInsets(), 0, 0), (Disposable)this, 300);
        this.myTopPanel = new JBPanel((LayoutManager)new GridLayoutManager(1, 4, (Insets)JBUI.insets((int)5, (int)10), 5, 0));
        this.myHardwareStatusComponents = new HardwareStatusComponents();
        this.myPanel.setLoadingText(SerialMonitorBundle.message("connecting", new Object[0]));
        JeditermSerialMonitorDuplexConsoleView jeditermSerialMonitorDuplexConsoleView = JeditermSerialMonitorDuplexConsoleView.create(this.project, this.portProfile, this.myPanel);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jeditermSerialMonitorDuplexConsoleView), (String)"create(...)");
        this.duplexConsoleView = jeditermSerialMonitorDuplexConsoleView;
        Disposer.register((Disposable)this, (Disposable)this.duplexConsoleView);
        JComponent jComponent = this.duplexConsoleView.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent consoleComponent = jComponent;
        DefaultActionGroup toolbarActions2 = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)toolbarActions2, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        AnAction[] anActionArray = this.duplexConsoleView.createConsoleActions();
        toolbarActions2.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        EditSettingsAction editProfileAction = new EditSettingsAction(name, this);
        toolbarActions2.add((AnAction)editProfileAction);
        toolbar.setTargetComponent(consoleComponent);
        toolbar.getComponent().setBorder(this.toolbarBorder());
        this.myCommand = new TextFieldWithStoredHistory("serialMonitor.commands");
        this.myCommand.setHistorySize(10);
        this.myCommand.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isControlDown() && e.getKeyChar() == '\n') {
                    myCommand.hidePopup();
                    mySend.doClick();
                }
            }
        });
        this.myLineEnd = new JBCheckBox(SerialMonitorBundle.message("checkbox.send.eol", new Object[0]), true);
        this.mySend = new JButton(SerialMonitorBundle.message("send.title", new Object[0]));
        this.mySend.setEnabled(false);
        this.mySend.addActionListener(arg_0 -> SerialMonitor._init_$lambda$0(this, arg_0));
        SerialPortService.SerialConnection serialConnection = this.duplexConsoleView.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)serialConnection, (String)"getConnection(...)");
        SerialPortService.SerialConnection connection = serialConnection;
        this.myHardwareControls = BuilderKt.panel(arg_0 -> SerialMonitor._init_$lambda$1(connection, this, arg_0));
        this.myHardwareControls.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        connection.setDsrListener((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)this.myHardwareStatusComponents){

            public final void invoke(boolean p0) {
                ((HardwareStatusComponents)this.receiver).onDSRChanged(p0);
            }
        }));
        connection.setCtsListener((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)this.myHardwareStatusComponents){

            public final void invoke(boolean p0) {
                ((HardwareStatusComponents)this.receiver).onCTSChanged(p0);
            }
        }));
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(SerialPortsListener.Companion.getSERIAL_PORTS_TOPIC(), (Object)this);
        this.myTopPanel.add((Component)this.myCommand, (Object)new GridConstraints(0, 0, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myTopPanel.add((Component)this.myLineEnd, (Object)new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTopPanel.add((Component)this.mySend, (Object)new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTopPanel.add((Component)this.myHardwareControls, (Object)new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTopPanel.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
        JComponent jComponent2 = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        this.myPanel.add((Component)jComponent2, (Object)new GridConstraints(0, 0, 2, 1, 8, 2, 0, 7, null, null, null));
        this.myPanel.add((Component)this.myTopPanel, (Object)new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, null, null, null));
        this.myPanel.add((Component)consoleComponent, (Object)new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.duplexConsoleView.addSwitchListener(this::hideSendControls, this);
        this.hideSendControls(this.duplexConsoleView.isPrimaryConsoleEnabled());
        this.updateHardwareVisibility();
    }

    @NotNull
    public final SerialPortProfile getPortProfile() {
        return this.portProfile;
    }

    @NotNull
    public final PortStatus getStatus() {
        PortStatus portStatus = this.duplexConsoleView.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)portStatus), (String)"getStatus(...)");
        return portStatus;
    }

    @Override
    public void portsStatusChanged() {
        ApplicationKt.getApplication().invokeLater(() -> SerialMonitor.portsStatusChanged$lambda$0(this));
        ActivityTracker.getInstance().inc();
    }

    public final void notifyProfileChanged() {
        this.duplexConsoleView.reconnect();
        this.updateHardwareVisibility();
    }

    private final void send(String txt) {
        Object s = null;
        s = txt;
        if (this.myLineEnd.isSelected()) {
            s = s + this.portProfile.getNewLine().getValue();
        }
        if (((CharSequence)s).length() > 0) {
            JeditermSerialMonitorDuplexConsoleView jeditermSerialMonitorDuplexConsoleView;
            JeditermSerialMonitorDuplexConsoleView $this$send_u24lambda_u240 = jeditermSerialMonitorDuplexConsoleView = this.duplexConsoleView;
            boolean bl = false;
            Object object = s;
            Charset charset = $this$send_u24lambda_u240.getCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            ApplicationManager.getApplication().executeOnPooledThread(() -> SerialMonitor.send$lambda$0$0($this$send_u24lambda_u240, bytes, this));
        }
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.myPanel;
    }

    public final void disconnect() {
        this.duplexConsoleView.connect(false);
    }

    public void dispose() {
    }

    public final void connect() {
        this.duplexConsoleView.connect(true);
    }

    public final boolean isTimestamped$intellij_serial_monitor() {
        return this.duplexConsoleView.isTimestamped();
    }

    public final boolean isHex$intellij_serial_monitor() {
        return !this.duplexConsoleView.isPrimaryConsoleEnabled();
    }

    private final Border toolbarBorder() {
        return JBUI.Borders.compound((Border)JBUI.Borders.customLineRight((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)9));
    }

    private final void updateHardwareVisibility() {
        this.myHardwareControls.setVisible(this.portProfile.getShowHardwareControls());
        this.updateTopPanelVisibility();
    }

    private final void hideSendControls(boolean q) {
        this.mySend.setVisible(!q);
        this.myCommand.setVisible(!q);
        this.myLineEnd.setVisible(!q);
        this.updateTopPanelVisibility();
    }

    private final void updateTopPanelVisibility() {
        this.myTopPanel.setVisible(this.mySend.isVisible() || this.myCommand.isVisible() || this.myLineEnd.isVisible() || this.myHardwareControls.isVisible());
    }

    private static final void portsStatusChanged$lambda$0(SerialMonitor this$0) {
        this$0.mySend.setEnabled(this$0.duplexConsoleView.getStatus() == PortStatus.CONNECTED);
        this$0.myHardwareStatusComponents.onCTSChanged(this$0.duplexConsoleView.getConnection().getCts());
        this$0.myHardwareStatusComponents.onDSRChanged(this$0.duplexConsoleView.getConnection().getDsr());
    }

    private static final void send$lambda$0$0(JeditermSerialMonitorDuplexConsoleView $this_apply, byte[] $bytes, SerialMonitor this$0) {
        try {
            $this_apply.getConnection().write($bytes);
        }
        catch (SerialMonitorException sme) {
            String string = sme.getMessage();
            Intrinsics.checkNotNull((Object)string);
            Companion.errorNotification(string, this$0.project);
        }
    }

    private static final void _init_$lambda$0(SerialMonitor this$0, ActionEvent it) {
        String string = this$0.myCommand.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.send(string);
        this$0.myCommand.addCurrentTextToHistory();
        this$0.myCommand.setText("");
    }

    private static final Unit _init_$lambda$1(SerialPortService.SerialConnection $connection, SerialMonitor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SerialMonitor.lambda$1$0($connection, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0(SerialPortService.SerialConnection $connection, SerialMonitor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SerialMonitorBundle.message("hardware.flow.control.rts", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell rtsCheckbox = $this$row.checkBox(string).applyToComponent(SerialMonitor::lambda$1$0$0);
        String string2 = SerialMonitorBundle.message("hardware.flow.control.dtr", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell dtrCheckbox = $this$row.checkBox(string2).applyToComponent(SerialMonitor::lambda$1$0$1);
        ((JBCheckBox)rtsCheckbox.getComponent()).setSelected($connection.getRts());
        SerialMonitor.lambda$1$0$changesBind((Cell<? extends JBCheckBox>)rtsCheckbox, this$0, (KMutableProperty1<SerialPortService.SerialConnection, Boolean>)((KMutableProperty1)3.1.1.INSTANCE), $connection);
        ((JBCheckBox)dtrCheckbox.getComponent()).setSelected($connection.getDtr());
        SerialMonitor.lambda$1$0$changesBind((Cell<? extends JBCheckBox>)dtrCheckbox, this$0, (KMutableProperty1<SerialPortService.SerialConnection, Boolean>)((KMutableProperty1)3.1.2.INSTANCE), $connection);
        JBColor jBColor = JBColor.namedColor((String)"ColorPalette.Green7", (Color)ColorUtil.fromHex((String)"#00FF00"));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor statusColor = jBColor;
        Icon icon = AllIcons.Debugger.ThreadAtBreakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ThreadAtBreakpoint");
        Icon statusIcon = IconUtil.colorize$default((Icon)icon, (Color)((Color)statusColor), (boolean)true, (boolean)false, (int)8, null);
        this$0.myHardwareStatusComponents.setCts($this$row.icon(statusIcon).gap(RightGap.SMALL).applyToComponent(SerialMonitor::lambda$1$0$3).getComponent());
        String string3 = SerialMonitorBundle.message("hardware.flow.control.cts", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$row.label(string3).applyToComponent(SerialMonitor::lambda$1$0$4);
        this$0.myHardwareStatusComponents.setDsr($this$row.icon(statusIcon).gap(RightGap.SMALL).applyToComponent(SerialMonitor::lambda$1$0$5).getComponent());
        String string4 = SerialMonitorBundle.message("hardware.flow.control.dsr", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$row.label(string4).applyToComponent(SerialMonitor::lambda$1$0$6);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.rts.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$1(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.dtr.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final void lambda$1$0$changesBind(Cell<? extends JBCheckBox> $this$lambda_u241_u240_u24changesBind, SerialMonitor this$0, KMutableProperty1<SerialPortService.SerialConnection, Boolean> prop, SerialPortService.SerialConnection connection) {
        ButtonKt.whenStateChangedFromUi($this$lambda_u241_u240_u24changesBind, (Disposable)this$0, arg_0 -> SerialMonitor.lambda$1$0$changesBind$2(prop, connection, this$0, arg_0));
    }

    private static final Unit lambda$1$0$changesBind$2(KMutableProperty1 $prop, SerialPortService.SerialConnection $connection, SerialMonitor this$0, boolean it) {
        try {
            boolean value = (Boolean)$prop.get((Object)$connection);
            if (value != it) {
                $prop.set((Object)$connection, (Object)it);
            }
        }
        catch (SerialMonitorException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            Companion.errorNotification(string, this$0.project);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$3(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.cts.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$4(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.cts.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$5(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.dsr.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$0$6(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(SerialMonitorBundle.message("hardware.flow.control.dsr.tooltip", new Object[0]));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001b\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor$Companion;", "", "<init>", "()V", "SERIAL_NOTIFICATION_GROUP_NAME", "", "SIZE_POLICY_RESIZEABLE", "", "errorNotification", "", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljava/awt/Component;", "intellij.serial.monitor"})
    @SourceDebugExtension(value={"SMAP\nSerialMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialMonitor.kt\ncom/intellij/plugins/serialmonitor/ui/SerialMonitor$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,293:1\n42#2,3:294\n*S KotlinDebug\n*F\n+ 1 SerialMonitor.kt\ncom/intellij/plugins/serialmonitor/ui/SerialMonitor$Companion\n*L\n283#1:294,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void errorNotification(@NotNull String content, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            boolean $i$f$service = false;
            Class<NotificationGroupManager> serviceClass$iv = NotificationGroupManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((NotificationGroupManager)object).getNotificationGroup(SerialMonitor.SERIAL_NOTIFICATION_GROUP_NAME).createNotification(content, NotificationType.ERROR).notify(project);
        }

        public final void errorNotification(@NotNull String content, @NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.errorNotification(content, ProjectUtil.getProjectForComponent((Component)component));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor$HardwareStatusComponents;", "", "<init>", "()V", "cts", "Ljavax/swing/JComponent;", "getCts", "()Ljavax/swing/JComponent;", "setCts", "(Ljavax/swing/JComponent;)V", "dsr", "getDsr", "setDsr", "onCTSChanged", "", "state", "", "onDSRChanged", "intellij.serial.monitor"})
    public static final class HardwareStatusComponents {
        public JComponent cts;
        public JComponent dsr;

        @NotNull
        public final JComponent getCts() {
            JComponent jComponent = this.cts;
            if (jComponent != null) {
                return jComponent;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"cts");
            return null;
        }

        public final void setCts(@NotNull JComponent jComponent) {
            Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
            this.cts = jComponent;
        }

        @NotNull
        public final JComponent getDsr() {
            JComponent jComponent = this.dsr;
            if (jComponent != null) {
                return jComponent;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"dsr");
            return null;
        }

        public final void setDsr(@NotNull JComponent jComponent) {
            Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
            this.dsr = jComponent;
        }

        @RequiresEdt
        public final void onCTSChanged(boolean state) {
            this.getCts().setEnabled(state);
        }

        @RequiresEdt
        public final void onDSRChanged(boolean state) {
            this.getDsr().setEnabled(state);
        }
    }
}

