/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.service.PortStatus;
import com.intellij.plugins.serialmonitor.service.SerialPortsListener;
import com.intellij.plugins.serialmonitor.ui.ConnectPanel;
import com.intellij.plugins.serialmonitor.ui.ConnectPanelKt;
import com.intellij.plugins.serialmonitor.ui.ConnectableList;
import com.intellij.plugins.serialmonitor.ui.SerialMonitor;
import com.intellij.plugins.serialmonitor.ui.SerialSettingsUIKt;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0019\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u001d\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\r\b\u0002\u0010\u001c\u001a\u00070\u0012\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\r\b\u0002\u0010\u001c\u001a\u00070\u0012\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/plugins/serialmonitor/ui/ConnectPanel;", "Lcom/intellij/ui/OnePixelSplitter;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "ports", "Lcom/intellij/plugins/serialmonitor/ui/ConnectableList;", "disposable", "Lcom/intellij/openapi/Disposable;", "listToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "Lorg/jetbrains/annotations/NotNull;", "selectionChanged", "", "contentByPortName", "Lcom/intellij/ui/content/Content;", "portName", "", "monitorByProfile", "Lcom/intellij/plugins/serialmonitor/ui/SerialMonitor;", "profile", "Lcom/intellij/plugins/serialmonitor/SerialPortProfile;", "getOpenedMonitor", "openConsole", "disconnectPort", "notifyProfileChanged", "reconnectProfile", "name", "Lorg/jetbrains/annotations/Nls;", "connectProfile", "intellij.serial.monitor"})
@SourceDebugExtension(value={"SMAP\nConnectPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectPanel.kt\ncom/intellij/plugins/serialmonitor/ui/ConnectPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1#2:167\n1400#3,2:155\n11879#3,9:157\n13805#3:166\n13806#3:168\n11888#3:169\n295#4,2:170\n*S KotlinDebug\n*F\n+ 1 ConnectPanel.kt\ncom/intellij/plugins/serialmonitor/ui/ConnectPanel\n*L\n86#1:167\n78#1:155,2\n86#1:157,9\n86#1:166\n86#1:168\n86#1:169\n87#1:170,2\n*E\n"})
public final class ConnectPanel
extends OnePixelSplitter {
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final ConnectableList ports;
    @NotNull
    private Disposable disposable;
    @NotNull
    private final ActionToolbar listToolbar;

    /*
     * WARNING - void declaration
     */
    public ConnectPanel(@NotNull ToolWindow toolWindow) {
        void $this$listToolbar_u24lambda_u240;
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(false, 0.4f, 0.1f, 0.9f);
        this.toolWindow = toolWindow;
        this.ports = new ConnectableList(this);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        ActionToolbar actionToolbar2 = actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", this.ports.getToolbarActions(), true);
        ConnectPanel connectPanel = this;
        boolean bl = false;
        $this$listToolbar_u24lambda_u240.setTargetComponent((JComponent)((Object)this.ports));
        ActionToolbar actionToolbar3 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar3, (String)"apply(...)");
        connectPanel.listToolbar = actionToolbar3;
        this.setAndLoadSplitterProportionKey("ConnectPanel.splitterProportionKey");
        this.setFirstComponent((JComponent)BuilderKt.panel(arg_0 -> ConnectPanel._init_$lambda$0(this, arg_0)));
        this.ports.addListSelectionListener(arg_0 -> ConnectPanel._init_$lambda$1(this, arg_0));
        this.setSecondComponent((JComponent)new JBPanel());
    }

    /*
     * WARNING - void declaration
     */
    private final void selectionChanged() {
        DialogPanel panel;
        this.getSecondComponent().removeAll();
        Disposer.dispose((Disposable)this.disposable);
        Disposable disposable = Disposer.newDisposable((String)"Serial Profile Parameters");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        Disposer.register((Disposable)this.toolWindow.getDisposable(), (Disposable)this.disposable);
        String portName = this.ports.getSelectedPortName();
        DialogPanel dialogPanel = panel = portName != null ? SerialSettingsUIKt.portSettings(this.ports, portName, this.disposable) : SerialSettingsUIKt.profileSettings(this.ports, this.disposable);
        if (panel != null) {
            void $this$selectionChanged_u24lambda_u240;
            JBScrollPane jBScrollPane;
            JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)panel);
            ConnectPanel connectPanel = this;
            boolean bl = false;
            $this$selectionChanged_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
            connectPanel.setSecondComponent((JComponent)jBScrollPane);
            this.invalidate();
        }
    }

    private final Content contentByPortName(String portName) {
        Object object;
        block2: {
            if (portName == null) {
                return null;
            }
            Content[] contentArray = this.toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                SerialMonitor serialMonitor = (SerialMonitor)it.getUserData(ConnectPanelKt.getSERIAL_MONITOR());
                Object object2 = serialMonitor;
                if (!Intrinsics.areEqual((Object)(object2 != null && (object2 = ((SerialMonitor)object2).getPortProfile()) != null ? ((SerialPortProfile)object2).getPortName() : null), (Object)portName)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        return (Content)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SerialMonitor monitorByProfile(SerialPortProfile profile) {
        Object v1;
        block2: {
            void $this$mapNotNullTo$iv$iv;
            Content[] contentArray = this.toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$mapNotNull$iv = contentArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                SerialMonitor it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                Content it = (Content)element$iv$iv;
                boolean bl2 = false;
                if ((SerialMonitor)it.getUserData(ConnectPanelKt.getSERIAL_MONITOR()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SerialMonitor it = (SerialMonitor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPortProfile(), (Object)profile)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final SerialMonitor getOpenedMonitor(@NotNull String portName) {
        Intrinsics.checkNotNullParameter((Object)portName, (String)"portName");
        Content content = this.contentByPortName(portName);
        return content != null ? (SerialMonitor)content.getUserData(ConnectPanelKt.getSERIAL_MONITOR()) : null;
    }

    public final void openConsole(@Nullable String portName) {
        Content content;
        Content content2 = content = this.contentByPortName(portName);
        if (content2 == null) {
            return;
        }
        this.toolWindow.getContentManager().setSelectedContent(content2);
    }

    public final void disconnectPort(@Nullable String portName) {
        block0: {
            Object object = this.contentByPortName(portName);
            if (object == null || (object = (SerialMonitor)object.getUserData(ConnectPanelKt.getSERIAL_MONITOR())) == null) break block0;
            ((SerialMonitor)object).disconnect();
        }
    }

    public final void notifyProfileChanged(@NotNull SerialPortProfile profile) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            SerialMonitor serialMonitor = this.monitorByProfile(profile);
            if (serialMonitor == null) break block0;
            serialMonitor.notifyProfileChanged();
        }
    }

    public final void reconnectProfile(@NotNull SerialPortProfile profile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Content openedTab = this.contentByPortName(profile.getPortName());
        if (openedTab != null) {
            this.toolWindow.getContentManager().removeContent(openedTab, true);
        }
        this.connectProfile(profile, name);
    }

    public static /* synthetic */ void reconnectProfile$default(ConnectPanel connectPanel, SerialPortProfile serialPortProfile, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = serialPortProfile.defaultName();
        }
        connectPanel.reconnectProfile(serialPortProfile, string);
    }

    public final void connectProfile(@NotNull SerialPortProfile profile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        Content content = ContentFactory.getInstance().createContent((JComponent)panel, name, true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SerialMonitor serialMonitor = new SerialMonitor(project, name, profile);
        content2.putUserData(ConnectPanelKt.getSERIAL_MONITOR(), (Object)serialMonitor);
        panel.setContent(serialMonitor.getComponent());
        content2.setDisposer((Disposable)serialMonitor);
        content2.setCloseable(true);
        contentManager2.addContent(content2);
        SerialPortsListener handler2 = new SerialPortsListener(serialMonitor, content2, this){
            final /* synthetic */ SerialMonitor $serialMonitor;
            final /* synthetic */ Content $content;
            final /* synthetic */ ConnectPanel this$0;
            {
                this.$serialMonitor = $serialMonitor;
                this.$content = $content;
                this.this$0 = $receiver;
            }

            public void portsStatusChanged() {
                ApplicationKt.getApplication().invokeLater(() -> connectProfile.handler.1.portsStatusChanged$lambda$0(this.$serialMonitor, this.$content), arg_0 -> connectProfile.handler.1.portsStatusChanged$lambda$1(this.this$0, arg_0));
            }

            private static final void portsStatusChanged$lambda$0(SerialMonitor $serialMonitor, Content $content) {
                PortStatus status = $serialMonitor.getStatus();
                $content.setIcon(status == PortStatus.DISCONNECTED ? AllIcons.Nodes.EmptyNode : status.getIcon());
            }

            private static final boolean portsStatusChanged$lambda$1(ConnectPanel this$0, Object it) {
                return ConnectPanel.access$getToolWindow$p(this$0).isDisposed();
            }
        };
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)content2).subscribe(SerialPortsListener.Companion.getSERIAL_PORTS_TOPIC(), (Object)handler2);
        serialMonitor.connect();
        contentManager2.setSelectedContent(content2, true);
        this.toolWindow.setAvailable(true);
        this.toolWindow.show();
        this.toolWindow.activate(null, true);
    }

    public static /* synthetic */ void connectProfile$default(ConnectPanel connectPanel, SerialPortProfile serialPortProfile, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = serialPortProfile.defaultName();
        }
        connectPanel.connectProfile(serialPortProfile, string);
    }

    private static final Unit _init_$lambda$0(ConnectPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConnectPanel.lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConnectPanel.lambda$0$1(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(ConnectPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.listToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(ConnectPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new JBScrollPane((Component)((Object)this$0.ports))).align(Align.FILL).applyToComponent(ConnectPanel::lambda$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$0(JBScrollPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setBorder((Border)JBUI.Borders.empty());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(ConnectPanel this$0, ListSelectionEvent it) {
        this$0.selectionChanged();
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow$p(ConnectPanel $this) {
        return $this.toolWindow;
    }
}

