/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.service;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.plugins.serialmonitor.SerialMonitorCollector;
import com.intellij.plugins.serialmonitor.SerialMonitorException;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.service.PortStatus;
import com.intellij.plugins.serialmonitor.service.SerialPort;
import com.intellij.plugins.serialmonitor.service.SerialPortException;
import com.intellij.plugins.serialmonitor.service.SerialPortProvider;
import com.intellij.plugins.serialmonitor.service.SerialPortService;
import com.intellij.plugins.serialmonitor.service.SerialPortsListener;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0014\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0082@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0012\u0010\u001d\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0015\u0010!\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\"2\u0006\u0010\u001e\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u000eR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/plugins/serialmonitor/service/SerialPortService;", "Lcom/intellij/openapi/Disposable$Default;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "portNames", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "", "connections", "", "Lcom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection;", "portNamesFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getPortNamesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "NAME_COMPARATOR", "com/intellij/plugins/serialmonitor/service/SerialPortService$NAME_COMPARATOR$1", "Lcom/intellij/plugins/serialmonitor/service/SerialPortService$NAME_COMPARATOR$1;", "scanPorts", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rescanPorts", "", "portMessageTopic", "Lcom/intellij/plugins/serialmonitor/service/SerialPortsListener;", "getPortsNames", "newConnection", "portName", "portStatus", "Lcom/intellij/plugins/serialmonitor/service/PortStatus;", "portDescriptiveName", "Lorg/jetbrains/annotations/Nls;", "SerialConnection", "intellij.serial.monitor"})
@SourceDebugExtension(value={"SMAP\nSerialPortService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialPortService.kt\ncom/intellij/plugins/serialmonitor/service/SerialPortService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,265:1\n70#2,6:266\n1#3:272\n42#4,3:273\n*S KotlinDebug\n*F\n+ 1 SerialPortService.kt\ncom/intellij/plugins/serialmonitor/service/SerialPortService\n*L\n74#1:266,6\n115#1:273,3\n*E\n"})
public final class SerialPortService
implements Disposable.Default {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MutableStateFlow<Set<String>> portNames;
    @NotNull
    private final Map<String, SerialConnection> connections;
    @NotNull
    private final NAME_COMPARATOR.1 NAME_COMPARATOR;

    public SerialPortService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.portNames = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.connections = new ConcurrentHashMap();
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)new CoroutineName("Serial Port Watcher")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SerialPortService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = SerialPortService.access$rescanPorts(this.this$0, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SerialPortService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.portNames.collect(new FlowCollector(){

                            public final Object emit(Set<String> it, Continuation<? super Unit> $completion) {
                                this$0.portMessageTopic().portsStatusChanged();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.NAME_COMPARATOR = new Comparator<String>(){

            private final Pair<String, Integer> splitName(String s) {
                int digitIdx;
                Integer num = null;
                int mul = 1;
                for (digitIdx = s.length() - 1; digitIdx >= 0 && Character.isDigit(s.charAt(digitIdx)); --digitIdx) {
                    Integer n = num;
                    num = (n != null ? n : 0) + mul * (s.charAt(digitIdx) - 48);
                    mul *= 10;
                }
                Integer n = num;
                return TuplesKt.to((Object)StringsKt.take((String)s, (int)(digitIdx + 1)), (Object)(n != null ? n : -1));
            }

            public int compare(String name1, String name2) {
                Intrinsics.checkNotNullParameter((Object)name1, (String)"name1");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name2");
                Pair<String, Integer> pair = this.splitName(name1);
                String base1 = (String)pair.component1();
                int idx1 = ((Number)pair.component2()).intValue();
                Pair<String, Integer> pair2 = this.splitName(name2);
                String base2 = (String)pair2.component1();
                int idx2 = ((Number)pair2.component2()).intValue();
                int result = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(base1, base2);
                return result == 0 ? idx1 - idx2 : result;
            }
        };
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @NotNull
    public final StateFlow<Set<String>> getPortNamesFlow() {
        return (StateFlow)this.portNames;
    }

    /*
     * Unable to fully structure code
     */
    private final Object scanPorts(Continuation<? super Set<String>> $completion) {
        if (!($completion instanceof scanPorts.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                int I$1;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SerialPortService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SerialPortService.access$scanPorts(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$serviceAsync = 0;
                v0 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v0;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(SerialPortProvider.class, (Continuation)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                portProvider = (SerialPortProvider)v1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)portProvider);
                $continuation.label = 2;
                v2 = portProvider.scanAvailablePorts((Continuation<? super List<String>>)$continuation);
                if (v2 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                portProvider = (SerialPortProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                return CollectionsKt.toCollection((Iterable)((Iterable)v2), (Collection)new TreeSet<E>(this.NAME_COMPARATOR));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object rescanPorts(Continuation<? super Unit> $completion) {
        if (!($completion instanceof rescanPorts.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SerialPortService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SerialPortService.access$rescanPorts(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.scanPorts((Continuation<? super Set<String>>)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                portList = (Set)v0;
                for (String name : (Set)this.portNames.getValue()) {
                    if (portList.contains(name)) continue;
                    v1 = this.connections.get(name);
                    if (v1 == null) continue;
                    v1.closeSilently(false);
                }
                for (String name : portList) {
                    v2 = this.connections.get(name);
                    if ((v2 != null ? v2.getStatus() : null) != PortStatus.UNAVAILABLE_DISCONNECTED) continue;
                    v3 = this.connections.get(name);
                    if (v3 == null) continue;
                    v3.setStatus$intellij_serial_monitor(PortStatus.DISCONNECTED);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)portList);
                $continuation.label = 2;
                v4 = this.portNames.emit((Object)portList, (Continuation)$continuation);
                if (v4 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                portList = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SerialPortsListener portMessageTopic() {
        return (SerialPortsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SerialPortsListener.Companion.getSERIAL_PORTS_TOPIC());
    }

    @NotNull
    public final Set<String> getPortsNames() {
        return (Set)this.portNames.getValue();
    }

    @NotNull
    public final SerialConnection newConnection(@NotNull String portName) {
        Intrinsics.checkNotNullParameter((Object)portName, (String)"portName");
        SerialConnection serialConnection = this.connections.get(portName);
        if (serialConnection != null) {
            SerialConnection serialConnection2;
            SerialConnection it = serialConnection2 = serialConnection;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        SerialConnection serialConnection3 = new SerialConnection(portName);
        this.connections.put(portName, serialConnection3);
        return serialConnection3;
    }

    @NotNull
    public final PortStatus portStatus(@NotNull String portName) {
        Intrinsics.checkNotNullParameter((Object)portName, (String)"portName");
        if (!((Set)this.portNames.getValue()).contains(portName)) {
            return this.connections.containsKey(portName) ? PortStatus.UNAVAILABLE_DISCONNECTED : PortStatus.UNAVAILABLE;
        }
        Object object = this.connections.get(portName);
        if (object == null || (object = object.getStatus()) == null) {
            object = PortStatus.READY;
        }
        return object;
    }

    @Nullable
    public final String portDescriptiveName(@NotNull String portName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)portName, (String)"portName");
        Object object2 = this;
        try {
            SerialPortService $this$portDescriptiveName_u24lambda_u240 = object2;
            boolean bl = false;
            boolean $i$f$service = false;
            Class<SerialPortProvider> serviceClass$iv = SerialPortProvider.class;
            Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object3 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            object = Result.constructor-impl((Object)((SerialPortProvider)object3).createPort(portName).getDescriptiveName());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        String description = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        return description;
    }

    public static final /* synthetic */ Object access$scanPorts(SerialPortService $this, Continuation $completion) {
        return $this.scanPorts((Continuation<? super Set<String>>)$completion);
    }

    public static final /* synthetic */ Object access$rescanPorts(SerialPortService $this, Continuation $completion) {
        return $this.rescanPorts((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u00015\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010-\u001a\u00020\u0013H\u0016J\u0006\u0010.\u001a\u00020\u001eJ\u0015\u0010/\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b0J\u000e\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0012J\u000e\u00103\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0012J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u000209H\u0007J\u000e\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u000bR\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u0011\u0010)\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b*\u0010#R\u0011\u0010+\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b,\u0010#R\u0010\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106\u00a8\u0006<"}, d2={"Lcom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection;", "Lcom/intellij/openapi/Disposable;", "portName", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/plugins/serialmonitor/service/SerialPortService;Ljava/lang/String;)V", "getPortName", "()Ljava/lang/String;", "dataListener", "Ljava/util/function/Consumer;", "", "getDataListener", "()Ljava/util/function/Consumer;", "setDataListener", "(Ljava/util/function/Consumer;)V", "dsrListener", "Lkotlin/Function1;", "", "", "getDsrListener", "()Lkotlin/jvm/functions/Function1;", "setDsrListener", "(Lkotlin/jvm/functions/Function1;)V", "ctsListener", "getCtsListener", "setCtsListener", "port", "Lcom/intellij/plugins/serialmonitor/service/SerialPort;", "status", "Lcom/intellij/plugins/serialmonitor/service/PortStatus;", "localEcho", "value", "rts", "getRts", "()Z", "setRts", "(Z)V", "dtr", "getDtr", "setDtr", "cts", "getCts", "dsr", "getDsr", "dispose", "getStatus", "setStatus", "setStatus$intellij_serial_monitor", "close", "portAvailable", "closeSilently", "listener", "com/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection$listener$1", "Lcom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection$listener$1;", "connect", "profile", "Lcom/intellij/plugins/serialmonitor/SerialPortProfile;", "write", "data", "intellij.serial.monitor"})
    @SourceDebugExtension(value={"SMAP\nSerialPortService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialPortService.kt\ncom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,265:1\n23#2:266\n122#2,4:267\n23#2:271\n122#2,4:272\n42#3,3:276\n*S KotlinDebug\n*F\n+ 1 SerialPortService.kt\ncom/intellij/plugins/serialmonitor/service/SerialPortService$SerialConnection\n*L\n161#1:266\n161#1:267,4\n167#1:271\n167#1:272,4\n231#1:276,3\n*E\n"})
    public final class SerialConnection
    implements Disposable {
        @NotNull
        private final String portName;
        @Nullable
        private Consumer<byte[]> dataListener;
        @Nullable
        private Function1<? super Boolean, Unit> dsrListener;
        @Nullable
        private Function1<? super Boolean, Unit> ctsListener;
        @Nullable
        private volatile SerialPort port;
        @NotNull
        private volatile PortStatus status;
        private boolean localEcho;
        private boolean rts;
        private boolean dtr;
        @NotNull
        private final listener.1 listener;

        public SerialConnection(String portName) {
            Intrinsics.checkNotNullParameter((Object)portName, (String)"portName");
            this.portName = portName;
            this.status = PortStatus.DISCONNECTED;
            this.rts = true;
            this.dtr = true;
            this.listener = new SerialPort.SerialPortListener(this, SerialPortService.this){
                final /* synthetic */ SerialConnection this$0;
                final /* synthetic */ SerialPortService this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onDataReceived(byte[] data) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        Consumer<byte[]> consumer = this.this$0.getDataListener();
                        if (consumer == null) break block0;
                        consumer.accept(data);
                    }
                }

                public void onCTSChanged(boolean state) {
                    BuildersKt.launch$default((CoroutineScope)this.this$1.getCs(), (CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, state, null){
                        int label;
                        final /* synthetic */ SerialConnection this$0;
                        final /* synthetic */ boolean $state;
                        {
                            this.this$0 = $receiver;
                            this.$state = $state;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Function1<Boolean, Unit> function1 = this.this$0.getCtsListener();
                                    if (function1 != null) {
                                        function1.invoke((Object)Boxing.boxBoolean((boolean)this.$state));
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }

                public void onDSRChanged(boolean state) {
                    BuildersKt.launch$default((CoroutineScope)this.this$1.getCs(), (CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, state, null){
                        int label;
                        final /* synthetic */ SerialConnection this$0;
                        final /* synthetic */ boolean $state;
                        {
                            this.this$0 = $receiver;
                            this.$state = $state;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Function1<Boolean, Unit> function1 = this.this$0.getDsrListener();
                                    if (function1 != null) {
                                        function1.invoke((Object)Boxing.boxBoolean((boolean)this.$state));
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            };
        }

        @NotNull
        public final String getPortName() {
            return this.portName;
        }

        @Nullable
        public final Consumer<byte[]> getDataListener() {
            return this.dataListener;
        }

        public final void setDataListener(@Nullable Consumer<byte[]> consumer) {
            this.dataListener = consumer;
        }

        @Nullable
        public final Function1<Boolean, Unit> getDsrListener() {
            return this.dsrListener;
        }

        public final void setDsrListener(@Nullable Function1<? super Boolean, Unit> function1) {
            this.dsrListener = function1;
        }

        @Nullable
        public final Function1<Boolean, Unit> getCtsListener() {
            return this.ctsListener;
        }

        public final void setCtsListener(@Nullable Function1<? super Boolean, Unit> function1) {
            this.ctsListener = function1;
        }

        public final boolean getRts() {
            return this.rts;
        }

        public final void setRts(boolean value) throws SerialMonitorException {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                SerialConnection $this$_set_rts__u24lambda_u240 = object2;
                boolean bl = false;
                SerialPort serialPort = $this$_set_rts__u24lambda_u240.port;
                if (serialPort != null) {
                    serialPort.setRTS(value);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.portName, ((Throwable)it).getMessage()};
                throw new SerialMonitorException(SerialMonitorBundle.message("port.modify.error", objectArray));
            }
            this.rts = value;
        }

        public final boolean getDtr() {
            return this.dtr;
        }

        public final void setDtr(boolean value) throws SerialMonitorException {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                SerialConnection $this$_set_dtr__u24lambda_u240 = object2;
                boolean bl = false;
                SerialPort serialPort = $this$_set_dtr__u24lambda_u240.port;
                if (serialPort != null) {
                    serialPort.setDTR(value);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.portName, ((Throwable)it).getMessage()};
                throw new SerialMonitorException(SerialMonitorBundle.message("port.modify.error", objectArray));
            }
            this.dtr = value;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getCts() {
            void $this$getOrHandleException$iv;
            Object $this$_get_cts__u24lambda_u240;
            Object object = this;
            try {
                $this$_get_cts__u24lambda_u240 = object;
                boolean bl = false;
                SerialPort serialPort = ((SerialConnection)$this$_get_cts__u24lambda_u240).port;
                $this$_get_cts__u24lambda_u240 = Result.constructor-impl((Object)(serialPort != null ? Boolean.valueOf(serialPort.getCTS()) : null));
            }
            catch (Throwable bl) {
                $this$_get_cts__u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$_get_cts__u24lambda_u240;
            SerialConnection $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SerialConnection.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            boolean $i$f$getOrHandleException = false;
            void var4_5 = $this$getOrHandleException$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)var4_5);
            if (throwable != null) {
                Throwable e$iv = throwable;
                boolean bl = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                Throwable p0 = e$iv;
                boolean bl2 = false;
                logger2.info(p0);
            }
            Boolean bl = (Boolean)(Result.isFailure-impl((Object)var4_5) ? null : var4_5);
            return bl != null ? bl : false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getDsr() {
            void $this$getOrHandleException$iv;
            Object $this$_get_dsr__u24lambda_u240;
            Object object = this;
            try {
                $this$_get_dsr__u24lambda_u240 = object;
                boolean bl = false;
                SerialPort serialPort = ((SerialConnection)$this$_get_dsr__u24lambda_u240).port;
                $this$_get_dsr__u24lambda_u240 = Result.constructor-impl((Object)(serialPort != null ? Boolean.valueOf(serialPort.getDSR()) : null));
            }
            catch (Throwable bl) {
                $this$_get_dsr__u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$_get_dsr__u24lambda_u240;
            SerialConnection $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SerialConnection.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            boolean $i$f$getOrHandleException = false;
            void var4_5 = $this$getOrHandleException$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)var4_5);
            if (throwable != null) {
                Throwable e$iv = throwable;
                boolean bl = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                Throwable p0 = e$iv;
                boolean bl2 = false;
                logger2.info(p0);
            }
            Boolean bl = (Boolean)(Result.isFailure-impl((Object)var4_5) ? null : var4_5);
            return bl != null ? bl : false;
        }

        public void dispose() {
            this.closeSilently(true);
            SerialPortService.this.connections.remove(this.portName, this);
            BuildersKt.launch$default((CoroutineScope)SerialPortService.this.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(SerialPortService.this, null){
                int label;
                final /* synthetic */ SerialPortService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = SerialPortService.access$rescanPorts(this.this$0, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public final PortStatus getStatus() {
            return this.status;
        }

        public final void setStatus$intellij_serial_monitor(@NotNull PortStatus value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            this.status = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close(boolean portAvailable) throws SerialMonitorException {
            try {
                SerialPort serialPort = this.port;
                if (serialPort != null) {
                    serialPort.disconnect();
                }
                this.status = portAvailable ? PortStatus.DISCONNECTED : PortStatus.UNAVAILABLE_DISCONNECTED;
            }
            catch (SerialPortException e) {
                try {
                    Object[] objectArray = new Object[]{this.portName, e.getMessage()};
                    throw new SerialMonitorException(SerialMonitorBundle.message("port.close.error", objectArray));
                }
                catch (Throwable throwable) {
                    this.status = portAvailable ? PortStatus.DISCONNECTED : PortStatus.UNAVAILABLE_DISCONNECTED;
                    this.port = null;
                    SerialPortService.this.portMessageTopic().portsStatusChanged();
                    throw throwable;
                }
            }
            this.port = null;
            SerialPortService.this.portMessageTopic().portsStatusChanged();
        }

        public final void closeSilently(boolean portAvailable) {
            try {
                this.close(portAvailable);
            }
            catch (SerialMonitorException serialMonitorException) {
                // empty catch block
            }
        }

        @RequiresBackgroundThread
        public final void connect(@NotNull SerialPortProfile profile) throws SerialMonitorException {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            this.status = PortStatus.CONNECTING;
            this.localEcho = profile.getLocalEcho();
            SerialPort newPort = null;
            try {
                boolean $i$f$service = false;
                Class<SerialPortProvider> serviceClass$iv = SerialPortProvider.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                newPort = ((SerialPortProvider)object).createPort(this.portName);
                SerialPortService.this.portMessageTopic().portsStatusChanged();
                SerialPort serialPort = newPort;
                if (serialPort == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"newPort");
                    serialPort = null;
                }
                serialPort.connect(profile, this.listener, this.rts, this.dtr);
                this.port = newPort;
                SerialMonitorCollector.INSTANCE.logConnect(profile.getBaudRate(), true);
                this.status = PortStatus.CONNECTED;
                SerialPortService.this.portMessageTopic().portsStatusChanged();
            }
            catch (Exception e) {
                SerialMonitorCollector.INSTANCE.logConnect(profile.getBaudRate(), false);
                try {
                    SerialPort serialPort = newPort;
                    if (serialPort == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"newPort");
                        serialPort = null;
                    }
                    serialPort.disconnect();
                }
                catch (SerialPortException serialPortException) {
                    // empty catch block
                }
                this.status = PortStatus.UNAVAILABLE_DISCONNECTED;
                SerialPortService.this.portMessageTopic().portsStatusChanged();
                Object[] objectArray = new Object[]{this.portName, e.getMessage()};
                throw new SerialMonitorException(SerialMonitorBundle.message("port.connect.error", objectArray));
            }
        }

        public final void write(@NotNull byte[] data) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                SerialPort serialPort = this.port;
                if (serialPort != null) {
                    serialPort.write(data);
                }
                if (!this.localEcho) break block2;
                Consumer<byte[]> consumer = this.dataListener;
                if (consumer != null) {
                    consumer.accept(data);
                }
            }
        }
    }
}

