/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.serialmonitor.service;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import com.intellij.plugins.serialmonitor.Parity;
import com.intellij.plugins.serialmonitor.SerialMonitorException;
import com.intellij.plugins.serialmonitor.SerialPortProfile;
import com.intellij.plugins.serialmonitor.StopBits;
import com.intellij.plugins.serialmonitor.service.BitFlagSwitchContext;
import com.intellij.plugins.serialmonitor.service.JSerialCommPort;
import com.intellij.plugins.serialmonitor.service.JSerialCommPortKt;
import com.intellij.plugins.serialmonitor.service.SerialPort;
import com.intellij.plugins.serialmonitor.service.SerialPortException;
import com.intellij.plugins.serialmonitor.ui.SerialMonitorBundle;
import com.intellij.util.system.OS;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\b\u0012\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u0014H\u0016J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010!\u001a\u00020\u0014*\u00060\u0003j\u0002`\u00042\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\u0014*\u00060\u0003j\u0002`\u00042\u0006\u0010\"\u001a\u00020\u0014H\u0002J#\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00142\u0011\u0010)\u001a\r\u0012\u0004\u0012\u00020\t0*\u00a2\u0006\u0002\b\fH\u0002R\u0012\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/plugins/serialmonitor/service/JSerialCommPort;", "Lcom/intellij/plugins/serialmonitor/service/SerialPort;", "port", "Lcom/fazecast/jSerialComm/SerialPort;", "Lcom/intellij/plugins/serialmonitor/service/JSerialComm_SerialPort;", "<init>", "(Lcom/fazecast/jSerialComm/SerialPort;)V", "serialPort", "getSystemName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDescriptiveName", "Lorg/jetbrains/annotations/Nls;", "connect", "", "profile", "Lcom/intellij/plugins/serialmonitor/SerialPortProfile;", "listener", "Lcom/intellij/plugins/serialmonitor/service/SerialPort$SerialPortListener;", "rts", "", "dtr", "convertParity", "", "parity", "Lcom/intellij/plugins/serialmonitor/Parity;", "convertStopBits", "stopBits", "Lcom/intellij/plugins/serialmonitor/StopBits;", "disconnect", "write", "data", "", "setRTS", "value", "setDTR", "getCTS", "getDSR", "addListener", "checkSuccess", "success", "lazyMessage", "Lkotlin/Function0;", "Companion", "intellij.serial.monitor"})
@SourceDebugExtension(value={"SMAP\nJSerialCommPort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSerialCommPort.kt\ncom/intellij/plugins/serialmonitor/service/JSerialCommPort\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class JSerialCommPort
implements SerialPort {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.fazecast.jSerialComm.SerialPort serialPort;

    private JSerialCommPort(com.fazecast.jSerialComm.SerialPort port) {
        this.serialPort = port;
    }

    @Override
    @NotNull
    public String getSystemName() {
        return JSerialCommPortKt.access$getSystemName(this.serialPort);
    }

    @Override
    @NotNull
    public String getDescriptiveName() {
        String string;
        if (OS.CURRENT == OS.Windows) {
            String string2 = this.serialPort.getPortDescription();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPortDescription(...)");
        } else {
            String string3 = this.serialPort.getDescriptivePortName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDescriptivePortName(...)");
        }
        return string;
    }

    @Override
    public void connect(@NotNull SerialPortProfile profile, @NotNull SerialPort.SerialPortListener listener2, boolean rts, boolean dtr) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.checkSuccess(this.setRTS(this.serialPort, rts), (Function0<String>)((Function0)JSerialCommPort::connect$lambda$0));
        this.checkSuccess(this.setDTR(this.serialPort, dtr), (Function0<String>)((Function0)JSerialCommPort::connect$lambda$1));
        if (!this.addListener(listener2)) {
            boolean $i$a$-check-JSerialCommPort$connect$42 = false;
            String string = SerialMonitorBundle.message("serial.port.listener.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-check-JSerialCommPort$connect$42 = string;
            throw new IllegalStateException($i$a$-check-JSerialCommPort$connect$42.toString());
        }
        SerialPortProfile $this$connect_u24lambda_u243 = profile;
        boolean bl = false;
        int portStopBits = this.convertStopBits($this$connect_u24lambda_u243.getStopBits());
        int portParity = this.convertParity($this$connect_u24lambda_u243.getParity());
        this.checkSuccess(this.serialPort.setComPortParameters($this$connect_u24lambda_u243.getBaudRate(), $this$connect_u24lambda_u243.getBits(), portStopBits, portParity), (Function0<String>)((Function0)JSerialCommPort::connect$lambda$3$0));
        this.checkSuccess(this.serialPort.openPort(), (Function0<String>)((Function0)JSerialCommPort::connect$lambda$4));
    }

    private final int convertParity(Parity parity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[parity.ordinal()]) {
            case 1 -> 2;
            case 2 -> 1;
            default -> 0;
        };
    }

    private final int convertStopBits(StopBits stopBits) {
        return switch (WhenMappings.$EnumSwitchMapping$1[stopBits.ordinal()]) {
            case 1 -> 3;
            case 2 -> 2;
            default -> 1;
        };
    }

    @Override
    public void disconnect() {
        this.checkSuccess(this.serialPort.closePort(), (Function0<String>)((Function0)() -> JSerialCommPort.disconnect$lambda$0(this)));
    }

    @Override
    public int write(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.serialPort.writeBytes(data, data.length);
    }

    @Override
    public void setRTS(boolean value) {
        this.checkSuccess(this.setRTS(this.serialPort, value), (Function0<String>)((Function0)JSerialCommPort::setRTS$lambda$0));
    }

    @Override
    public void setDTR(boolean value) {
        this.checkSuccess(this.setDTR(this.serialPort, value), (Function0<String>)((Function0)JSerialCommPort::setDTR$lambda$0));
    }

    @Override
    public boolean getCTS() {
        return this.serialPort.getCTS();
    }

    @Override
    public boolean getDSR() {
        return this.serialPort.getDSR();
    }

    public final boolean addListener(@NotNull SerialPort.SerialPortListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.serialPort.addDataListener(new SerialPortDataListener(listener2, this){
            final /* synthetic */ SerialPort.SerialPortListener $listener;
            final /* synthetic */ JSerialCommPort this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
            }

            public int getListeningEvents() {
                return 0x100C0010;
            }

            public void serialEvent(SerialPortEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JSerialCommPortKt.access$bitFlagSwitch(event.getEventType(), arg_0 -> addListener.1.serialEvent$lambda$0(this.$listener, event, this.this$0, arg_0));
            }

            private static final Unit serialEvent$lambda$0(SerialPort.SerialPortListener $listener, SerialPortEvent $event, JSerialCommPort this$0, BitFlagSwitchContext $this$bitFlagSwitch) {
                Intrinsics.checkNotNullParameter((Object)$this$bitFlagSwitch, (String)"$this$bitFlagSwitch");
                $this$bitFlagSwitch.whenSet(16, (Function0<Unit>)((Function0)() -> addListener.1.serialEvent$lambda$0$0($listener, $event)));
                $this$bitFlagSwitch.whenSet(262144, (Function0<Unit>)((Function0)() -> addListener.1.serialEvent$lambda$0$1($listener, this$0)));
                $this$bitFlagSwitch.whenSet(524288, (Function0<Unit>)((Function0)() -> addListener.1.serialEvent$lambda$0$2($listener, this$0)));
                $this$bitFlagSwitch.whenSet(0x10000000, (Function0<Unit>)((Function0)() -> addListener.1.serialEvent$lambda$0$3(this$0)));
                return Unit.INSTANCE;
            }

            private static final Unit serialEvent$lambda$0$0(SerialPort.SerialPortListener $listener, SerialPortEvent $event) {
                byte[] byArray = $event.getReceivedData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getReceivedData(...)");
                $listener.onDataReceived(byArray);
                return Unit.INSTANCE;
            }

            private static final Unit serialEvent$lambda$0$1(SerialPort.SerialPortListener $listener, JSerialCommPort this$0) {
                $listener.onCTSChanged(JSerialCommPort.access$getSerialPort$p(this$0).getCTS());
                return Unit.INSTANCE;
            }

            private static final Unit serialEvent$lambda$0$2(SerialPort.SerialPortListener $listener, JSerialCommPort this$0) {
                $listener.onDSRChanged(JSerialCommPort.access$getSerialPort$p(this$0).getDSR());
                return Unit.INSTANCE;
            }

            private static final Unit serialEvent$lambda$0$3(JSerialCommPort this$0) {
                JSerialCommPort.access$getSerialPort$p(this$0).closePort();
                return Unit.INSTANCE;
            }
        });
    }

    private final boolean setRTS(com.fazecast.jSerialComm.SerialPort $this$setRTS, boolean value) {
        boolean bl;
        boolean bl2 = value;
        if (bl2) {
            bl = $this$setRTS.setRTS();
        } else if (!bl2) {
            bl = $this$setRTS.clearRTS();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean setDTR(com.fazecast.jSerialComm.SerialPort $this$setDTR, boolean value) {
        boolean bl;
        boolean bl2 = value;
        if (bl2) {
            bl = $this$setDTR.setDTR();
        } else if (!bl2) {
            bl = $this$setDTR.clearDTR();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final void checkSuccess(boolean success, Function0<String> lazyMessage) throws SerialPortException {
        if (!success) {
            String message = (String)lazyMessage.invoke();
            throw new SerialPortException(message);
        }
    }

    private static final String connect$lambda$0() {
        String string = SerialMonitorBundle.message("serial.port.rts.init.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String connect$lambda$1() {
        String string = SerialMonitorBundle.message("serial.port.dtr.init.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String connect$lambda$3$0() {
        String string = SerialMonitorBundle.message("serial.port.parameters.wrong", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String connect$lambda$4() {
        String string = SerialMonitorBundle.message("serial.port.open.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String disconnect$lambda$0(JSerialCommPort this$0) {
        Object[] objectArray = new Object[]{this$0.serialPort.getSystemPortName()};
        String string = SerialMonitorBundle.message("port.close.error", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String setRTS$lambda$0() {
        String string = SerialMonitorBundle.message("serial.port.rts.update.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final String setDTR$lambda$0() {
        String string = SerialMonitorBundle.message("serial.port.dtr.update.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public /* synthetic */ JSerialCommPort(com.fazecast.jSerialComm.SerialPort port, DefaultConstructorMarker $constructor_marker) {
        this(port);
    }

    public static final /* synthetic */ com.fazecast.jSerialComm.SerialPort access$getSerialPort$p(JSerialCommPort $this) {
        return $this.serialPort;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/plugins/serialmonitor/service/JSerialCommPort$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/plugins/serialmonitor/service/JSerialCommPort;", "systemPortName", "", "intellij.serial.monitor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSerialCommPort create(@NotNull String systemPortName) throws SerialMonitorException {
            Intrinsics.checkNotNullParameter((Object)systemPortName, (String)"systemPortName");
            try {
                com.fazecast.jSerialComm.SerialPort serialPort = com.fazecast.jSerialComm.SerialPort.getCommPort((String)systemPortName);
                Intrinsics.checkNotNullExpressionValue((Object)serialPort, (String)"getCommPort(...)");
                return new JSerialCommPort(serialPort, null);
            }
            catch (SerialPortInvalidPortException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new SerialPortException(string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Parity.values().length];
            try {
                nArray[Parity.EVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Parity.ODD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StopBits.values().length];
            try {
                nArray[StopBits.BITS_2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StopBits.BITS_1_5.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

