/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.radler.testing;

import com.intellij.clion.radler.core.protocol.RadCacheState;
import com.intellij.clion.radler.core.util.RdCallUtilKt;
import com.intellij.clion.radler.testing.RadTestElement;
import com.intellij.clion.radler.testing.RadTestLanguageSupportKt;
import com.intellij.clion.radler.testing.RadTestPsiElement;
import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestNoIndexSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.cpp.fileType.psi.CppFile;
import com.jetbrains.rider.model.RadFindTestParams;
import com.jetbrains.rider.model.RadTestElementModel;
import com.jetbrains.rider.model.RadTestFramework;
import com.jetbrains.rider.model.RadTestLocation;
import com.jetbrains.rider.model.RadUnitTestsModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0004J6\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0#0\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0#0\"0%H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010*\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\r\u0010+\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b,2\r\u0010\u001f\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b,H\u0016J \u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010/\u001a\u0004\u0018\u00010\u0005H\u0016J\u001f\u00100\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001012\b\u0010+\u001a\u0004\u0018\u00010\u0005H$\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00104\u001a\u000205H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/clion/radler/testing/RadTestLanguageSupport;", "Lcom/jetbrains/cidr/execution/testing/CidrTestLanguageSupport;", "framework", "Lcom/jetbrains/rider/model/RadTestFramework;", "separator", "", "<init>", "(Lcom/jetbrains/rider/model/RadTestFramework;Ljava/lang/String;)V", "getFramework", "()Lcom/jetbrains/rider/model/RadTestFramework;", "getSeparator", "()Ljava/lang/String;", "myProtocolPrefix", "getProtocolPrefix", "getPatternSeparatorInCommandLine", "getProjectSourcesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "findTestObject", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "element", "Lcom/intellij/psi/PsiElement;", "createAllFileTests", "getElementsInFile", "", "createTestElement", "test", "Lcom/jetbrains/rider/model/RadTestElementModel;", "getLocationSafe", "", "Lcom/intellij/execution/Location;", "findLocationsInScope", "Lcom/intellij/openapi/util/Computable;", "isIndexing", "areSymbolsLoaded", "getLocationCacheModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "hasTestElement", "suite", "Lorg/jetbrains/annotations/NonNls;", "collectTestsInSuite", "", "suitePath", "toSuiteArray", "", "(Ljava/lang/String;)[Ljava/lang/String;", "findTests", "params", "Lcom/jetbrains/rider/model/RadFindTestParams;", "intellij.clion.radler.testing"})
@SourceDebugExtension(value={"SMAP\nRadTestLanguageSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadTestLanguageSupport.kt\ncom/intellij/clion/radler/testing/RadTestLanguageSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1617#2,9:184\n1869#2:193\n1870#2:195\n1626#2:196\n1#3:194\n*S KotlinDebug\n*F\n+ 1 RadTestLanguageSupport.kt\ncom/intellij/clion/radler/testing/RadTestLanguageSupport\n*L\n169#1:184,9\n169#1:193\n169#1:195\n169#1:196\n169#1:194\n*E\n"})
public abstract class RadTestLanguageSupport
implements CidrTestLanguageSupport {
    @NotNull
    private final RadTestFramework framework;
    @NotNull
    private final String separator;
    @NotNull
    private final String myProtocolPrefix;

    public RadTestLanguageSupport(@NotNull RadTestFramework framework, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        this.framework = framework;
        this.separator = separator;
        this.myProtocolPrefix = RadTestLanguageSupportKt.toURLSchema(this.framework) + "://";
    }

    @NotNull
    public final RadTestFramework getFramework() {
        return this.framework;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public String getProtocolPrefix() {
        return this.myProtocolPrefix;
    }

    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return this.separator;
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return globalSearchScope;
    }

    public boolean isAvailable(@Nullable PsiFile file) {
        return CidrTestNoIndexSupport.findCachedTestObject((PsiElement)((PsiElement)file), (String)this.myProtocolPrefix) != null || file != null && file instanceof CppFile && !this.getElementsInFile(file).isEmpty();
    }

    @Nullable
    public CidrTestScopeElement findTestObject(@Nullable PsiElement element) {
        CidrTestScopeElement findCachedTestObject = CidrTestNoIndexSupport.findCachedTestObject((PsiElement)element, (String)this.myProtocolPrefix);
        if (findCachedTestObject != null) {
            return findCachedTestObject;
        }
        if (element instanceof PsiFile) {
            return this.createAllFileTests((PsiFile)element);
        }
        if (!(element instanceof RadTestPsiElement) || ((RadTestPsiElement)element).getTest().getFramework() != this.framework) {
            return null;
        }
        return new RadTestElement((RadTestPsiElement)element);
    }

    @NotNull
    protected CidrTestScopeElement createAllFileTests(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CidrTestScopeElement cidrTestScopeElement = CidrTestScopeElementImpl.createTestScopeElementForFile((PsiFile)file, () -> RadTestLanguageSupport.createAllFileTests$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)cidrTestScopeElement, (String)"createTestScopeElementForFile(...)");
        return cidrTestScopeElement;
    }

    @NotNull
    public Collection<CidrTestScopeElement> getElementsInFile(@NotNull PsiFile file) {
        List list;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)virtualFile, (Project)project2));
        if (projectModelEntity == null || (n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)project2)) == null) {
            return CollectionsKt.emptyList();
        }
        int fileId = n;
        RadFindTestParams params = new RadFindTestParams(this.framework, Integer.valueOf(fileId), null, null, false, false, 60, null);
        List<RadTestElementModel> elements = this.findTests(project2, params);
        List $this$getElementsInFile_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (RadTestElementModel e : elements) {
            List list2 = e.getLocations();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (RadTestLocation l : list2) {
                if (l.getFile() != fileId) continue;
                $this$getElementsInFile_u24lambda_u240.add(new RadTestElement(new RadTestPsiElement(file, e, RangeUtilKt.toIdeaRange((RdTextRange)l.getRange()))));
            }
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    protected final Collection<CidrTestScopeElement> createTestElement(@NotNull Project project, @NotNull RadTestElementModel test) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psi = psiManager;
        WorkspaceModel pm = WorkspaceModel.Companion.getInstance(project);
        List $this$createTestElement_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List list2 = test.getLocations();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (RadTestLocation l : list2) {
            PsiFile file;
            VirtualFileUrl virtualFile;
            ProjectModelEntity projectModelEntity;
            if (WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)pm, (int)l.getFile()) == null) continue;
            VirtualFileUrl virtualFileUrl = projectModelEntity.getUrl();
            if (virtualFileUrl == null) continue;
            if ((virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null || psi.findFile((VirtualFile)(virtualFile = virtualFileUrl)) == null) continue;
            $this$createTestElement_u24lambda_u240.add(new RadTestElement(new RadTestPsiElement(file, test, RangeUtilKt.toIdeaRange((RdTextRange)l.getRange()))));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public List<Location<PsiElement>> getLocationSafe(@NotNull Project project, @NotNull Computable<List<Location<PsiElement>>> findLocationsInScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(findLocationsInScope, (String)"findLocationsInScope");
        Object object = findLocationsInScope.compute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    public boolean isIndexing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RadCacheState cache = RadCacheState.Companion.getInstance(project);
        return !cache.isIdle();
    }

    public boolean areSymbolsLoaded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RadCacheState cache = RadCacheState.Companion.getInstance(project);
        return cache.isInitialUpdateFinished() && cache.isIdle();
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IOptProperty modificationCount = RadUnitTestsModel_PregeneratedKt.getRadUnitTestsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getModificationCount();
        return () -> RadTestLanguageSupport.getLocationCacheModificationTracker$lambda$0(modificationCount);
    }

    public boolean hasTestElement(@NotNull Project project, @Nullable String suite, @Nullable String test) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (suite == null && test == null) {
            return false;
        }
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)SolutionHostExtensionsKt.getSolution((Project)project).isLoaded()))) {
            return false;
        }
        String[] suiteArray = this.toSuiteArray(suite);
        RadFindTestParams params = new RadFindTestParams(this.framework, null, suiteArray, test, false, false, 50, null);
        return !((Collection)this.findTests(project, params)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> collectTestsInSuite(@NotNull Project project, @Nullable String suitePath) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (suitePath == null || !BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)SolutionHostExtensionsKt.getSolution((Project)project).isLoaded()))) {
            return SetsKt.emptySet();
        }
        RadTestFramework radTestFramework = this.framework;
        String[] stringArray = this.toSuiteArray(suitePath);
        List testEntities = (List)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)RadUnitTestsModel_PregeneratedKt.getRadUnitTestsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getFindTests()), (Object)new RadFindTestParams(radTestFramework, null, stringArray, null, false, true, 10, null), (long)0L, (int)2, null);
        Iterable $this$mapNotNull$iv = testEntities;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RadTestElementModel it = (RadTestElementModel)element$iv$iv;
            boolean bl2 = false;
            if (it.getTest() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    protected abstract String[] toSuiteArray(@Nullable String var1);

    @NotNull
    protected final List<RadTestElementModel> findTests(@NotNull Project project, @NotNull RadFindTestParams params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return (List)RdCallUtilKt.callSomehow((RdCall)RadUnitTestsModel_PregeneratedKt.getRadUnitTestsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getFindTests(), (Object)params, (IProtocol)ApplicationProtocolKt.getProtocol((Project)project));
    }

    private static final String createAllFileTests$lambda$0(PsiFile $file) {
        return "all-tests(" + $file.getVirtualFile().getUrl() + ")";
    }

    private static final long getLocationCacheModificationTracker$lambda$0(IOptProperty $modificationCount) {
        return ((Number)InterfacesKt.valueOrDefault((IOptProperty)$modificationCount, (Object)0L)).longValue();
    }
}

