/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.annotation.Nullable;

final class WebsocketClientOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketClientHandshaker handshaker;
    final Sinks.One<WebSocketCloseStatus> onCloseState;
    final boolean proxyPing;
    volatile int closeSent;
    static final String INBOUND_CANCEL_LOG = "WebSocket client inbound receiver cancelled, closing Websocket.";
    static final AtomicIntegerFieldUpdater<WebsocketClientOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketClientOperations.class, "closeSent");

    WebsocketClientOperations(URI currentURI, WebsocketClientSpec websocketClientSpec, HttpClientOperations replaced) {
        super(replaced);
        this.proxyPing = websocketClientSpec.handlePing();
        Channel channel = this.channel();
        this.onCloseState = Sinks.unsafe().one();
        String subprotocols = websocketClientSpec.protocols();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)currentURI, (WebSocketVersion)websocketClientSpec.version(), (String)(subprotocols != null && !subprotocols.isEmpty() ? subprotocols : null), (boolean)true, (HttpHeaders)replaced.requestHeaders().remove((CharSequence)HttpHeaderNames.HOST), (int)websocketClientSpec.maxFramePayloadLength());
        this.handshaker.handshake(channel).addListener(f -> {
            this.markPersistent(false);
            channel.read();
        });
    }

    @Override
    public HttpHeaders headers() {
        return this.responseHeaders();
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    @Nullable
    public String selectedSubprotocol() {
        return this.handshaker.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse((HttpResponse)response);
            if (this.notRedirected((HttpResponse)response)) {
                try {
                    this.handshaker.finishHandshake(this.channel(), response);
                    ctx.read();
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ctx.close();
                }
                finally {
                    response.content().release();
                }
            } else {
                response.content().release();
                this.listener().onUncaughtException(this, this.redirecting);
            }
            return;
        }
        if (!this.proxyPing && msg instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            CloseWebSocketFrame closeFrame;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            if ((closeFrame = new CloseWebSocketFrame(true, ((CloseWebSocketFrame)msg).rsv(), ((CloseWebSocketFrame)msg).content())).statusCode() != -1) {
                this.sendCloseNow(closeFrame);
            } else {
                this.sendCloseNow(closeFrame, WebSocketCloseStatus.EMPTY);
            }
            this.onInboundComplete();
        } else if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), INBOUND_CANCEL_LOG));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE);
    }

    @Override
    protected void onInboundClose() {
        if (this.handshaker.isHandshakeComplete()) {
            this.terminate();
        } else {
            this.onInboundError((Throwable)new WebSocketClientHandshakeException("Connection prematurely closed BEFORE opening handshake is complete."));
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.PROTOCOL_ERROR));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.asMono().or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame) {
        this.sendCloseNow(frame, new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
    }

    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            frame.release();
        }
    }
}

