/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.stm32cubemx;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.ProjectData;
import com.intellij.clion.embedded.execution.OpenOcdConfiguration;
import com.intellij.clion.embedded.execution.ui.EmbeddedMessages;
import com.intellij.clion.embedded.execution.ui.SelectBoardDialog;
import com.intellij.clion.embedded.stm32cubemx.CubeMXManager;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.ExecutableData;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter2.AbstractFilter;
import org.jdom.filter2.Filter;
import org.jdom.xpath.XPathExpression;
import org.jdom.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConvertProjectAction
extends CMakeProjectAction {
    static final String CPROJECT_FILE_NAME = ".cproject";
    private static final String CONFIG_DEBUG_XPATH = ".//configuration[@artifactExtension='elf' and @name='Debug']";
    private static final String PROJECT_FILE_NAME = ".project";
    private static final String CMAKE_LISTS_TEMPLATE_FILE_NAME = "CMakeLists_template.txt";
    private static final Filter<Attribute> ATTRIBUTES_ONLY = new AbstractFilter<Attribute>(){

        public Attribute filter(Object content2) {
            return content2 instanceof Attribute ? (Attribute)content2 : null;
        }
    };
    private static final XPathExpression<Attribute> INCLUDES_XPATH_SW4STM32 = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='gnu.c.compiler.option.include.paths']/listOptionValue/@value", ATTRIBUTES_ONLY);
    private static final XPathExpression<Attribute> DEFINES_XPATH_SW4STM32;
    private static final XPathExpression<Attribute> INCLUDES_XPATH_CUBEIDE;
    private static final XPathExpression<Attribute> DEFINES_XPATH_CUBEIDE;
    private static final XPathExpression<Attribute> SOURCE_XPATH;
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UPDATE_FAILED = "UPDATE_FAILED";
    public static final String CMAKE_LISTS_TEMPLATE_NAME = "tmpl_CMakeLists.txt";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertProjectAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible()) {
            if ("MainMenu".equals(e.getPlace())) {
                presentation.setEnabledAndVisible(ConvertProjectAction.checkProjectUpdateability(e.getProject()));
            } else {
                boolean visible = false;
                VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                if (file != null) {
                    String fileName = file.getName();
                    if (FileUtilRt.extensionEquals((String)fileName, (String)"ioc")) {
                        visible = ConvertProjectAction.checkProjectConvertibility(e.getProject());
                    } else if ("CMakeLists.txt".equals(fileName) || CMAKE_LISTS_TEMPLATE_FILE_NAME.equals(fileName)) {
                        visible = ConvertProjectAction.checkProjectUpdateability(e.getProject());
                    }
                }
                presentation.setEnabledAndVisible(visible);
            }
        }
    }

    private static @Nullable CubeMXManager.CubeStatus getProjectCubeMxStatus(@Nullable Project project) {
        CubeMXManager cubeMXManager = project == null ? null : (CubeMXManager)project.getService(CubeMXManager.class);
        CubeMXManager.CubeStatus status = cubeMXManager != null ? cubeMXManager.getStatus() : null;
        return status;
    }

    private static boolean checkProjectUpdateability(@Nullable Project project) {
        CubeMXManager.CubeStatus status = ConvertProjectAction.getProjectCubeMxStatus(project);
        return status == CubeMXManager.CubeStatus.OK || status == CubeMXManager.CubeStatus.OUTDATED;
    }

    private static boolean checkProjectConvertibility(@Nullable Project project) {
        CubeMXManager.CubeStatus status = ConvertProjectAction.getProjectCubeMxStatus(project);
        return status != null && status != CubeMXManager.CubeStatus.NOT_CONVERTIBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProject(@Nullable Project project, boolean automatic) {
        if (project == null) {
            return;
        }
        String detectedMcuFamily = UPDATE_FAILED;
        try {
            String board;
            FileDocumentManager.getInstance().saveAllDocuments();
            StoreUtil.saveSettings((ComponentManager)project);
            ProjectData projectData = ConvertProjectAction.loadProjectData(project);
            if (projectData == null) {
                return;
            }
            String runConfigName = "OCD " + projectData.getProjectName();
            RunManager runManager = RunManager.getInstance((Project)project);
            if (runManager.findConfigurationByTypeAndName("com.jetbrains.cidr.embedded.openocd.conf.type", runConfigName) == null) {
                board = SelectBoardDialog.selectBoardByPriority(project, true, projectData.getBoard(), projectData.getMcuFamily());
            } else {
                board = null;
                runConfigName = null;
            }
            VirtualFile projectDir = ConvertProjectAction.getProjectDir(project);
            if (projectDir == null) {
                return;
            }
            ConvertProjectAction.scheduleModifyCMakeConfigs(project, runConfigName, board);
            ApplicationManager.getApplication().runWriteAction(() -> ConvertProjectAction.writeProject(projectData, projectDir));
            CMakeWorkspace cMakeWorkspace = CMakeWorkspace.getInstance((Project)project);
            if (cMakeWorkspace.getCMakeDependencyFiles().isEmpty()) {
                cMakeWorkspace.linkCMakeProjectAsync(VfsUtilCore.virtualToIoFile((VirtualFile)projectDir));
            }
            cMakeWorkspace.scheduleReload(CMakeWorkspaceReloadTask.clearCache());
            detectedMcuFamily = Objects.toString(projectData.getMcuFamily(), UNKNOWN);
            @NlsSafe String message = EmbeddedBundle.message("mcu.chip.detected", detectedMcuFamily, StringUtil.capitalize((String)projectData.getMcpu()));
            EmbeddedMessages.showSuccessMessage(project, EmbeddedBundle.message("cube.mx.project.updated", new Object[0]), message);
        }
        finally {
            EmbeddedUsagesCollector.triggerStm32CubeMXParse(project, detectedMcuFamily, automatic);
        }
    }

    @Nullable
    public static VirtualFile getProjectDir(@NotNull Project project) {
        CMakeWorkspace cMakeWorkspace;
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(1);
        }
        if ((cMakeWorkspace = CMakeWorkspace.getInstance((Project)project)).isInitialized()) {
            Path modelProjectDir = cMakeWorkspace.getProjectPath();
            return VfsUtil.findFile((Path)modelProjectDir, (boolean)false);
        }
        return ProjectUtil.guessProjectDir((Project)project);
    }

    public static void scheduleModifyCMakeConfigs(final @NotNull Project project, final @Nullable String runConfigName, final @Nullable String openOcdBoardConfigFile) {
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(2);
        }
        final MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            public void reloadingFinished(boolean canceled) {
                busConnection.disconnect();
                if (!canceled) {
                    RunManager runManager = RunManager.getInstance((Project)project);
                    ConfigurationFactory factory = ConfigurationTypeUtil.findConfigurationType((String)"com.jetbrains.cidr.embedded.openocd.conf.type").getConfigurationFactories()[0];
                    if (runConfigName != null && openOcdBoardConfigFile != null) {
                        RunnerAndConfigurationSettings newRunConfig = runManager.createConfiguration(runConfigName, factory);
                        newRunConfig.storeInDotIdeaFolder();
                        OpenOcdConfiguration configuration = (OpenOcdConfiguration)newRunConfig.getConfiguration();
                        configuration.setAllowRunningInParallel(false);
                        CMakeBuildConfigurationHelper helper = CMakeRunConfigurationType.getHelper((Project)project);
                        CMakeTarget target = (CMakeTarget)helper.getDefaultTarget();
                        if (target != null && !target.isExecutable()) {
                            target = (CMakeTarget)ContainerUtil.find((Iterable)helper.getTargets(), CMakeTarget::isExecutable);
                        }
                        if (target != null) {
                            BuildTargetData buildTargetData = new BuildTargetData(project.getName(), target.getName());
                            BuildTargetAndConfigurationData data = new BuildTargetAndConfigurationData(buildTargetData, null);
                            configuration.setTargetAndConfigurationData(data);
                            configuration.setExecutableData(new ExecutableData(buildTargetData));
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!project.isDisposed()) {
                                configuration.setBoardConfigFile(openOcdBoardConfigFile);
                                ApplicationManager.getApplication().runWriteAction(() -> {
                                    runManager.addConfiguration(newRunConfig);
                                    runManager.makeStable(newRunConfig);
                                    runManager.setSelectedConfiguration(newRunConfig);
                                });
                            }
                        });
                    }
                }
            }
        });
    }

    public static void writeProject(@NotNull ProjectData projectData, @NotNull VirtualFile projectDir) {
        if (projectData == null) {
            ConvertProjectAction.$$$reportNull$$$0(3);
        }
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(4);
        }
        String fileName = CMAKE_LISTS_TEMPLATE_FILE_NAME;
        try {
            String templateText;
            VirtualFile cmakeTemplate = projectDir.findOrCreateChildData((Object)ApplicationManager.getApplication(), fileName);
            if (cmakeTemplate.getLength() <= 0L) {
                templateText = ConvertProjectAction.loadCmakeTemplateFromResources();
                VfsUtil.saveText((VirtualFile)cmakeTemplate, (String)templateText);
            } else {
                templateText = VfsUtilCore.loadText((VirtualFile)cmakeTemplate);
            }
            ConvertProjectAction.writeProjectFile(projectDir, templateText, "CMakeLists.txt", projectData);
        }
        catch (IOException e) {
            Application application = ApplicationManager.getApplication();
            application.invokeLater(() -> Messages.showErrorDialog((Component)WindowManager.getInstance().findVisibleFrame(), (String)(fileName + ":\n " + e.getLocalizedMessage()), (String)EmbeddedBundle.message("cube.mx.file.write.error", new Object[0])));
        }
    }

    @Nullable
    public static ProjectData loadProjectData(@NotNull Project project) {
        VirtualFile projectDir;
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(5);
        }
        if ((projectDir = ConvertProjectAction.getProjectDir(project)) != null) {
            return ConvertProjectAction.loadProjectData(projectDir);
        }
        return null;
    }

    @Nullable
    public static ProjectData loadProjectData(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(6);
        }
        try {
            VirtualFile iocFile2 = CubeMXManager.findIocFile(projectDir, false);
            if (iocFile2 == null) {
                return null;
            }
            ProjectData projectData = new ProjectData();
            Properties properties = CubeMXManager.loadPropertiesFile(iocFile2).get();
            boolean sw4stm32 = "SW4STM32".equalsIgnoreCase(properties.getProperty("ProjectManager.TargetToolchain"));
            Element cProject = ConvertProjectAction.detectAndLoadFile(projectDir, CPROJECT_FILE_NAME);
            if (cProject == null) {
                return null;
            }
            Element dotProject = ConvertProjectAction.detectAndLoadFile(projectDir, PROJECT_FILE_NAME);
            if (dotProject == null) {
                return null;
            }
            Context context = new Context(cProject);
            projectData.setProjectName(dotProject.getChild("name").getText());
            if (sw4stm32) {
                ConvertProjectAction.loadSw4Stm32(context, projectData);
            } else {
                ConvertProjectAction.loadCubeIde(context, projectData);
            }
            projectData.setSources(ConvertProjectAction.loadSources(context));
            CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
            String cMakeMinimumRequiredLine = CLionProjectWizardUtils.getCMakeMinimumRequiredLine((String)CLionProjectWizardUtils.getCMakeVersionUnderProgress((CPPToolchains.Toolchain)toolchain));
            projectData.setCmakeRequiredVersion(cMakeMinimumRequiredLine);
            return projectData;
        }
        catch (Throwable e) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("message.read.error", e.getClass().getName(), e.getLocalizedMessage()), (String)CMakeBundle.message((String)"cmake.project.update.action.error", (Object[])new Object[0]));
            Logger.getInstance(ConvertProjectAction.class).error(e);
            return null;
        }
    }

    private static void loadSw4Stm32(Context context, ProjectData projectData) {
        String linkerScript = ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.tool.gnu.cross.c.linker.script");
        projectData.setLinkerScript(linkerScript.replace("../", ""));
        projectData.setMcuFamily(ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.option.gnu.cross.mcu"));
        projectData.setLinkerFlags(ConvertProjectAction.fetchValueBySuperClass(context, "gnu.c.link.option.ldflags"));
        projectData.setBoard(ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.option.gnu.cross.board"));
        projectData.setDefines(ConvertProjectAction.loadDefines(context, DEFINES_XPATH_SW4STM32));
        projectData.setIncludes(ConvertProjectAction.loadIncludes(context, INCLUDES_XPATH_SW4STM32));
    }

    private static void loadCubeIde(Context context, ProjectData projectData) {
        String linkerScript = ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.linker.option.script");
        linkerScript = linkerScript.replace("${workspace_loc:/${ProjName}/", "").replace("}", "");
        projectData.setLinkerScript(linkerScript);
        projectData.setMcuFamily(ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.option.target_mcu"));
        projectData.setLinkerFlags("");
        projectData.setBoard(ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.option.target_board"));
        projectData.setDefines(ConvertProjectAction.loadDefines(context, DEFINES_XPATH_CUBEIDE));
        projectData.setIncludes(ConvertProjectAction.loadIncludes(context, INCLUDES_XPATH_CUBEIDE));
    }

    @NotNull
    private static String loadCmakeTemplateFromResources() throws IOException {
        String string = FileUtil.loadTextAndClose((InputStream)Objects.requireNonNull(ConvertProjectAction.class.getResourceAsStream(CMAKE_LISTS_TEMPLATE_NAME)));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void writeProjectFile(@Nullable VirtualFile projectDir, @NotNull String template, @NotNull String fileName, @NotNull ProjectData projectData) throws IOException {
        if (template == null) {
            ConvertProjectAction.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            ConvertProjectAction.$$$reportNull$$$0(9);
        }
        if (projectData == null) {
            ConvertProjectAction.$$$reportNull$$$0(10);
        }
        if (projectDir == null) {
            return;
        }
        VirtualFile projectFile = projectDir.findChild(fileName);
        if (projectFile == null) {
            projectFile = projectDir.createChildData(null, fileName);
        }
        String text = new StringSubstitutor(projectData.getAsMap()).replace(template);
        VfsUtil.saveText((VirtualFile)projectFile, (String)text);
    }

    @NotNull
    private static String loadIncludes(@NotNull Context context, XPathExpression<Attribute> xPathExpression) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(11);
        }
        List list = xPathExpression.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> s.replace("../", "")).collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String loadSources(@NotNull Context context) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(13);
        }
        List list = SOURCE_XPATH.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> "\"" + s + "/*.*\"").collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String loadDefines(@NotNull Context context, XPathExpression<Attribute> xPathExpression) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(15);
        }
        List list = xPathExpression.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> "-D" + s.replace("(", "\\(").replace(")", "\\)").replace("//", "////")).collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String fetchValueBySuperClass(@NotNull Context context, @NotNull String key) {
        XPathExpression xPath;
        Attribute attribute;
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(17);
        }
        if (key == null) {
            ConvertProjectAction.$$$reportNull$$$0(18);
        }
        String string = (attribute = (Attribute)(xPath = XPathFactory.instance().compile(".//*[@superClass='" + key + "']/@value", ATTRIBUTES_ONLY)).evaluateFirst((Object)context.cProjectElement)) == null ? "" : attribute.getValue();
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    private static Element detectAndLoadFile(@NotNull VirtualFile projectDir, @NotNull String fileName) {
        VirtualFile child;
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(20);
        }
        if (fileName == null) {
            ConvertProjectAction.$$$reportNull$$$0(21);
        }
        if ((child = projectDir.findChild(fileName)) == null || !child.exists() || child.isDirectory()) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("cube.mx.file.not.found.description", fileName, projectDir.getPath()), (String)EmbeddedBundle.message("cube.mx.file.not.found", new Object[0]));
            return null;
        }
        try {
            return JDOMUtil.load((InputStream)child.getInputStream());
        }
        catch (IOException | JDOMException e) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("cube.mx.file.read.error.description", fileName, projectDir.getPath(), e.getLocalizedMessage()), (String)EmbeddedBundle.message("cube.mx.file.read.error", new Object[0]));
            return null;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ConvertProjectAction.$$$reportNull$$$0(22);
        }
        Project project = ConvertProjectAction.getEventProject((AnActionEvent)event);
        ConvertProjectAction.updateProject(project, false);
    }

    static {
        INCLUDES_XPATH_CUBEIDE = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.compiler.option.includepaths']/listOptionValue/@value", ATTRIBUTES_ONLY);
        DEFINES_XPATH_SW4STM32 = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='gnu.c.compiler.option.preprocessor.def.symbols']/listOptionValue/@value", ATTRIBUTES_ONLY);
        DEFINES_XPATH_CUBEIDE = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.compiler.option.definedsymbols']/listOptionValue/@value", ATTRIBUTES_ONLY);
        SOURCE_XPATH = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//sourceEntries/entry/@name", ATTRIBUTES_ONLY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 14, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/stm32cubemx/ConvertProjectAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/stm32cubemx/ConvertProjectAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCmakeTemplateFromResources";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadIncludes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSources";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefines";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchValueBySuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDir";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleModifyCMakeConfigs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectData";
                break;
            }
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeProjectFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadIncludes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadSources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadDefines";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fetchValueBySuperClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detectAndLoadFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 14, 16, 19 -> new IllegalStateException(string);
        };
    }

    private static class Context {
        private final Element cProjectElement;

        Context(@NotNull Element cProjectElement) {
            if (cProjectElement == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.cProjectElement = cProjectElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cProjectElement", "com/intellij/clion/embedded/stm32cubemx/ConvertProjectAction$Context", "<init>"));
        }
    }
}

