/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.iar;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class IarMessagesConsoleFilter
implements Filter {
    private static final Pattern ourErrorPattern = Pattern.compile("^(?<skip>\\s*)(?:\"(?<filename>.*)\",(?<line>\\d+)\\s+)?(?<severity>Remark|Warning|Error|Fatal error)\\[(?<tag>\\w+)]:(?<message>.*)\\s*");
    private static final Pattern ourColumnPattern = Pattern.compile("^(\\s*)\\^\\s*$");
    private static final Pattern ourNestedErrorPattern = Pattern.compile("\\(declared\\s+at\\s+line\\s+(?<line>\\d+)\\s+of\\s+\"(?<filename>.+)\"\\)", 8);
    @NotNull
    private final EditorColorsScheme myColorsScheme;
    protected final Project myProject;
    private int myLastErrorColumnPosition;
    private int myLastTextStart;
    private int myLastSkipSpaces;
    private final StringBuilder myAccumulatedErrorMessage;
    private TextAttributes myLastSeverityAttributes;

    @VisibleForTesting
    public IarMessagesConsoleFilter(@NotNull Project project, @NotNull EditorColorsScheme colorsScheme) {
        if (project == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(0);
        }
        if (colorsScheme == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(1);
        }
        this.myLastErrorColumnPosition = -1;
        this.myLastTextStart = 0;
        this.myLastSkipSpaces = 0;
        this.myAccumulatedErrorMessage = new StringBuilder();
        this.myLastSeverityAttributes = null;
        this.myProject = project;
        this.myColorsScheme = colorsScheme;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String logLine, int entireLength) {
        if (logLine == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(2);
        }
        Matcher columnMatcher = ourColumnPattern.matcher(logLine);
        int baseLength = entireLength - logLine.length();
        if (columnMatcher.matches()) {
            String position = columnMatcher.group(1);
            this.myLastErrorColumnPosition = position != null ? position.length() - 2 : -1;
            return null;
        }
        Matcher errorMatcher = ourErrorPattern.matcher(logLine);
        if (errorMatcher.matches()) {
            this.myLastSkipSpaces = Math.max(0, errorMatcher.end("skip"));
            String filename = errorMatcher.group("filename");
            int line = Integer.parseInt(Objects.toString(errorMatcher.group("line"), "0")) - 1;
            String severity = Objects.toString(errorMatcher.group("severity"), "");
            this.myLastSeverityAttributes = this.severityTextAttribute(severity);
            Filter.Result result = new Filter.Result(this.myLastTextStart, entireLength, null, this.myLastSeverityAttributes);
            this.myLastTextStart = entireLength;
            if (filename != null) {
                FileHyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(filename, line, this.myLastErrorColumnPosition - this.myLastSkipSpaces);
                Filter.Result gotoFileResult = new Filter.Result(baseLength + errorMatcher.start("filename") - 1, baseLength + errorMatcher.end("line"), (HyperlinkInfo)hyperlinkInfo);
                this.myLastErrorColumnPosition = -1;
                this.myAccumulatedErrorMessage.setLength(0);
                SmartList results = new SmartList((Object[])new Filter.Result[]{result, gotoFileResult});
                Filter.Result nestedError = this.findNestedError(logLine, entireLength);
                if (nestedError != null) {
                    results.add((Object)nestedError);
                }
                return new Filter.Result((List)results);
            }
            return result;
        }
        this.myLastTextStart = baseLength;
        if (this.myLastSeverityAttributes != null) {
            if (this.myLastSkipSpaces < logLine.length() && logLine.charAt(this.myLastSkipSpaces) == ' ') {
                Filter.Result wholeMessageResult = new Filter.Result(baseLength, entireLength, null, this.myLastSeverityAttributes);
                Filter.Result nestedResult = this.findNestedError(logLine, entireLength);
                return nestedResult == null ? wholeMessageResult : new Filter.Result(Arrays.asList(wholeMessageResult, nestedResult));
            }
            this.myLastSkipSpaces = 0;
            this.myLastSeverityAttributes = null;
            this.myAccumulatedErrorMessage.setLength(0);
        }
        return null;
    }

    private Filter.Result findNestedError(@NotNull String logLine, int entireLength) {
        if (logLine == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(3);
        }
        this.myAccumulatedErrorMessage.append(logLine);
        Matcher matcher = ourNestedErrorPattern.matcher(this.myAccumulatedErrorMessage);
        if (!matcher.find()) {
            return null;
        }
        String filename = matcher.group("filename");
        if (filename == null) {
            return null;
        }
        int line = Integer.parseInt(Objects.toString(matcher.group("line"), "0")) - 1;
        FileHyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(filename, line, -1);
        int start = entireLength - this.myAccumulatedErrorMessage.length() + matcher.start("filename");
        int end = entireLength - this.myAccumulatedErrorMessage.length() + matcher.end("filename");
        this.myAccumulatedErrorMessage.setLength(0);
        return new Filter.Result(Math.max(0, start), end, (HyperlinkInfo)hyperlinkInfo);
    }

    @NotNull
    protected FileHyperlinkInfo createHyperlinkInfo(String filename, int line, int column) {
        return new LazyFileHyperlinkInfo(this.myProject, filename, line, column);
    }

    private TextAttributes severityTextAttribute(String severity) {
        TextAttributesKey attributesKey = switch (severity) {
            case "Remark" -> ConsoleViewContentType.LOG_INFO_OUTPUT_KEY;
            case "Warning" -> ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY;
            default -> ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY;
        };
        return this.myColorsScheme.getAttributes(attributesKey);
    }

    public static void collectWarnings(@NotNull String stderr, @NotNull List<String> warnings) {
        if (stderr == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(4);
        }
        if (warnings == null) {
            IarMessagesConsoleFilter.$$$reportNull$$$0(5);
        }
        for (String s : StringUtil.splitByLinesDontTrim((String)stderr)) {
            Matcher matcher = ourErrorPattern.matcher(s);
            if (!matcher.matches() || !"Warning".equals(matcher.group("severity"))) continue;
            warnings.add(matcher.group());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/embedded/iar/IarMessagesConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNestedError";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectWarnings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

