/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.ResetStrategy;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/StUtilServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "generateConnectionString", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "port", "", "intellij.clion.embedded"})
public final class StUtilServer
extends GdbServer {
    public StUtilServer() {
        super(GdbServerType.STUTIL);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("stutil.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return SystemInfo.isWindows ? "st-util.exe" : "st-util";
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> StUtilServer.getDialogPanel$lambda$0(this, wizard, arg_0));
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String arguments = "-p " + port;
        String string = state.getFrequency();
        if ((string != null ? UStringsKt.toUIntOrNull((String)string) : null) != null) {
            arguments = arguments + " --freq=" + state.getFrequency() + "k";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[state.getResetStrategy().ordinal()]) {
            case 1: {
                arguments = arguments + " --no-reset";
                break;
            }
            case 2: {
                arguments = arguments + " --connect-under-reset";
            }
        }
        return arguments;
    }

    private static final Unit getDialogPanel$lambda$0(StUtilServer this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.st.util.gdb.server", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, StUtilServer::getDialogPanel$lambda$0$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        Object[] objectArray = new String[]{"AUTO", "5", "15", "25", "50", "100", "125", "240", "480", "950", "1200", "1800", "4000", "8000", "16000", "24000"};
        this$0.speedRow($this$panel, $wizard, "1800", (String[])objectArray);
        objectArray = new ResetStrategy[]{ResetStrategy.DEFAULT, ResetStrategy.ATTACH, ResetStrategy.UNDER_RESET};
        this$0.resetStrategyRow($this$panel, $wizard, (ResetStrategy[])objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetStrategy.values().length];
            try {
                nArray[ResetStrategy.ATTACH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetStrategy.UNDER_RESET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

