/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.DevicesTreeBuilder;
import com.intellij.clion.embedded.execution.wizard.DevicesTreeNode;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/JLinkServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "findDefaultLocation", "generateConnectionString", "port", "", "Companion", "intellij.clion.embedded"})
public final class JLinkServer
extends GdbServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEFAULT_SPEED = "8000";
    @NotNull
    private static final String DEFAULT_GDBSERVER_NAME = SystemInfo.isWindows ? "JLinkGDBServerCL.exe" : "JLinkGDBServerCLExe";
    @NotNull
    private static final String[] SPEEDS;

    public JLinkServer() {
        super(GdbServerType.JLINK);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("jlink.gdb.server.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return DEFAULT_GDBSERVER_NAME;
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> JLinkServer.getDialogPanel$lambda$0(this, wizard, arg_0));
    }

    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.gatherData(project, state);
        state.setDevicesTree(this.validateNonEmptyTree(Companion.readDevicesList()));
    }

    @Override
    @Nullable
    public String findDefaultLocation() {
        return Companion.findDefaultGdbserverLocation();
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String string = this.selectedDeviceKey(state);
        String string2 = state.getInterfaceType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return "-device \"" + string + "\" -if " + string3 + " -speed " + state.getFrequency() + " -port " + port + " -nogui -singlerun";
    }

    private static final Unit getDialogPanel$lambda$0(JLinkServer this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.jlink.gdb.server", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, JLinkServer::getDialogPanel$lambda$0$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        this$0.interfacesRow($this$panel, $wizard);
        String[] stringArray = SPEEDS;
        this$0.speedRow($this$panel, $wizard, DEFAULT_SPEED, Arrays.copyOf(stringArray, stringArray.length));
        this$0.devicesListRows($this$panel, $wizard);
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"AUTO", "ADAPTIVE", "400", "500", "600", "750", "900", "1000", "1333", "1600", "2000", "3200", "4000", "4800", "6000", DEFAULT_SPEED, "9600", "12000", "16000"};
        SPEEDS = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion;", "", "<init>", "()V", "DEFAULT_SPEED", "", "DEFAULT_GDBSERVER_NAME", "getDEFAULT_GDBSERVER_NAME", "()Ljava/lang/String;", "SPEEDS", "", "getSPEEDS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "readDevicesList", "Lcom/intellij/clion/embedded/execution/wizard/DevicesTreeNode;", "findDefaultGdbserverLocation", "intellij.clion.embedded"})
    @SourceDebugExtension(value={"SMAP\nJLinkServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n80#2:98\n216#3:99\n216#3:100\n216#3,2:101\n217#3:103\n217#3:104\n1617#4,9:105\n1869#4:114\n1870#4:116\n1626#4:117\n1563#4:118\n1634#4,3:119\n1374#4:122\n1460#4,5:123\n1563#4:128\n1634#4,3:129\n774#4:132\n865#4,2:133\n1#5:115\n*S KotlinDebug\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion\n*L\n62#1:98\n62#1:99\n63#1:100\n64#1:101,2\n63#1:103\n62#1:104\n81#1:105,9\n81#1:114\n81#1:116\n81#1:117\n82#1:118\n82#1:119,3\n86#1:122\n86#1:123,5\n87#1:128\n87#1:129,3\n88#1:132\n88#1:133,2\n81#1:115\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEFAULT_GDBSERVER_NAME() {
            return DEFAULT_GDBSERVER_NAME;
        }

        @NotNull
        public final String[] getSPEEDS() {
            return SPEEDS;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DevicesTreeNode readDevicesList() {
            void $this$decodeFromStream$iv;
            DevicesTreeBuilder builder = new DevicesTreeBuilder();
            InputStream inputStream = this.getClass().getResourceAsStream("segger-devices.json");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream deviceList = inputStream;
            Json json = (Json)Json.Default;
            InputStream stream$iv = deviceList;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            Map $this$forEach$iv = (Map)JsonElementKt.getJsonObject((JsonElement)((JsonElement)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)JsonElement.Companion.serializer()), (InputStream)stream$iv)));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String vendorName = (String)entry.getKey();
                JsonElement group = (JsonElement)entry.getValue();
                Map $this$forEach$iv2 = (Map)JsonElementKt.getJsonObject((JsonElement)group);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry2 = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    String groupName = (String)entry2.getKey();
                    JsonElement devices = (JsonElement)entry2.getValue();
                    Map $this$forEach$iv3 = (Map)JsonElementKt.getJsonObject((JsonElement)devices);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator3 = $this$forEach$iv3.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv3;
                        Map.Entry entry3 = element$iv3 = iterator3.next();
                        boolean bl3 = false;
                        String mcuKey = (String)entry3.getKey();
                        JsonElement description = (JsonElement)entry3.getValue();
                        String string = JsonElementKt.getContentOrNull((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)description));
                        if (string == null) {
                            string = "";
                        }
                        String string2 = string;
                        builder.addNode(new Device(mcuKey, vendorName, groupName, mcuKey, string2));
                    }
                }
            }
            return builder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String findDefaultGdbserverLocation() {
            String location2 = GdbServer.Companion.findPathLocation(this.getDEFAULT_GDBSERVER_NAME());
            if (location2 == null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                List list;
                Iterable<File> iterable;
                Iterable destination$iv$iv;
                Object object;
                if (SystemInfo.isWindows) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$mapNotNullTo$iv$iv;
                    object = new String[]{"ProgramFiles", "ProgramFiles(x86)"};
                    Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])object);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv$iv$iv.iterator();
                    while (object2.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = object2.next();
                        boolean bl = false;
                        String p0 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (EnvironmentUtil.getValue((String)p0) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv2 = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void s;
                        object2 = (String)item$iv$iv;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        iterable.add(new File((String)s, "SEGGER"));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = SystemInfo.isMac ? CollectionsKt.listOf((Object)new File("/Applications/SEGGER/")) : CollectionsKt.listOf((Object)new File("/opt/SEGGER/"));
                }
                List baseFolders = list;
                Iterable $this$flatMap$iv = baseFolders;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Object object3 = it.listFiles();
                    if (object3 == null || (object3 = ArraysKt.asList((Object[])object3)) == null) {
                        object3 = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = (Iterable)object3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void dir;
                    File list$iv$iv = (File)item$iv$iv;
                    iterable = destination$iv$iv2;
                    boolean bl = false;
                    iterable.add(new File((File)dir, Companion.getDEFAULT_GDBSERVER_NAME()));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File p0 = (File)element$iv$iv;
                    boolean bl = false;
                    if (!p0.canExecute()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                object = (File)CollectionsKt.getOrNull((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File p0 = (File)b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)p0.toString());
                        p0 = (File)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.toString())));
                    }
                }), (int)0);
                location2 = object != null ? ((File)object).toString() : null;
            }
            return location2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

