/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerKt;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServersStep;", "Lcom/intellij/ide/wizard/StepAdapter;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "cfg", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "(Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "getWizard", "()Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "dialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "gdbServer", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "component", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "_commit", "", "finishChosen", "", "getComponent", "_init", "getPreferredFocusedComponent", "getHelpId", "", "intellij.clion.embedded"})
public final class GdbServersStep
extends StepAdapter {
    @NotNull
    private final GdbServerWizard wizard;
    @NotNull
    private final RunnerAndConfigurationSettings cfg;
    @Nullable
    private DialogPanel dialogPanel;
    private GdbServer gdbServer;
    @Nullable
    private JComponent preferredFocusedComponent;
    @NotNull
    private final BorderLayoutPanel component;

    public GdbServersStep(@NotNull GdbServerWizard wizard, @NotNull RunnerAndConfigurationSettings cfg) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.wizard = wizard;
        this.cfg = cfg;
        this.component = new BorderLayoutPanel();
    }

    @NotNull
    public final GdbServerWizard getWizard() {
        return this.wizard;
    }

    public void _commit(boolean finishChosen) {
        DialogPanel dialogPanel = this.dialogPanel;
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        if (finishChosen) {
            this.wizard.verifyName();
            RunConfiguration runConfiguration = this.cfg.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration");
            CustomGdbServerRunConfiguration embedCfg = (CustomGdbServerRunConfiguration)runConfiguration;
            Object object = this.wizard.getState().getRemotePort();
            int port = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)GdbServerKt.getPORT_RANGE());
            CustomGdbServerRunConfiguration $this$_commit_u24lambda_u240 = embedCfg;
            boolean bl = false;
            $this$_commit_u24lambda_u240.setName(this.wizard.getState().getConfigurationName());
            $this$_commit_u24lambda_u240.setGdbRemoteString("tcp::" + port);
            GdbServer gdbServer = this.gdbServer;
            if (gdbServer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer = null;
            }
            $this$_commit_u24lambda_u240.setServerExecutable(gdbServer.getGdbserverExe(this.wizard.getState()));
            GdbServer gdbServer2 = this.gdbServer;
            if (gdbServer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer2 = null;
            }
            $this$_commit_u24lambda_u240.setProgramParameters(gdbServer2.generateConnectionString(this.wizard.getState(), port));
            $this$_commit_u24lambda_u240.setDownloadType(this.wizard.getState().getDownloadType());
            GdbServer gdbServer3 = this.gdbServer;
            if (gdbServer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer3 = null;
            }
            $this$_commit_u24lambda_u240.setResetCommand(gdbServer3.getResetCommand());
            ApplicationManager.getApplication().runWriteAction(() -> GdbServersStep._commit$lambda$1(this));
            Project project = this.wizard.getProject();
            GdbServer gdbServer4 = this.gdbServer;
            if (gdbServer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
                gdbServer4 = null;
            }
            EmbeddedUsagesCollector.logWizardSuccess(project, gdbServer4.getType());
        }
        this.component.removeAll();
        this.dialogPanel = null;
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.component;
    }

    public void _init() {
        super._init();
        this.gdbServer = GdbServer.Companion.byId(this.wizard.getState().getDebugProbe());
        this.wizard.setFinishEnabled(true);
        GdbServer gdbServer = this.gdbServer;
        if (gdbServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
            gdbServer = null;
        }
        DialogPanel dialogPanel = this.dialogPanel = gdbServer.getDialogPanel(this.wizard);
        Intrinsics.checkNotNull((Object)dialogPanel);
        this.component.addToCenter((Component)dialogPanel);
        List list = ComponentUtil.findComponentsOfType((JComponent)((JComponent)this.dialogPanel), Tree.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
        this.preferredFocusedComponent = (JComponent)CollectionsKt.getOrNull((List)list, (int)0);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.preferredFocusedComponent;
    }

    @NotNull
    public final String getHelpId() {
        GdbServer gdbServer = this.gdbServer;
        if (gdbServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gdbServer");
            gdbServer = null;
        }
        return "embedded.gdbserver.wizard." + gdbServer + ".getId()";
    }

    private static final void _commit$lambda$1(GdbServersStep this$0) {
        RunManager $this$_commit_u24lambda_u241_u240 = RunManager.Companion.getInstance(this$0.wizard.getProject());
        boolean bl = false;
        $this$_commit_u24lambda_u241_u240.addConfiguration(this$0.cfg);
        $this$_commit_u24lambda_u241_u240.setSelectedConfiguration(this$0.cfg);
    }
}

