/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.DeviceTreeRenderer;
import com.intellij.clion.embedded.execution.wizard.GdbServerKt;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.JLinkServer;
import com.intellij.clion.embedded.execution.wizard.PeMicroServer;
import com.intellij.clion.embedded.execution.wizard.PyOcdServer;
import com.intellij.clion.embedded.execution.wizard.Qemu;
import com.intellij.clion.embedded.execution.wizard.ResetStrategy;
import com.intellij.clion.embedded.execution.wizard.StLinkServer;
import com.intellij.clion.embedded.execution.wizard.StUtilServer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\tH'J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\tH&J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J3\u0010\u001e\u001a\u00020\u001f*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\t2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\"\"\u00020\t\u00a2\u0006\u0002\u0010#J+\u0010$\u001a\u00020%*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0\"\"\u00020'\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010,\u001a\u00020%*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J)\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\"\"\u00020\tH\u0004\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0004J\u0010\u00106\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00068"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "", "type", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;", "<init>", "(Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;)V", "getType", "()Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;", "id", "", "getId", "()Ljava/lang/String;", "getDisplayName", "generateConnectionString", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "port", "", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "getDefaultServerExecutableName", "findDefaultLocation", "getResetCommand", "getGdbserverLocation", "getGdbserverExe", "interfacesRow", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "Lcom/intellij/ui/dsl/builder/Panel;", "speedRow", "Lcom/intellij/ui/dsl/builder/Row;", "defaultSpeed", "speedVariants", "", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/ui/dsl/builder/Row;", "resetStrategyRow", "", "variants", "Lcom/intellij/clion/embedded/execution/wizard/ResetStrategy;", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;[Lcom/intellij/clion/embedded/execution/wizard/ResetStrategy;)V", "gatherData", "project", "Lcom/intellij/openapi/project/Project;", "devicesListRows", "gatherProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "ignoreStderr", "", "command", "(Z[Ljava/lang/String;)Lcom/intellij/execution/process/ProcessOutput;", "validateNonEmptyTree", "Ljavax/swing/tree/DefaultMutableTreeNode;", "rootNode", "selectedDeviceKey", "Companion", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nGdbServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbServer.kt\ncom/intellij/clion/embedded/execution/wizard/GdbServer\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n31#2:207\n13#3:208\n19#4:209\n808#5,11:210\n1563#5:221\n1634#5,3:222\n1208#5,2:225\n1236#5,4:227\n*S KotlinDebug\n*F\n+ 1 GdbServer.kt\ncom/intellij/clion/embedded/execution/wizard/GdbServer\n*L\n71#1:207\n177#1:208\n127#1:209\n137#1:210,11\n138#1:221\n138#1:222,3\n109#1:225,2\n109#1:227,4\n*E\n"})
public abstract class GdbServer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final GdbServerType type;
    @NotNull
    public static final String FREQ_AUTO = "AUTO";
    @NotNull
    public static final String FREQ_ADAPTIVE = "ADAPTIVE";
    @NotNull
    private static final GdbServer DEFAULT_GDBSERVER;
    @NotNull
    private static final Map<String, GdbServer> gdbServerMap;
    @NotNull
    private static final Collection<GdbServer> all;

    public GdbServer(@NotNull GdbServerType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
    }

    @NotNull
    public final GdbServerType getType() {
        return this.type;
    }

    @NotNull
    public final String getId() {
        return this.type.name();
    }

    @Nls
    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract String generateConnectionString(@NotNull GdbWizardOptions var1, int var2) throws CommitStepException;

    @NotNull
    public abstract DialogPanel getDialogPanel(@NotNull GdbServerWizard var1);

    @NotNull
    public abstract String getDefaultServerExecutableName();

    @Nullable
    public String findDefaultLocation() {
        return Companion.findPathLocation(this.getDefaultServerExecutableName());
    }

    @NotNull
    public String getResetCommand() {
        return "monitor reset";
    }

    @NotNull
    public final String getGdbserverLocation(@NotNull GdbWizardOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String string = state.getGdbserverLocations().get(this.getId());
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getGdbserverExe(@NotNull GdbWizardOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return this.getGdbserverLocation(state);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ButtonsGroup interfacesRow(@NotNull Panel $this$interfacesRow, @NotNull GdbServerWizard wizard) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$interfacesRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$interfacesRow, null, (boolean)false, GdbServer::interfacesRow$lambda$0, (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getInterfaceType();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setInterfaceType((GdbWizardOptions.Companion.TransportInterface)((Object)value));
            }
        };
        boolean $i$f$bind = false;
        return $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GdbWizardOptions.Companion.TransportInterface.class);
    }

    @NotNull
    public final Row speedRow(@NotNull Panel $this$speedRow, @NotNull GdbServerWizard wizard, @NotNull String defaultSpeed, String ... speedVariants) {
        Intrinsics.checkNotNullParameter((Object)$this$speedRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)defaultSpeed, (String)"defaultSpeed");
        Intrinsics.checkNotNullParameter((Object)speedVariants, (String)"speedVariants");
        String string = EmbeddedBundle.message("label.initial.speed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return $this$speedRow.row(string, arg_0 -> GdbServer.speedRow$lambda$0(speedVariants, defaultSpeed, wizard, arg_0));
    }

    public final void resetStrategyRow(@NotNull Panel $this$resetStrategyRow, @NotNull GdbServerWizard wizard, ResetStrategy ... variants) {
        Intrinsics.checkNotNullParameter((Object)$this$resetStrategyRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)variants, (String)"variants");
        String string = EmbeddedBundle.message("label.reset.strategy", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$resetStrategyRow.row(string, arg_0 -> GdbServer.resetStrategyRow$lambda$0(variants, wizard, arg_0));
    }

    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (!new File(this.getGdbserverLocation(state)).canExecute()) {
            throw new CommitStepException(EmbeddedBundle.message("wrong.gdb.server.location", new Object[0]));
        }
    }

    protected final void devicesListRows(@NotNull Panel $this$devicesListRows, @NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)$this$devicesListRows, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Panel.row$default((Panel)$this$devicesListRows, null, GdbServer::devicesListRows$lambda$0, (int)1, null);
        Panel.row$default((Panel)$this$devicesListRows, null, arg_0 -> GdbServer.devicesListRows$lambda$1(wizard, $this$devicesListRows, arg_0), (int)1, null).resizableRow();
    }

    @NotNull
    protected final ProcessOutput gatherProcessOutput(boolean ignoreStderr, String ... command) {
        ProcessOutput output;
        block4: {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            GeneralCommandLine cmd = new GeneralCommandLine(Arrays.copyOf(command, command.length));
            output = null;
            try {
                CapturingProcessHandler processHandler2 = new CapturingProcessHandler(cmd);
                ProcessOutput processOutput = CidrRunProcessUtil.runWithProgress((BaseProcessHandler)((BaseProcessHandler)processHandler2), (int)10000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runWithProgress(...)");
                output = processOutput;
                if (!output.isTimeout()) {
                    String string = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                    if (!(((CharSequence)string).length() > 0) || ignoreStderr) break block4;
                }
                Object[] objectArray = new Object[]{command[0]};
                throw new CommitStepException(EmbeddedBundle.message("gdbserver.app.cannot.report.supported.devices", objectArray));
            }
            catch (ExecutionException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GdbServer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(e.getMessage());
                Object[] objectArray = new Object[2];
                objectArray[0] = command[0];
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)StringsKt.chunked((CharSequence)string, (int)80), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                throw new CommitStepException(EmbeddedBundle.message("gdb.servers.wizard.exception.occurred.while.executable.invoke", objectArray));
            }
        }
        return output;
    }

    @NotNull
    protected final DefaultMutableTreeNode validateNonEmptyTree(@NotNull DefaultMutableTreeNode rootNode) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        if (rootNode.getChildCount() == 0) {
            throw new CommitStepException(EmbeddedBundle.message("gdbserver.cannot.report.supported.devices", new Object[0]));
        }
        return rootNode;
    }

    @NotNull
    protected final String selectedDeviceKey(@NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Device device = state.getSelectedDevice();
        if (device == null) {
            throw new CommitStepException(EmbeddedBundle.message("target.device.is.not.selected", new Object[0]));
        }
        return device.getMcuKey();
    }

    private static final Unit interfacesRow$lambda$0(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        String string = EmbeddedBundle.message("label.transport.interface", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$buttonsGroup.row(string, GdbServer::interfacesRow$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit interfacesRow$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = EmbeddedBundle.message("radio.swd", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)GdbWizardOptions.Companion.TransportInterface.SWD);
        String string2 = EmbeddedBundle.message("radio.jtag", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.radioButton(string2, (Object)GdbWizardOptions.Companion.TransportInterface.JTAG);
        return Unit.INSTANCE;
    }

    private static final Unit speedRow$lambda$0(String[] $speedVariants, String $defaultSpeed, GdbServerWizard $wizard, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)new CollectionComboBoxModel(ArraysKt.toMutableList((Object[])$speedVariants), (Object)$defaultSpeed)), null, (int)2, null), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getFrequency();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setFrequency((String)value);
            }
        })));
        String string = EmbeddedBundle.message("label.khz", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit resetStrategyRow$lambda$0(ResetStrategy[] $variants, GdbServerWizard $wizard, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)ArraysKt.toList((Object[])$variants), (ListCellRenderer)GdbServerKt.access$getResetStrategyRenderer$p()), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getResetStrategy();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setResetStrategy((ResetStrategy)((Object)value));
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit devicesListRows$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = EmbeddedBundle.message("label.device", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit devicesListRows$lambda$1(GdbServerWizard $wizard, Panel $this_devicesListRows, Row $this$row) {
        Object v3;
        Tree tree2;
        block1: {
            Tree tree3;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Tree $this$devicesListRows_u24lambda_u241_u240 = tree3 = new Tree((TreeNode)$wizard.getState().getDevicesTree());
            boolean bl = false;
            $this$devicesListRows_u24lambda_u241_u240.setRootVisible(false);
            $this$devicesListRows_u24lambda_u241_u240.setVisibleRowCount(6);
            $this$devicesListRows_u24lambda_u241_u240.addTreeSelectionListener(arg_0 -> GdbServer.devicesListRows$lambda$1$0$0($wizard, arg_0));
            $this$devicesListRows_u24lambda_u241_u240.setCellRenderer((TreeCellRenderer)((Object)new DeviceTreeRenderer()));
            tree2 = tree3;
            TreeSpeedSearch.installOn((JTree)((JTree)tree2), (boolean)true, arg_0 -> GdbServer.devicesListRows$lambda$1$2(GdbServer::devicesListRows$lambda$1$1, arg_0));
            $wizard.setFinishEnabled(false);
            JBTreeTraverser jBTreeTraverser = TreeUtil.treePathTraverser((JTree)((JTree)tree2));
            Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"treePathTraverser(...)");
            Iterable iterable = (Iterable)jBTreeTraverser;
            for (Object t : iterable) {
                Device device;
                TreePath it = (TreePath)t;
                boolean bl2 = false;
                Object object = it.getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
                Object object2 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                Device device2 = device = object2 instanceof Device ? (Device)object2 : null;
                String string = device != null ? device.getMcuName() : null;
                if (!Intrinsics.areEqual((Object)string, (Object)$wizard.getState().getSelectedDeviceName())) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        TreePath selectionPath = v3;
        tree2.setSelectionPath(selectionPath);
        tree2.scrollPathToVisible(selectionPath);
        $this_devicesListRows.onApply(() -> GdbServer.devicesListRows$lambda$1$4($wizard, tree2));
        $this$row.scrollCell((JComponent)tree2).align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final void devicesListRows$lambda$1$0$0(GdbServerWizard $wizard, TreeSelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TreePath treePath = e.getNewLeadSelectionPath();
        Object $this$asSafely$iv = treePath != null ? treePath.getLastPathComponent() : null;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof DefaultMutableTreeNode)) {
            object = null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object selectedObject = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        $wizard.setFinishEnabled(selectedObject instanceof Device);
    }

    /*
     * WARNING - void declaration
     */
    private static final String devicesListRows$lambda$1$1(TreePath path) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
        Iterable $this$filterIsInstance$iv = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DefaultMutableTreeNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserObject());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String devicesListRows$lambda$1$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit devicesListRows$lambda$1$4(GdbServerWizard $wizard, Tree $tree) {
        TreePath treePath = $tree.getLeadSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        Object object2 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        $wizard.getState().setSelectedDevice(object2 instanceof Device ? (Device)object2 : null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        DEFAULT_GDBSERVER = new JLinkServer();
        Object[] objectArray = new GdbServer[]{DEFAULT_GDBSERVER, new Qemu(), new PyOcdServer(), new StUtilServer(), new StLinkServer(), new PeMicroServer()};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GdbServer gdbServer = (GdbServer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        gdbServerMap = destination$iv$iv;
        all = gdbServerMap.values();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServer$Companion;", "", "<init>", "()V", "FREQ_AUTO", "", "FREQ_ADAPTIVE", "DEFAULT_GDBSERVER", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "gdbServerMap", "", "byId", "id", "all", "", "getAll", "()Ljava/util/Collection;", "findPathLocation", "defaultGdbServerName", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GdbServer byId(@Nullable String id) {
            return gdbServerMap.getOrDefault(id, DEFAULT_GDBSERVER);
        }

        @NotNull
        public final Collection<GdbServer> getAll() {
            return all;
        }

        @Nullable
        public final String findPathLocation(@NotNull String defaultGdbServerName) {
            Intrinsics.checkNotNullParameter((Object)defaultGdbServerName, (String)"defaultGdbServerName");
            File file = PathEnvironmentVariableUtil.findInPath((String)defaultGdbServerName);
            return file != null ? file.toString() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

