/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration;
import com.intellij.clion.embedded.execution.wizard.CommonStep;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerKt;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.remote.DebuggersComboBoxWithModel;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExecutableEditor;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\b\b\u0000\u0010&*\u00020'*\b\u0012\u0004\u0012\u0002H&0%H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000RP\u0010\u0019\u001aD\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c0\u001d\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c0\u001e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/CommonStep;", "Lcom/intellij/ide/wizard/StepAdapter;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "cfg", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "(Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "debugProbeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "targetSelector", "", "hintLabel", "Ljavax/swing/JLabel;", "debuggersCombo", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggersComboBoxWithModel;", "executableTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "portField", "Lcom/intellij/ui/components/fields/IntegerField;", "runConfiguration", "Lcom/intellij/clion/embedded/execution/custom/CustomGdbServerRunConfiguration;", "storageUI", "Lcom/intellij/execution/impl/RunConfigurationStorageUi;", "binaryEditor", "Lcom/jetbrains/cidr/execution/CidrRunConfigurationExecutableEditor;", "Lcom/jetbrains/cidr/execution/CidrBuildConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildTarget;", "Lcom/jetbrains/cidr/cpp/execution/CLionRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildConfigurationHelper;", "commonPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "_init", "", "updateExecutableField", "customGaps", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JComponent;", "serverExecutableExists", "", "onTargetSelected", "targetName", "_commit", "finishChosen", "getComponent", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nCommonStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonStep.kt\ncom/intellij/clion/embedded/execution/wizard/CommonStep\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n31#2:217\n1563#3:218\n1634#3,3:219\n*S KotlinDebug\n*F\n+ 1 CommonStep.kt\ncom/intellij/clion/embedded/execution/wizard/CommonStep\n*L\n129#1:217\n103#1:218\n103#1:219,3\n*E\n"})
public final class CommonStep
extends StepAdapter {
    @NotNull
    private final GdbServerWizard wizard;
    @NotNull
    private final RunnerAndConfigurationSettings cfg;
    private ComboBox<GdbServer> debugProbeSelector;
    private ComboBox<String> targetSelector;
    private JLabel hintLabel;
    private DebuggersComboBoxWithModel debuggersCombo;
    private TextFieldWithBrowseButton executableTextField;
    private IntegerField portField;
    @NotNull
    private CustomGdbServerRunConfiguration runConfiguration;
    private RunConfigurationStorageUi storageUI;
    @NotNull
    private final CidrRunConfigurationExecutableEditor<CidrBuildConfiguration, CidrBuildTarget<CidrBuildConfiguration>, CLionRunConfiguration<CidrBuildConfiguration, CidrBuildTarget<CidrBuildConfiguration>>, CidrBuildConfigurationHelper<CidrBuildConfiguration, CidrBuildTarget<CidrBuildConfiguration>>> binaryEditor;
    @NotNull
    private final DialogPanel commonPanel;

    public CommonStep(@NotNull GdbServerWizard wizard, @NotNull RunnerAndConfigurationSettings cfg) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.wizard = wizard;
        this.cfg = cfg;
        RunConfiguration runConfiguration = this.cfg.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration");
        this.runConfiguration = (CustomGdbServerRunConfiguration)runConfiguration;
        Project project = this.wizard.getProject();
        CidrCompoundConfigurationHelper cidrCompoundConfigurationHelper = this.runConfiguration.getHelper();
        Intrinsics.checkNotNull((Object)cidrCompoundConfigurationHelper, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.CidrBuildConfigurationHelper<com.jetbrains.cidr.execution.CidrBuildConfiguration, com.jetbrains.cidr.execution.CidrBuildTarget<com.jetbrains.cidr.execution.CidrBuildConfiguration>>");
        this.binaryEditor = new CidrRunConfigurationExecutableEditor(project, (CidrBuildConfigurationHelper)cidrCompoundConfigurationHelper, this.runConfiguration.getHelper().hasTargetsInSeveralProjects());
        this.commonPanel = BuilderKt.panel(arg_0 -> CommonStep.commonPanel$lambda$0(this, arg_0));
    }

    public void _init() {
        super._init();
        this.updateExecutableField();
    }

    private final void updateExecutableField() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox<GdbServer> comboBox = this.debugProbeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debugProbeSelector");
            comboBox = null;
        }
        GdbServer gdbServer = (GdbServer)comboBox.getItem();
        Ref.ObjectRef location2 = new Ref.ObjectRef();
        location2.element = this.wizard.getState().getGdbserverLocations().get(gdbServer.getId());
        Object[] objectArray = (Object[])location2.element;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CommonStep.updateExecutableField$lambda$0(location2, gdbServer), EmbeddedBundle.message("progress.title.looking.for.installed.utility", new Object[0]), false, this.wizard.getProject());
        }
        if ((textFieldWithBrowseButton = this.executableTextField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executableTextField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.getTextField().setText((String)location2.element);
        JLabel jLabel = this.hintLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hintLabel");
            jLabel = null;
        }
        objectArray = new Object[]{gdbServer.getDefaultServerExecutableName()};
        jLabel.setText(EmbeddedBundle.message("expected.gdbserver.name", objectArray));
    }

    private final <T extends JComponent> Cell<T> customGaps(Cell<? extends T> $this$customGaps) {
        return $this$customGaps.customize(UnscaledGapsKt.UnscaledGaps((int)5, (int)3, (int)5, (int)3));
    }

    private final boolean serverExecutableExists() {
        boolean bl;
        block9: {
            block8: {
                File file;
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.executableTextField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executableTextField");
                    textFieldWithBrowseButton = null;
                }
                if ((file = new File(textFieldWithBrowseButton.getText())).canExecute()) break block8;
                TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.executableTextField;
                if (textFieldWithBrowseButton2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executableTextField");
                    textFieldWithBrowseButton2 = null;
                }
                if (PathEnvironmentVariableUtil.findInPath((String)textFieldWithBrowseButton2.getText()) == null) break block9;
            }
            return true;
        }
        if (SystemInfo.isWindows) {
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.executableTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executableTextField");
                textFieldWithBrowseButton = null;
            }
            bl = PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)textFieldWithBrowseButton.getText(), null) != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void onTargetSelected(String targetName) {
        if (targetName != null) {
            this.binaryEditor.onTargetSelected(this.runConfiguration.getHelper().findRunTarget(new BuildTargetData(this.wizard.getProject().getName(), targetName)));
        }
    }

    public void _commit(boolean finishChosen) {
        this.commonPanel.apply();
        this.wizard.verifyName();
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.executableTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executableTextField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            throw new CommitStepException(CLionExecutionBundle.message((String)"gdbserver.executable.not.specified", (Object[])new Object[0]));
        }
        if (!this.serverExecutableExists()) {
            throw new CommitStepException(CLionExecutionBundle.message((String)"gdbserver.wrong.executable", (Object[])new Object[0]));
        }
        IntegerField integerField = this.portField;
        if (integerField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"portField");
            integerField = null;
        }
        String string2 = integerField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (((CharSequence)string2).length() > 0) {
            Integer n;
            IntegerField integerField2 = this.portField;
            if (integerField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"portField");
                integerField2 = null;
            }
            String string3 = integerField2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Integer it = n = StringsKt.toIntOrNull((String)string3);
            boolean bl = false;
            if (it == null || !GdbServerKt.getPORT_RANGE().contains(it.intValue())) {
                Object[] objectArray = new Object[]{GdbServerKt.getPORT_RANGE().getFirst(), GdbServerKt.getPORT_RANGE().getLast()};
                throw new CommitStepException(EmbeddedBundle.message("please.enter.port.number", objectArray));
            }
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CommonStep._commit$lambda$1(this), EmbeddedBundle.message("progress.title.loading.devices", new Object[0]), true, this.wizard.getProject());
        RunConfiguration runConfiguration = this.cfg.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.custom.CustomGdbServerRunConfiguration");
        CustomGdbServerRunConfiguration $this$_commit_u24lambda_u242 = (CustomGdbServerRunConfiguration)runConfiguration;
        boolean bl = false;
        String string4 = $this$_commit_u24lambda_u242.getProject().getName();
        ComboBox<String> comboBox = this.targetSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetSelector");
            comboBox = null;
        }
        $this$_commit_u24lambda_u242.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(string4, (String)comboBox.getItem(), null));
        DebuggersComboBoxWithModel debuggersComboBoxWithModel = this.debuggersCombo;
        if (debuggersComboBoxWithModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggersCombo");
            debuggersComboBoxWithModel = null;
        }
        $this$_commit_u24lambda_u242.setDebuggerData(debuggersComboBoxWithModel.getSelectedDebugger());
        this.binaryEditor.applyEditorTo((CidrRunConfiguration)$this$_commit_u24lambda_u242);
        RunConfigurationStorageUi runConfigurationStorageUi = this.storageUI;
        if (runConfigurationStorageUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storageUI");
            runConfigurationStorageUi = null;
        }
        runConfigurationStorageUi.apply(this.cfg);
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.commonPanel;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commonPanel$lambda$0(CommonStep this$0, Panel $this$panel) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.name.config", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CommonStep.commonPanel$lambda$0$0(this$0, arg_0));
        String string2 = EmbeddedBundle.message("label.gdb.server.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> CommonStep.commonPanel$lambda$0$1(this$0, arg_0));
        String string3 = EmbeddedBundle.message("label.location", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> CommonStep.commonPanel$lambda$0$2(this$0, arg_0));
        $this$panel.row("", arg_0 -> CommonStep.commonPanel$lambda$0$3(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        String string4 = EmbeddedBundle.message("label.gdb", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> CommonStep.commonPanel$lambda$0$4(this$0, arg_0));
        String string5 = EmbeddedBundle.message("label.target", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, arg_0 -> CommonStep.commonPanel$lambda$0$5(this$0, arg_0));
        String string6 = EmbeddedBundle.message("label.executable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        $this$panel.row(string6, arg_0 -> CommonStep.commonPanel$lambda$0$6(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, CommonStep::commonPanel$lambda$0$7, (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0.wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getDownloadType();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setDownloadType((DownloadType)value);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), DownloadType.class);
        String string7 = EmbeddedBundle.message("label.tcp.ip.port", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        $this$panel.row(string7, arg_0 -> CommonStep.commonPanel$lambda$0$8(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit commonPanel$lambda$0$0(CommonStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        GdbWizardOptions gdbWizardOptions = this$0.wizard.getState();
        String string = this$0.cfg.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        gdbWizardOptions.setConfigurationName(string);
        this$0.customGaps(TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0.wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getConfigurationName();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setConfigurationName((String)value);
            }
        })).align((Align)AlignX.FILL.INSTANCE).resizableColumn());
        this$0.storageUI = new RunConfigurationStorageUi(this$0.wizard.getProject(), null);
        RunConfigurationStorageUi runConfigurationStorageUi = this$0.storageUI;
        if (runConfigurationStorageUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storageUI");
            runConfigurationStorageUi = null;
        }
        runConfigurationStorageUi.reset(this$0.cfg);
        RunConfigurationStorageUi runConfigurationStorageUi2 = this$0.storageUI;
        if (runConfigurationStorageUi2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storageUI");
            runConfigurationStorageUi2 = null;
        }
        JPanel jPanel = runConfigurationStorageUi2.createComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createComponent(...)");
        $this$row.cell((JComponent)jPanel).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit commonPanel$lambda$0$1(CommonStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.debugProbeSelector = (ComboBox)this$0.customGaps(ComboBoxKt.bindItem((Cell)$this$row.comboBox(GdbServer.Companion.getAll(), (ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> CommonStep.commonPanel$lambda$0$1$0(commonPanel.1.2.1.INSTANCE, arg_0))).align((Align)AlignX.FILL.INSTANCE), () -> CommonStep.commonPanel$lambda$0$1$1(this$0), arg_0 -> CommonStep.commonPanel$lambda$0$1$2(this$0, arg_0))).getComponent();
        ComboBox<GdbServer> comboBox = this$0.debugProbeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debugProbeSelector");
            comboBox = null;
        }
        comboBox.addItemListener(arg_0 -> CommonStep.commonPanel$lambda$0$1$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final String commonPanel$lambda$0$1$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final GdbServer commonPanel$lambda$0$1$1(CommonStep this$0) {
        return GdbServer.Companion.byId(this$0.wizard.getState().getDebugProbe());
    }

    private static final Unit commonPanel$lambda$0$1$2(CommonStep this$0, GdbServer it) {
        GdbWizardOptions gdbWizardOptions = this$0.wizard.getState();
        Object object = it;
        if (object == null || (object = ((GdbServer)object).getId()) == null) {
            object = "";
        }
        gdbWizardOptions.setDebugProbe((String)object);
        return Unit.INSTANCE;
    }

    private static final void commonPanel$lambda$0$1$3(CommonStep this$0, ItemEvent it) {
        this$0.updateExecutableField();
    }

    private static final Unit commonPanel$lambda$0$2(CommonStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.executableTextField = (TextFieldWithBrowseButton)this$0.customGaps(TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, null, null, (int)3, null), () -> CommonStep.commonPanel$lambda$0$2$0(this$0), arg_0 -> CommonStep.commonPanel$lambda$0$2$1(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE)).getComponent();
        return Unit.INSTANCE;
    }

    private static final String commonPanel$lambda$0$2$0(CommonStep this$0) {
        String string;
        Map<String, String> map = this$0.wizard.getState().getGdbserverLocations();
        ComboBox<GdbServer> comboBox = this$0.debugProbeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debugProbeSelector");
            comboBox = null;
        }
        if ((string = map.get(((GdbServer)comboBox.getItem()).getId())) == null) {
            string = "";
        }
        return string;
    }

    private static final Unit commonPanel$lambda$0$2$1(CommonStep this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map<String, String> map = this$0.wizard.getState().getGdbserverLocations();
        ComboBox<GdbServer> comboBox = this$0.debugProbeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debugProbeSelector");
            comboBox = null;
        }
        map.put(((GdbServer)comboBox.getItem()).getId(), it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commonPanel$lambda$0$3(CommonStep this$0, Row $this$row) {
        void $this$commonPanel_u24lambda_u240_u243_u240;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $this$row.label(".").customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)6, (int)6, (int)0, (int)9, null)).getComponent();
        JLabel jLabel = (JLabel)jComponent;
        CommonStep commonStep = this$0;
        boolean bl = false;
        $this$commonPanel_u24lambda_u240_u243_u240.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        commonStep.hintLabel = (JLabel)jComponent;
        return Unit.INSTANCE;
    }

    private static final Unit commonPanel$lambda$0$4(CommonStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.debuggersCombo = new DebuggersComboBoxWithModel(this$0.wizard.getProject(), false, true, 2, null);
        DebuggersComboBoxWithModel debuggersComboBoxWithModel = this$0.debuggersCombo;
        if (debuggersComboBoxWithModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggersCombo");
            debuggersComboBoxWithModel = null;
        }
        $this$row.cell((JComponent)debuggersComboBoxWithModel.getComponent()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commonPanel$lambda$0$5(CommonStep this$0, Row $this$row) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        List list = this$0.runConfiguration.getHelper().getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTargets(...)");
        Iterable iterable = list;
        Row row = $this$row;
        CommonStep commonStep = this$0;
        CommonStep commonStep2 = this$0;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CidrBuildTarget cidrBuildTarget = (CidrBuildTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        commonStep2.targetSelector = (ComboBox)ComboBoxKt.bindItem(commonStep.customGaps(Row.comboBox$default((Row)row, (Collection)collection, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE)), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0.wizard.getState()){

            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getTargetValue();
            }

            public void set(Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setTargetValue((String)value);
            }
        }))).getComponent();
        ComboBox<String> comboBox = this$0.targetSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetSelector");
            comboBox = null;
        }
        comboBox.addItemListener(arg_0 -> CommonStep.commonPanel$lambda$0$5$1(this$0, arg_0));
        ComboBox<String> comboBox2 = this$0.targetSelector;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetSelector");
            comboBox2 = null;
        }
        this$0.onTargetSelected((String)comboBox2.getItem());
        ComboBox<String> comboBox3 = this$0.targetSelector;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetSelector");
            comboBox3 = null;
        }
        ComboboxSpeedSearch.installOn((JComboBox)((JComboBox)comboBox3));
        return Unit.INSTANCE;
    }

    private static final void commonPanel$lambda$0$5$1(CommonStep this$0, ItemEvent it) {
        ComboBox<String> comboBox = this$0.targetSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetSelector");
            comboBox = null;
        }
        this$0.onTargetSelected((String)comboBox.getItem());
    }

    private static final Unit commonPanel$lambda$0$6(CommonStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboboxWithBrowseButton comboboxWithBrowseButton = this$0.binaryEditor.getComboboxWithBrowseButton();
        Intrinsics.checkNotNullExpressionValue((Object)comboboxWithBrowseButton, (String)"getComboboxWithBrowseButton(...)");
        $this$row.cell((JComponent)comboboxWithBrowseButton).align((Align)AlignX.FILL.INSTANCE);
        ComboboxSpeedSearch.installOn((JComboBox)this$0.binaryEditor.getComboboxWithBrowseButton().getComboBox());
        return Unit.INSTANCE;
    }

    private static final Unit commonPanel$lambda$0$7(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        String string = EmbeddedBundle.message("gdb.servers.wizard.download.binary", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$buttonsGroup.row(string, CommonStep::commonPanel$lambda$0$7$0);
        return Unit.INSTANCE;
    }

    private static final Unit commonPanel$lambda$0$7$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CLionExecutionBundle.message((String)"gdbserver.download.type.ALWAYS", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, (Object)DownloadType.ALWAYS).customize(UnscaledGapsKt.UnscaledGaps((int)5, (int)3, (int)5, (int)10));
        String string2 = CLionExecutionBundle.message((String)"gdbserver.download.type.UPDATED_ONLY", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.radioButton(string2, (Object)DownloadType.UPDATED_ONLY);
        String string3 = CLionExecutionBundle.message((String)"gdbserver.download.type.NONE", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$row.radioButton(string3, (Object)DownloadType.NONE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commonPanel$lambda$0$8(CommonStep this$0, Row $this$row) {
        void $this$commonPanel_u24lambda_u240_u248_u240;
        IntegerField integerField;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        IntegerField integerField2 = integerField = new IntegerField(null, GdbServerKt.getPORT_RANGE().getFirst(), GdbServerKt.getPORT_RANGE().getLast());
        CommonStep commonStep = this$0;
        boolean bl = false;
        $this$commonPanel_u24lambda_u240_u248_u240.getEmptyText().setText(EmbeddedBundle.message("port.number.auto", new Object[0]));
        $this$commonPanel_u24lambda_u240_u248_u240.setColumns(6);
        commonStep.portField = integerField;
        IntegerField integerField3 = this$0.portField;
        if (integerField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"portField");
            integerField3 = null;
        }
        this$0.customGaps(TextFieldKt.bindText((Cell)$this$row.cell((JComponent)integerField3), () -> CommonStep.commonPanel$lambda$0$8$1(this$0), arg_0 -> CommonStep.commonPanel$lambda$0$8$2(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final String commonPanel$lambda$0$8$1(CommonStep this$0) {
        String string = this$0.wizard.getState().getRemotePort();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final Unit commonPanel$lambda$0$8$2(CommonStep this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.wizard.getState().setRemotePort(it);
        return Unit.INSTANCE;
    }

    private static final void updateExecutableField$lambda$0(Ref.ObjectRef $location, GdbServer $gdbServer) {
        $location.element = $gdbServer.findDefaultLocation();
    }

    private static final Unit _commit$lambda$1(CommonStep this$0) {
        ComboBox<GdbServer> comboBox = this$0.debugProbeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debugProbeSelector");
            comboBox = null;
        }
        ((GdbServer)comboBox.getItem()).gatherData(this$0.wizard.getProject(), this$0.wizard.getState());
        return Unit.INSTANCE;
    }
}

