/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.ui;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.OpenOcdConfiguration;
import com.intellij.clion.embedded.execution.ui.EmbeddedMessages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectBoardDialog
extends DialogWrapper {
    public static final int CONFIG_FILE_SIZE_LIMIT = 100000;
    private String myResult;
    private final File @NotNull [] myBoardFiles;
    private final Project myProject;
    @Nullable
    private File mySelectedFile;
    private JBList<File> myBoardList;
    private CopyAndUseAction myCopyAndUseAction;

    private SelectBoardDialog(@Nullable Project project, boolean skipInsteadOfCancel, File @NotNull [] boardFiles) {
        if (boardFiles == null) {
            SelectBoardDialog.$$$reportNull$$$0(0);
        }
        super(project, false, true);
        this.myResult = null;
        this.getOKAction().putValue("Name", EmbeddedBundle.message("use.board.button", new Object[0]));
        if (skipInsteadOfCancel) {
            this.getCancelAction().putValue("Name", EmbeddedBundle.message("skip.board.button", new Object[0]));
        }
        this.myProject = project;
        this.myBoardFiles = boardFiles;
        this.setTitle(EmbeddedBundle.message("select.board.dialog.title", new Object[0]));
        this.init();
        this.myBoardList.setSelectedIndex(0);
    }

    protected Action @NotNull [] createActions() {
        this.myCopyAndUseAction = new CopyAndUseAction();
        Action[] actionArray = new Action[]{this.getOKAction(), this.myCopyAndUseAction, this.getCancelAction()};
        if (actionArray == null) {
            SelectBoardDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.myBoardList = new JBList((Object[])this.myBoardFiles);
        this.myBoardList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", File::getName));
        this.myBoardList.setSelectionMode(0);
        this.myBoardList.addListSelectionListener(e -> {
            int index = this.myBoardList.getSelectedIndex();
            this.getOKAction().setEnabled(index >= 0);
            this.myCopyAndUseAction.setEnabled(index >= 0);
            if (index >= 0) {
                this.mySelectedFile = this.myBoardFiles[index];
                this.myResult = "board/" + this.mySelectedFile.getName();
            } else {
                this.mySelectedFile = null;
                this.myResult = null;
            }
        });
        this.myBoardList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() > 1) {
                    SelectBoardDialog.this.clickDefaultButton();
                }
            }
        });
        ListSpeedSearch.installOn(this.myBoardList);
        return new JBScrollPane(this.myBoardList);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBoardList;
    }

    @Nullable
    public static String selectBoardByPriority(@NotNull Project project, boolean skipInsteadOfCancel, @Nullable String boardName, @Nullable String mcuFamilyName) {
        if (project == null) {
            SelectBoardDialog.$$$reportNull$$$0(2);
        }
        try {
            ArrayList<Pair> keywordWeight = new ArrayList<Pair>();
            String board = StringUtil.toUpperCase((String)Objects.toString(boardName, ""));
            if (!board.isEmpty()) {
                keywordWeight.add(Pair.pair((Object)board, (Object)1000));
            }
            Stream.of("NUCLEO", "EVAL").filter(board::contains).findFirst().ifPresent(s -> keywordWeight.add(Pair.pair((Object)s, (Object)100)));
            if (board.contains("DISCOVERY")) {
                keywordWeight.add(Pair.pair((Object)"DISCOVERY", (Object)100));
                keywordWeight.add(Pair.pair((Object)"DISC", (Object)20));
            } else if (board.contains("DISC")) {
                keywordWeight.add(Pair.pair((Object)"DISC", (Object)100));
                keywordWeight.add(Pair.pair((Object)"DISCOVERY", (Object)20));
            }
            String mcuFamily = StringUtil.toUpperCase((String)Objects.toString(mcuFamilyName, ""));
            for (int i = mcuFamily.length() - 1; i >= 6; --i) {
                keywordWeight.add(Pair.pair((Object)mcuFamily.substring(0, i), (Object)i));
            }
            EmbeddedSettingsState ocdSettings = EmbeddedSettingsState.getInstance();
            File[] ocdBoards = SelectBoardDialog.findBoardsConfigFiles(ocdSettings);
            Stream<File> boardByScores = ((Stream)Stream.of(ocdBoards).parallel()).filter(f -> !f.isDirectory()).map(ocdBoard -> SelectBoardDialog.calcConfigFileScore(keywordWeight, ocdBoard)).sorted(Comparator.comparingInt(p -> -((Integer)p.getSecond()).intValue()).thenComparing(p -> (File)p.getFirst())).map(p -> (File)p.getFirst());
            File[] values = (File[])boardByScores.toArray(File[]::new);
            SelectBoardDialog dialog = new SelectBoardDialog(project, skipInsteadOfCancel, values);
            dialog.show();
            int i = dialog.getExitCode();
            if (i == 0 && dialog.mySelectedFile != null) {
                return dialog.myResult;
            }
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
        }
        return null;
    }

    public static File[] findBoardsConfigFiles(EmbeddedSettingsState ocdSettings) throws ConfigurationException {
        File ocdScripts = OpenOcdConfiguration.require(OpenOcdConfiguration.findOcdScripts(new File(ocdSettings.openOcdLocation)));
        return OpenOcdConfiguration.require(new File(ocdScripts, "board")).listFiles();
    }

    @NotNull
    private static Pair<File, Integer> calcConfigFileScore(@NotNull List<Pair<String, Integer>> keywordWeight, @NotNull File ocdBoard) {
        block6: {
            Pair pair2;
            if (keywordWeight == null) {
                SelectBoardDialog.$$$reportNull$$$0(3);
            }
            if (ocdBoard == null) {
                SelectBoardDialog.$$$reportNull$$$0(4);
            }
            try {
                if (ocdBoard.length() >= 100000L) break block6;
                String text = StringUtil.toUpperCase((String)FileUtil.loadFile((File)ocdBoard, (Charset)Charsets.US_ASCII));
                int weight = keywordWeight.parallelStream().filter(entry -> text.contains((CharSequence)entry.getFirst())).mapToInt(pair -> (Integer)pair.getSecond()).sum();
                pair2 = Pair.pair((Object)ocdBoard, (Object)weight);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (pair2 == null) {
                SelectBoardDialog.$$$reportNull$$$0(5);
            }
            return pair2;
        }
        Pair pair3 = Pair.pair((Object)ocdBoard, (Object)0);
        if (pair3 == null) {
            SelectBoardDialog.$$$reportNull$$$0(6);
        }
        return pair3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boardFiles";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/ui/SelectBoardDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordWeight";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocdBoard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/ui/SelectBoardDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcConfigFileScore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectBoardByPriority";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcConfigFileScore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }

    private final class CopyAndUseAction
    extends AbstractAction {
        private CopyAndUseAction() {
            super(EmbeddedBundle.message("select.board.dialog.copy.and.use.action", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean overwrite;
            if (SelectBoardDialog.this.mySelectedFile == null) {
                return;
            }
            VirtualFile projectDir = Objects.requireNonNull(ProjectUtil.guessProjectDir((Project)SelectBoardDialog.this.myProject));
            if (projectDir.findChild(SelectBoardDialog.this.mySelectedFile.getName()) != null) {
                int yesNoCancelReply = Messages.showYesNoCancelDialog((Project)SelectBoardDialog.this.myProject, (String)EmbeddedBundle.message("select.board.dialog.overwrite.file", SelectBoardDialog.this.mySelectedFile.getName()), (String)EmbeddedBundle.message("select.board.dialog.overwrite.title", new Object[0]), null);
                switch (yesNoCancelReply) {
                    case 0: {
                        overwrite = true;
                        break;
                    }
                    case 1: {
                        overwrite = false;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            } else {
                overwrite = true;
            }
            try {
                SelectBoardDialog.this.mySelectedFile = (File)ApplicationManager.getApplication().runWriteAction(() -> {
                    VirtualFile newConfigFile = projectDir.findOrCreateChildData((Object)this, SelectBoardDialog.this.mySelectedFile.getName());
                    if (overwrite) {
                        newConfigFile.setBinaryContent(FileUtil.loadFileBytes((File)SelectBoardDialog.this.mySelectedFile));
                    }
                    return VfsUtilCore.virtualToIoFile((VirtualFile)newConfigFile);
                });
                SelectBoardDialog.this.myResult = SelectBoardDialog.this.mySelectedFile.getAbsolutePath();
                SelectBoardDialog.this.close(0);
            }
            catch (IOException ex) {
                @NlsSafe String className = ex.getClass().getName();
                EmbeddedMessages.showErrorMessage(SelectBoardDialog.this.myProject, className, Objects.toString(ex.getLocalizedMessage(), ""));
            }
        }
    }
}

