/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.ui;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.OpenOcdConfiguration;
import com.intellij.clion.embedded.execution.ui.FileChooseInput;
import com.intellij.clion.embedded.execution.ui.SelectBoardDialog;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundRunConfigurationSettingsEditor;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.RadioButtonPanel;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.cpp.execution.remote.DebuggersComboBoxWithModel;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class OpenOcdConfigurationEditor
extends CidrCompoundRunConfigurationSettingsEditor {
    public static final File USER_HOME = new File(SystemProperties.getUserHome());
    private DebuggersComboBoxWithModel myDebuggers;
    private IntegerField gdbPort;
    private IntegerField telnetPort;
    private FileChooseInput boardConfigFile;
    private String openOcdLocation;
    private RadioButtonPanel<DownloadType> downloadGroup;
    private RadioButtonPanel<OpenOcdConfiguration.ResetType> resetGroup;

    public OpenOcdConfigurationEditor(@NotNull Project project, @NotNull CidrCompoundConfigurationHelper configHelper) {
        if (project == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(1);
        }
        super(project, configHelper);
    }

    protected void applyEditorTo(@NotNull CidrRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(2);
        }
        super.applyEditorTo(runConfiguration);
        OpenOcdConfiguration ocdConfiguration = (OpenOcdConfiguration)runConfiguration;
        DebuggerData selectedDebugger = this.myDebuggers.getSelectedDebugger();
        ocdConfiguration.setDebuggerData(selectedDebugger);
        String boardConfig = this.boardConfigFile.getText().trim();
        ocdConfiguration.setBoardConfigFile(boardConfig.isEmpty() ? null : boardConfig);
        this.gdbPort.validateContent();
        this.telnetPort.validateContent();
        ocdConfiguration.setGdbPort(this.gdbPort.getValue());
        ocdConfiguration.setTelnetPort(this.telnetPort.getValue());
        ocdConfiguration.setDownloadType((DownloadType)this.downloadGroup.getSelectedValue());
        ocdConfiguration.setResetType((OpenOcdConfiguration.ResetType)((Object)this.resetGroup.getSelectedValue()));
    }

    protected void resetEditorFrom(@NotNull CidrRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(3);
        }
        super.resetEditorFrom(runConfiguration);
        OpenOcdConfiguration ocd = (OpenOcdConfiguration)runConfiguration;
        this.openOcdLocation = EmbeddedSettingsState.getInstance().openOcdLocation;
        this.myDebuggers.resetModel(ocd.getDebuggerData());
        this.boardConfigFile.setText(ocd.getBoardConfigFile());
        this.gdbPort.setText(String.valueOf(ocd.getGdbPort()));
        this.telnetPort.setText(String.valueOf(ocd.getTelnetPort()));
        this.downloadGroup.setSelectedValue((Object)ocd.getDownloadType());
        this.resetGroup.setSelectedValue((Object)ocd.getResetType());
    }

    protected void createEditorInner(@NotNull JPanel panel, @NotNull GridBag gridBag) {
        if (panel == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (gridBag == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(5);
        }
        super.createEditorInner(panel, gridBag);
        for (Component component2 : panel.getComponents()) {
            if (!(component2 instanceof CommonProgramParametersPanel)) continue;
            component2.setVisible(false);
        }
        this.myDebuggers = new DebuggersComboBoxWithModel(this.myProject, true, true);
        panel.add((Component)new JLabel(CLionExecutionBundle.message((String)"remote.debuggers.combobox.debugger", (Object[])new Object[0])), gridBag.nextLine().next());
        panel.add((Component)this.myDebuggers.getComponent(), gridBag.next().coverLine());
        panel.add((Component)new JLabel(EmbeddedBundle.message("openocd.board.config.file.label", new Object[0])), gridBag.nextLine().next());
        JPanel boardPanel = this.createBoardSelector();
        panel.add((Component)boardPanel, gridBag.next().coverLine());
        panel.add(Box.createVerticalStrut(12), gridBag.nextLine());
        this.gdbPort = OpenOcdConfigurationEditor.addPortInput(panel, gridBag, EmbeddedBundle.message("openocd.gdb.port.label", new Object[0]), 3333);
        this.telnetPort = OpenOcdConfigurationEditor.addPortInput(panel, gridBag, EmbeddedBundle.message("openocd.telnet.port.label", new Object[0]), 4444);
        panel.add(Box.createVerticalStrut(12), gridBag.nextLine());
        panel.add((Component)new JLabel(EmbeddedBundle.message("openocd.download.label", new Object[0])), gridBag.nextLine().next());
        this.downloadGroup = new RadioButtonPanel((Object[])DownloadType.values());
        panel.add((Component)this.downloadGroup, gridBag.next().fillCellHorizontally());
        panel.add(Box.createVerticalStrut(12), gridBag.nextLine());
        panel.add((Component)new JLabel(EmbeddedBundle.message("openocd.reset.label", new Object[0])), gridBag.nextLine().next());
        this.resetGroup = new RadioButtonPanel((Object[])OpenOcdConfiguration.ResetType.values());
        panel.add((Component)this.resetGroup, gridBag.next());
    }

    @NotNull
    private JPanel createBoardSelector() {
        HorizontalBox boardPanel = new HorizontalBox();
        this.boardConfigFile = new FileChooseInput.BoardCfg("Board config", USER_HOME, () -> this.openOcdLocation);
        boardPanel.add((Component)((Object)this.boardConfigFile));
        boardPanel.add(new JButton(new AbstractAction(EmbeddedBundle.message("openocd.assist.button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedBoard = OpenOcdConfigurationEditor.this.selectBoard();
                if (selectedBoard != null && !selectedBoard.isEmpty()) {
                    OpenOcdConfigurationEditor.this.boardConfigFile.setText(selectedBoard);
                }
            }
        }));
        HorizontalBox horizontalBox = boardPanel;
        if (horizontalBox == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(6);
        }
        return horizontalBox;
    }

    @Nullable
    @NlsSafe
    private String selectBoard() {
        VirtualFile projectDir;
        if (this.myProject == null) {
            return null;
        }
        String board = null;
        String mcuFamily = null;
        @SystemIndependent String projectPath = this.myProject.getBasePath();
        VirtualFile[] projectFiles = null;
        if (projectPath != null && (projectDir = VfsUtil.findFile((Path)Paths.get(projectPath, new String[0]), (boolean)true)) != null) {
            projectFiles = projectDir.getChildren();
        }
        if (projectFiles != null) {
            Properties properties = new Properties();
            Stream<VirtualFile> fileStream = Stream.of(projectFiles).filter(file -> !file.isDirectory()).filter(file -> "ioc".equalsIgnoreCase(file.getExtension()));
            Iterator fileIterator = fileStream.iterator();
            while (fileIterator.hasNext()) {
                VirtualFile file2 = (VirtualFile)fileIterator.next();
                try {
                    properties.load(file2.getInputStream());
                    if (!properties.containsKey("board") && !properties.containsKey("Mcu.Name")) continue;
                    break;
                }
                catch (IOException iOException) {
                }
            }
            mcuFamily = properties.getProperty("Mcu.Name");
            board = properties.getProperty("board");
        }
        return SelectBoardDialog.selectBoardByPriority(this.myProject, false, board, mcuFamily);
    }

    @NotNull
    private static IntegerField addPortInput(@NotNull JPanel panel, GridBag gridBag, @NlsContexts.Label @NotNull String label, int defaultValue) {
        if (panel == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(7);
        }
        if (label == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(8);
        }
        panel.add((Component)new JLabel(label), gridBag.nextLine().next());
        IntegerField field = new IntegerField(label, 1024, 65535);
        field.setDefaultValue(Integer.valueOf(defaultValue));
        field.setColumns(5);
        panel.add((Component)field, gridBag.next().fillCellNone().anchor(21));
        IntegerField integerField = field;
        if (integerField == null) {
            OpenOcdConfigurationEditor.$$$reportNull$$$0(9);
        }
        return integerField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridBag";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/ui/OpenOcdConfigurationEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/ui/OpenOcdConfigurationEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBoardSelector";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addPortInput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditorInner";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPortInput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

