/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.ui;

import com.intellij.clion.embedded.execution.OpenOcdConfiguration;
import com.intellij.clion.embedded.execution.ui.OpenOcdConfigurationEditor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileChooseInput
extends TextFieldWithBrowseButton {
    @NotNull
    public static final String BOARD_FOLDER = "board";
    @NotNull
    protected final FileTextFieldValueEditor editor;
    @NotNull
    private final FileChooserDescriptor fileDescriptor;

    protected FileChooseInput(@Nullable String valueName, @NotNull File defaultLocation, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (defaultLocation == null) {
            FileChooseInput.$$$reportNull$$$0(0);
        }
        if (fileChooserDescriptor == null) {
            FileChooseInput.$$$reportNull$$$0(1);
        }
        super((JTextField)new JBTextField());
        this.editor = new FileTextFieldValueEditor(valueName, defaultLocation);
        this.fileDescriptor = fileChooserDescriptor.withFileFilter(virtualFile -> this.validateFile(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile)));
        this.installPathCompletion(this.fileDescriptor);
        this.addActionListener(e -> {
            VirtualFile chosenFile;
            File file = null;
            String text = this.getTextField().getText();
            if (text != null && !text.isEmpty()) {
                try {
                    file = this.parseTextToFile(text);
                }
                catch (InvalidDataException ignored) {
                    file = new File(text);
                }
            }
            if (file == null) {
                file = this.getDefaultLocation();
            }
            if ((chosenFile = FileChooser.chooseFile((FileChooserDescriptor)this.fileDescriptor, null, (VirtualFile)VfsUtil.findFileByIoFile((File)file, (boolean)true))) != null) {
                this.getTextField().setText(this.fileToTextValue(VfsUtilCore.virtualToIoFile((VirtualFile)chosenFile)));
            }
        });
    }

    @NotNull
    protected File getDefaultLocation() {
        File file = OpenOcdConfigurationEditor.USER_HOME;
        if (file == null) {
            FileChooseInput.$$$reportNull$$$0(2);
        }
        return file;
    }

    @Nullable
    protected String fileToTextValue(@NotNull File file) {
        if (file == null) {
            FileChooseInput.$$$reportNull$$$0(3);
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    protected abstract boolean validateFile(@NotNull File var1);

    @Nullable
    @NlsSafe
    public String getValueName() {
        return this.editor.getValueName();
    }

    @NotNull
    protected File parseTextToFile(@Nullable String text) {
        File file;
        File file2 = file = text == null ? (File)this.editor.getDefaultValue() : new File(text);
        if (!this.validateFile(file)) {
            throw new InvalidDataException("is invalid");
        }
        File file3 = file;
        if (file3 == null) {
            FileChooseInput.$$$reportNull$$$0(4);
        }
        return file3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/ui/FileChooseInput";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/ui/FileChooseInput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextToFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileToTextValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private class FileTextFieldValueEditor
    extends TextFieldValueEditor<File> {
        FileTextFieldValueEditor(@NotNull String valueName, File defaultLocation) {
            if (defaultLocation == null) {
                FileTextFieldValueEditor.$$$reportNull$$$0(0);
            }
            super(FileChooseInput.this.getTextField(), valueName, (Object)defaultLocation);
        }

        @NotNull
        public File parseValue(@Nullable String text) {
            File file = FileChooseInput.this.parseTextToFile(text);
            if (file == null) {
                FileTextFieldValueEditor.$$$reportNull$$$0(1);
            }
            return file;
        }

        @NotNull
        public String valueToString(@NotNull File value) {
            if (value == null) {
                FileTextFieldValueEditor.$$$reportNull$$$0(2);
            }
            String string = value.getPath();
            if (string == null) {
                FileTextFieldValueEditor.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isValid(@NotNull File file) {
            if (file == null) {
                FileTextFieldValueEditor.$$$reportNull$$$0(4);
            }
            return FileChooseInput.this.validateFile(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultLocation";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/clion/embedded/execution/ui/FileChooseInput$FileTextFieldValueEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/clion/embedded/execution/ui/FileChooseInput$FileTextFieldValueEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "valueToString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "valueToString";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class BoardCfg
    extends FileChooseInput {
        @NotNull
        private final Supplier<String> openOcdLocation;

        public BoardCfg(@Nullable String valueName, @NotNull File defaultLocation, @NotNull Supplier<String> openOcdLocation) {
            if (defaultLocation == null) {
                BoardCfg.$$$reportNull$$$0(0);
            }
            if (openOcdLocation == null) {
                BoardCfg.$$$reportNull$$$0(1);
            }
            super(valueName, defaultLocation, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            this.openOcdLocation = openOcdLocation;
        }

        @Override
        @NotNull
        protected File getDefaultLocation() {
            File ocdScripts = this.findOcdScripts();
            File ocdBoards = new File(ocdScripts, FileChooseInput.BOARD_FOLDER);
            if (!ocdBoards.exists()) {
                File file = ocdBoards;
                if (file == null) {
                    BoardCfg.$$$reportNull$$$0(2);
                }
                return file;
            }
            File file = super.getDefaultLocation();
            if (file == null) {
                BoardCfg.$$$reportNull$$$0(3);
            }
            return file;
        }

        @Override
        @NotNull
        protected File parseTextToFile(@Nullable String text) {
            File file;
            if (text == null) {
                file = (File)this.editor.getDefaultValue();
            } else {
                file = new File(text);
                if (!file.exists()) {
                    file = new File(this.findOcdScripts(), text);
                }
            }
            if (!file.exists() || !this.validateFile(file)) {
                throw new InvalidDataException("is invalid");
            }
            File file2 = file;
            if (file2 == null) {
                BoardCfg.$$$reportNull$$$0(4);
            }
            return file2;
        }

        @Override
        protected boolean validateFile(@NotNull File file) {
            if (file == null) {
                BoardCfg.$$$reportNull$$$0(5);
            }
            return file.exists() && !file.isDirectory();
        }

        @Override
        @Nullable
        protected String fileToTextValue(@NotNull File file) {
            String relativePath;
            File ocdScripts;
            if (file == null) {
                BoardCfg.$$$reportNull$$$0(6);
            }
            if (FileUtil.isAncestor((File)(ocdScripts = this.findOcdScripts()), (File)file, (boolean)true) && (relativePath = FileUtil.getRelativePath((File)ocdScripts, (File)file)) != null) {
                return relativePath;
            }
            return super.fileToTextValue(file);
        }

        @NotNull
        private File findOcdScripts() {
            File file = OpenOcdConfiguration.findOcdScripts(new File(this.openOcdLocation.get()));
            if (file == null) {
                BoardCfg.$$$reportNull$$$0(7);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultLocation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openOcdLocation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/clion/embedded/execution/ui/FileChooseInput$BoardCfg";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/clion/embedded/execution/ui/FileChooseInput$BoardCfg";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultLocation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseTextToFile";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOcdScripts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "validateFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fileToTextValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 7 -> new IllegalStateException(string);
            };
        }
    }
}

