/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.zephyr;

import com.intellij.CommonBundle;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.GdbRtosSupportKt;
import com.intellij.clion.embedded.execution.rtos.zephyr.ZephyrConfig;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002\u001a\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"isZephyrConfigurationComplete", "", "project", "Lcom/intellij/openapi/project/Project;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "collectErrors", "", "config", "Lcom/intellij/clion/embedded/execution/rtos/zephyr/ZephyrConfig;", "messageBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "showErrorNotification", "warningMessage", "", "intellij.clion.embedded"})
public final class ZephyrUtilsKt {
    public static final boolean isZephyrConfigurationComplete(@NotNull Project project, @NotNull DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        String string = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_config()");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        ZephyrConfig zephyrConfig = GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(string, ZephyrConfig.Companion.serializer());
        if (zephyrConfig == null) {
            zephyrConfig = new ZephyrConfig(false, false, 3, null);
        }
        ZephyrConfig config = zephyrConfig;
        StringBuilder messageBuilder = new StringBuilder();
        ZephyrUtilsKt.collectErrors(config, messageBuilder);
        if (!StringsKt.isBlank((CharSequence)messageBuilder)) {
            String string2 = messageBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            ZephyrUtilsKt.showErrorNotification(project, string2);
            return false;
        }
        return true;
    }

    private static final void collectErrors(ZephyrConfig config, StringBuilder messageBuilder) {
        if (!config.getConfigThreadName()) {
            messageBuilder.append(EmbeddedBundle.message("rtos.zephyr.thread.name.missing", new Object[0])).append('\n');
        }
        if (!config.getConfigThreadMonitor()) {
            messageBuilder.append(EmbeddedBundle.message("rtos.zephyr.thread.monitor.missing", new Object[0])).append('\n');
        }
    }

    private static final void showErrorNotification(Project project, @Nls String warningMessage) {
        Notification noDataFoundNotification = new Notification("Embedded Development", EmbeddedBundle.message("rtos.zephyr.integration.error", new Object[0]), warningMessage, NotificationType.ERROR);
        noDataFoundNotification.addAction((AnAction)DumbAwareAction.create((String)CommonBundle.message((String)"action.help", (Object[])new Object[0]), arg_0 -> ZephyrUtilsKt.showErrorNotification$lambda$1(ZephyrUtilsKt::showErrorNotification$lambda$0, arg_0)));
        Notifications.Bus.notify((Notification)noDataFoundNotification, (Project)project);
    }

    private static final Unit showErrorNotification$lambda$0(AnActionEvent it) {
        HelpManager.getInstance().invokeHelp("rtos.tasksview");
        return Unit.INSTANCE;
    }

    private static final void showErrorNotification$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

