/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.PrintWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData;", "", "queueName", "", "itemNumber", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "parts", "", "", "<init>", "(Ljava/lang/String;ILcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/util/List;)V", "getQueueName", "()Ljava/lang/String;", "getItemNumber", "()I", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getParts", "()Ljava/util/List;", "toString", "link", "Lcom/intellij/xdebugger/frame/XDebuggerTreeNodeHyperlink;", "getLink", "()Lcom/intellij/xdebugger/frame/XDebuggerTreeNodeHyperlink;", "setLink", "(Lcom/intellij/xdebugger/frame/XDebuggerTreeNodeHyperlink;)V", "exportCsv", "", "writer", "Ljava/io/PrintWriter;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "Companion", "intellij.clion.embedded"})
public final class QueueData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String queueName;
    private final int itemNumber;
    @NotNull
    private final Address address;
    @NotNull
    private final List<Long> parts;
    @Nullable
    private XDebuggerTreeNodeHyperlink link;
    @NotNull
    private static final String[] columnNames;

    public QueueData(@NotNull String queueName, int itemNumber, @NotNull Address address, @NotNull List<Long> parts) {
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.queueName = queueName;
        this.itemNumber = itemNumber;
        this.address = address;
        this.parts = parts;
    }

    @NotNull
    public final String getQueueName() {
        return this.queueName;
    }

    public final int getItemNumber() {
        return this.itemNumber;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @NotNull
    public final List<Long> getParts() {
        return this.parts;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.itemNumber);
    }

    @Nullable
    public final XDebuggerTreeNodeHyperlink getLink() {
        return this.link;
    }

    public final void setLink(@Nullable XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink) {
        this.link = xDebuggerTreeNodeHyperlink;
    }

    public final void exportCsv(@NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        String[] stringArray = new String[]{this.queueName, String.valueOf(this.itemNumber), FreeRtosDataManagerKt.to32BitString(this.address), this.parts.toString()};
        FreeRtosDataManagerKt.writeCsv(writer, stringArray);
    }

    @NotNull
    public final String component1() {
        return this.queueName;
    }

    public final int component2() {
        return this.itemNumber;
    }

    @NotNull
    public final Address component3() {
        return this.address;
    }

    @NotNull
    public final List<Long> component4() {
        return this.parts;
    }

    @NotNull
    public final QueueData copy(@NotNull String queueName, int itemNumber, @NotNull Address address, @NotNull List<Long> parts) {
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        return new QueueData(queueName, itemNumber, address, parts);
    }

    public static /* synthetic */ QueueData copy$default(QueueData queueData, String string, int n, Address address, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = queueData.queueName;
        }
        if ((n2 & 2) != 0) {
            n = queueData.itemNumber;
        }
        if ((n2 & 4) != 0) {
            address = queueData.address;
        }
        if ((n2 & 8) != 0) {
            list = queueData.parts;
        }
        return queueData.copy(string, n, address, list);
    }

    public int hashCode() {
        int result = this.queueName.hashCode();
        result = result * 31 + Integer.hashCode(this.itemNumber);
        result = result * 31 + this.address.hashCode();
        result = result * 31 + ((Object)this.parts).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueData)) {
            return false;
        }
        QueueData queueData = (QueueData)other;
        if (!Intrinsics.areEqual((Object)this.queueName, (Object)queueData.queueName)) {
            return false;
        }
        if (this.itemNumber != queueData.itemNumber) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.address, (Object)queueData.address)) {
            return false;
        }
        return Intrinsics.areEqual(this.parts, queueData.parts);
    }

    static {
        String[] stringArray = new String[]{"Queue Name", "Order Number", "Address", "Data"};
        columnNames = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData$Companion;", "", "<init>", "()V", "columnNames", "", "", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getColumnNames() {
            return columnNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

