/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManager;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosQueueComponentKt;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosUtilsKt;
import com.intellij.clion.embedded.execution.rtos.freertos.GotoAddressOnClickListener;
import com.intellij.clion.embedded.execution.rtos.freertos.Queue;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueAddressColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueData;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueDataAddressColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueDataNumber;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueDataValueColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueItemSizeColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueLengthColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueNameColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueRxColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueTreeNode;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueTxColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueTypeColumn;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0001:\u0002\u0015\u0016BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent;", "Lcom/intellij/ui/components/JBPanel;", "queueTableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "queueTreeTableView", "Lcom/intellij/ui/dualView/TreeTableView;", "queueDataTableView", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData;", "dataGetter", "Lkotlin/Function0;", "", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Queue;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;Lcom/intellij/ui/dualView/TreeTableView;Lcom/intellij/ui/table/TableView;Lkotlin/jvm/functions/Function0;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myDetailsSplitter", "Lcom/intellij/ui/JBSplitter;", "update", "", "QueueDataLink", "Companion", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nFreeRtosQueueComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeRtosQueueComponent.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1869#2,2:208\n1869#2:210\n1869#2,2:211\n1870#2:213\n*S KotlinDebug\n*F\n+ 1 FreeRtosQueueComponent.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent\n*L\n65#1:208,2\n74#1:210\n75#1:211,2\n74#1:213\n*E\n"})
public final class FreeRtosQueueComponent
extends JBPanel<JBPanel<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListTreeTableModelOnColumns queueTableModel;
    @NotNull
    private final TreeTableView queueTreeTableView;
    @NotNull
    private final TableView<QueueData> queueDataTableView;
    @NotNull
    private final Function0<List<Queue>> dataGetter;
    @NotNull
    private final CidrDebugProcess debugProcess;
    @NotNull
    private final JBSplitter myDetailsSplitter;

    private FreeRtosQueueComponent(ListTreeTableModelOnColumns queueTableModel, TreeTableView queueTreeTableView, TableView<QueueData> queueDataTableView, Function0<? extends List<Queue>> dataGetter, CidrDebugProcess debugProcess) {
        this.queueTableModel = queueTableModel;
        this.queueTreeTableView = queueTreeTableView;
        this.queueDataTableView = queueDataTableView;
        this.dataGetter = dataGetter;
        this.debugProcess = debugProcess;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.queueTreeTableView));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane queuePane = jScrollPane;
        JScrollPane jScrollPane2 = ScrollPaneFactory.createScrollPane((Component)((Component)this.queueDataTableView));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"createScrollPane(...)");
        JScrollPane queueDataPane = jScrollPane2;
        this.myDetailsSplitter = (JBSplitter)new OnePixelSplitter(true, "clion.embedded.freertos.splitter.proportion", 0.7f);
        ((OnePixelSplitter)this.myDetailsSplitter).setFirstComponent((JComponent)queuePane);
        ((OnePixelSplitter)this.myDetailsSplitter).setSecondComponent((JComponent)queueDataPane);
        this.add((Component)new JBLabel(EmbeddedBundle.message("freertos.queue.table.name", new Object[0])));
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add((Component)this.myDetailsSplitter);
    }

    public final void update() {
        Queue it;
        List items = (List)this.dataGetter.invoke();
        Object object = this.queueTableModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        root.removeAllChildren();
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Queue)element$iv;
            boolean bl = false;
            QueueTreeNode queueNode = FreeRtosQueueComponentKt.toTreeNode(it);
            root.add(queueNode);
            String string = EmbeddedBundle.message("freertos.queue.table.head.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            queueNode.add(new QueueTreeNode(it, string, it.getHead(), null, null, null, null, null, null, null, 1016, null));
            String string2 = EmbeddedBundle.message("freertos.queue.table.tail.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            queueNode.add(new QueueTreeNode(it, string2, it.getTail(), null, null, null, null, null, null, null, 1016, null));
            String string3 = EmbeddedBundle.message("freertos.queue.table.read.from.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            queueNode.add(new QueueTreeNode(it, string3, it.getReadFrom(), null, null, null, null, null, null, null, 1016, null));
            String string4 = EmbeddedBundle.message("freertos.queue.table.write.to.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            queueNode.add(new QueueTreeNode(it, string4, it.getWriteTo(), null, null, null, null, null, null, null, 1016, null));
        }
        this.queueTableModel.reload();
        $this$forEach$iv = items;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Queue)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getData();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                QueueData d = (QueueData)element$iv2;
                boolean bl2 = false;
                if (d.getParts().size() <= 1) continue;
                d.setLink(new QueueDataLink(d));
            }
        }
    }

    public /* synthetic */ FreeRtosQueueComponent(ListTreeTableModelOnColumns queueTableModel, TreeTableView queueTreeTableView, TableView queueDataTableView, Function0 dataGetter, CidrDebugProcess debugProcess, DefaultConstructorMarker $constructor_marker) {
        this(queueTableModel, queueTreeTableView, (TableView<QueueData>)queueDataTableView, (Function0<? extends List<Queue>>)dataGetter, debugProcess);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "dataManager", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FreeRtosQueueComponent create(@NotNull CidrDebugProcess process2, @NotNull FreeRtosDataManager dataManager) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TreeColumnInfo(""), QueueNameColumn.INSTANCE, QueueTypeColumn.INSTANCE, QueueAddressColumn.INSTANCE, QueueLengthColumn.INSTANCE, QueueItemSizeColumn.INSTANCE, QueueRxColumn.INSTANCE, QueueTxColumn.INSTANCE};
            ListTreeTableModelOnColumns queueTableModel = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), columnInfoArray);
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[]{QueueDataNumber.INSTANCE, QueueDataAddressColumn.INSTANCE, QueueDataValueColumn.INSTANCE};
            ListTableModel queueDataModel = new ListTableModel(columnInfoArray2);
            TreeTableView queueTreeTableView = FreeRtosUtilsKt.createDefaultTreeTableView(queueTableModel);
            if (!dataManager.getConfig().getQueueRegistryEnabled()) {
                queueTreeTableView.getEmptyText().appendLine(EmbeddedBundle.message("freertos.queue.enable.text", new Object[0]));
            }
            queueTreeTableView.getSelectionModel().addListSelectionListener(arg_0 -> Companion.create$lambda$0(queueTreeTableView, queueDataModel, arg_0));
            TableView queueDataTableView = FreeRtosUtilsKt.createDefaultTableView(queueDataModel);
            new GotoAddressOnClickListener(queueTreeTableView, process2, 3, (Function1<? super DefaultMutableTreeNode, Address>)((Function1)Companion::create$lambda$1)).installOn((Component)queueTreeTableView);
            new ClickListener(queueDataTableView){
                final /* synthetic */ TableView<QueueData> $queueDataTableView;
                {
                    this.$queueDataTableView = $queueDataTableView;
                }

                public boolean onClick(MouseEvent event, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    int clickedColumnNumber = this.$queueDataTableView.columnAtPoint(event.getPoint());
                    if (this.$queueDataTableView.getColumnModel().getColumn(clickedColumnNumber).getModelIndex() == 2) {
                        QueueData queueData = (QueueData)this.$queueDataTableView.getSelectedObject();
                        if (queueData != null && (queueData = queueData.getLink()) != null) {
                            queueData.onClick(event);
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
            }.installOn((Component)queueDataTableView);
            return new FreeRtosQueueComponent(queueTableModel, queueTreeTableView, queueDataTableView, () -> Companion.create$lambda$2(dataManager), process2, null);
        }

        private static final void create$lambda$0(TreeTableView $queueTreeTableView, ListTableModel $queueDataModel, ListSelectionEvent it) {
            List list = $queueTreeTableView.getSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelection(...)");
            Object object = CollectionsKt.firstOrNull((List)list);
            QueueTreeNode queueTreeNode = object instanceof QueueTreeNode ? (QueueTreeNode)object : null;
            if (queueTreeNode == null) {
                return;
            }
            QueueTreeNode node = queueTreeNode;
            if (node.getUserObject() instanceof Queue) {
                Object object2 = node.getUserObject();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.rtos.freertos.Queue");
                $queueDataModel.setItems(((Queue)object2).getData());
            }
        }

        private static final Address create$lambda$1(DefaultMutableTreeNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((QueueTreeNode)it).getAddress();
        }

        private static final List create$lambda$2(FreeRtosDataManager $dataManager) {
            return $dataManager.getQueueData();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent$QueueDataLink;", "Lcom/intellij/xdebugger/frame/XDebuggerTreeNodeHyperlink;", "data", "Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData;", "<init>", "(Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosQueueComponent;Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData;)V", "getData", "()Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueData;", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.clion.embedded"})
    public final class QueueDataLink
    extends XDebuggerTreeNodeHyperlink {
        @NotNull
        private final QueueData data;

        public QueueDataLink(QueueData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(EmbeddedBundle.message("queue.data.text.double.click.to.see.more", new Object[0]));
            this.data = data;
        }

        @NotNull
        public final QueueData getData() {
            return this.data;
        }

        public void onClick(@Nullable MouseEvent event) {
            int n;
            List list = FreeRtosQueueComponent.this.queueTreeTableView.getSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelection(...)");
            Object object = CollectionsKt.firstOrNull((List)list);
            QueueTreeNode queueTreeNode = object instanceof QueueTreeNode ? (QueueTreeNode)object : null;
            if (queueTreeNode == null) {
                return;
            }
            QueueTreeNode node = queueTreeNode;
            if (node.getUserObject() instanceof Queue) {
                Object object2 = node.getUserObject();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.rtos.freertos.Queue");
                n = ((Queue)object2).getDataItemSize();
            } else {
                n = 4 * this.data.getParts().size();
            }
            int size = n;
            FreeRtosDataManagerKt.showMemoryRange(FreeRtosQueueComponent.this.debugProcess, AddressUtil.toRange((Address)this.data.getAddress(), (Number)size));
        }
    }
}

