/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.intellij.clion.embedded.execution.rtos.RtosType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/RtosUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "RTOS_TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/clion/embedded/execution/rtos/RtosType;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "RTOS_SETTINGS_CHANGED", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "getRTOS_SETTINGS_CHANGED", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "TRY_TO_DETECT_RTOS", "", "RTOS_DETECTED", "logTryDetectRtos", "", "project", "Lcom/intellij/openapi/project/Project;", "type", "logRtosDetected", "intellij.clion.embedded"})
public final class RtosUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RtosUsagesCollector INSTANCE = new RtosUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.embedded.rtos", 4, null, 4, null);
    @NotNull
    private static final EnumEventField<RtosType> RTOS_TYPE_FIELD = EventFields.Enum$default((String)"type", RtosType.class, null, (int)4, null);
    @NotNull
    private static final AtomicInteger counter = new AtomicInteger(0);
    @NotNull
    private static final EventId2<Boolean, RtosType> RTOS_SETTINGS_CHANGED = GROUP.registerEvent("settings.changed", (EventField)EventFields.Enabled, (EventField)RTOS_TYPE_FIELD);
    @NotNull
    private static final EventId2<Integer, RtosType> TRY_TO_DETECT_RTOS = GROUP.registerEvent("debug.try.detect", (EventField)EventFields.Int((String)"id"), (EventField)RTOS_TYPE_FIELD);
    @NotNull
    private static final EventId2<Integer, RtosType> RTOS_DETECTED = GROUP.registerEvent("debug.started", (EventField)EventFields.Int((String)"id"), (EventField)RTOS_TYPE_FIELD);

    private RtosUsagesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final EventId2<Boolean, RtosType> getRTOS_SETTINGS_CHANGED() {
        return RTOS_SETTINGS_CHANGED;
    }

    public final void logTryDetectRtos(@NotNull Project project, @NotNull RtosType type) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        TRY_TO_DETECT_RTOS.log(project, (Object)counter.incrementAndGet(), (Object)type);
    }

    public final void logRtosDetected(@NotNull Project project, @NotNull RtosType type) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        RTOS_DETECTED.log(project, (Object)counter.get(), (Object)type);
    }
}

