/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesItemKt;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/NumberStringValue;", "", "number", "", "text", "", "<init>", "(Ljava/lang/Number;Ljava/lang/String;)V", "numberText", "(Ljava/lang/String;Ljava/lang/String;)V", "getNumber", "()Ljava/lang/Number;", "getText", "()Ljava/lang/String;", "compare", "", "a", "b", "toString", "isFinite", "", "min", "other", "max", "intellij.clion.embedded"})
public class NumberStringValue {
    @NotNull
    private final Number number;
    @NotNull
    private final String text;

    public NumberStringValue(@NotNull Number number, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.number = number;
        this.text = text;
    }

    @NotNull
    public final Number getNumber() {
        return this.number;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public NumberStringValue(@NotNull String text, @NotNull String numberText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)numberText, (String)"numberText");
        this(LiveWatchesItemKt.access$parseNumber(numberText), text);
    }

    private final int compare(Number a, Number b) {
        Number number = a;
        if (number instanceof Long) {
            Number number2 = b;
            if (number2 instanceof BigInteger) {
                BigInteger bigInteger = BigInteger.valueOf(a.longValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger.compareTo((BigInteger)b);
            }
            if (number2 instanceof Double) {
                return Double.compare(a.doubleValue(), b.doubleValue());
            }
            return Intrinsics.compare((long)a.longValue(), (long)b.longValue());
        }
        if (number instanceof BigInteger) {
            Number number3 = b;
            if (number3 instanceof BigInteger) {
                return ((BigInteger)a).compareTo((BigInteger)b);
            }
            if (number3 instanceof Long) {
                BigInteger bigInteger = (BigInteger)a;
                BigInteger bigInteger2 = BigInteger.valueOf(b.longValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                return bigInteger.compareTo(bigInteger2);
            }
            return new BigDecimal((BigInteger)a).compareTo(new BigDecimal(String.valueOf(b.doubleValue())));
        }
        if (number instanceof Double) {
            Number number4 = b;
            if (number4 instanceof Double) {
                return Double.compare(a.doubleValue(), b.doubleValue());
            }
            if (number4 instanceof BigInteger) {
                new BigDecimal(String.valueOf(a.doubleValue())).compareTo(new BigDecimal((BigInteger)b));
            } else {
                return Double.compare(a.doubleValue(), b.longValue());
            }
        }
        return this.compare(a.doubleValue(), b.doubleValue());
    }

    @NotNull
    public String toString() {
        return this.text + " [" + this.number + "]";
    }

    public final boolean isFinite() {
        Number number = this.number;
        Double d = number instanceof Double ? (Double)number : null;
        return !(d != null ? !(Math.abs(d) <= Double.MAX_VALUE) : false);
    }

    @NotNull
    public NumberStringValue min(@NotNull NumberStringValue other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compare(this.number, other.number) <= 0 ? this : other;
    }

    @NotNull
    public NumberStringValue max(@NotNull NumberStringValue other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compare(this.number, other.number) >= 0 ? this : other;
    }
}

