/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.debugtargets.live;

import com.intellij.clion.embedded.execution.debugtargets.DebugTargetProcess;
import com.intellij.clion.embedded.execution.debugtargets.live.LiveWatchesSubProcessKt;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetData;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00060\u0017R\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J \u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0016J\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010)\u001a\u0004\u0018\u00010*R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/clion/embedded/execution/debugtargets/live/LiveWatchesSubProcess;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "parameters", "Lcom/jetbrains/cidr/execution/RunParameters;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "debugTargetData", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetData;", "connectionCommands", "", "", "parentProcess", "Lcom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/RunParameters;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/execution/filters/TextConsoleBuilder;Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetData;Ljava/util/List;Lcom/intellij/clion/embedded/execution/debugtargets/DebugTargetProcess;)V", "startupTime", "", "elapsedTime", "sessionInitialized", "", "doLoadTarget", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Inferior;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "driver", "ready", "Ljava/util/concurrent/atomic/AtomicBoolean;", "fakeThread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "fakeFrame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "handleSignal", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "signal", "meaning", "resume", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "handleInterrupted", "fakeStackFrameEvaluatorIfReady", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "intellij.clion.embedded"})
public final class LiveWatchesSubProcess
extends CidrDebugProcess {
    @NotNull
    private final DebugTargetData debugTargetData;
    @NotNull
    private final List<String> connectionCommands;
    private final long startupTime;
    @NotNull
    private final AtomicBoolean ready;
    @NotNull
    private final LLThread fakeThread;
    @NotNull
    private final LLFrame fakeFrame;

    public LiveWatchesSubProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull DebugTargetData debugTargetData, @NotNull List<String> connectionCommands, @NotNull DebugTargetProcess parentProcess) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        Intrinsics.checkNotNullParameter((Object)debugTargetData, (String)"debugTargetData");
        Intrinsics.checkNotNullParameter(connectionCommands, (String)"connectionCommands");
        Intrinsics.checkNotNullParameter((Object)((Object)parentProcess), (String)"parentProcess");
        super(LiveWatchesSubProcessKt.access$subProcessRunParameters(parameters), session, consoleBuilder);
        this.debugTargetData = debugTargetData;
        this.connectionCommands = connectionCommands;
        Disposer.register((Disposable)parentProcess.getUiDisposable(), (Disposable)this.getUiDisposable());
        Disposer.register((Disposable)this.getUiDisposable(), (Disposable)((Disposable)this.myConsole));
        Disposer.register((Disposable)parentProcess.getProcessDisposable(), () -> LiveWatchesSubProcess._init_$lambda$0(session));
        this.startupTime = System.currentTimeMillis();
        this.ready = new AtomicBoolean(false);
        this.fakeThread = new LLThread(-1L, null, null, null, null);
        this.fakeFrame = new LLFrame(-1, "nowhere", null, null, 1, Address.Companion.fromUnsignedLong(0L), null, true, true, null);
    }

    public final long elapsedTime() {
        return System.currentTimeMillis() - this.startupTime;
    }

    public void sessionInitialized() {
        this.startProcessingDriverEvents();
        super.postCommand((CidrDebugProcess.VoidDebuggerCommand)((CidrDebugProcess.DebuggerStartupCommand)arg_0 -> LiveWatchesSubProcess.sessionInitialized$lambda$0(this, arg_0)));
    }

    @NotNull
    protected DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        DebuggerDriver.Inferior inferior = ((GDBDriver)driver).loadForRemote(this.connectionCommands, this.debugTargetData.getName() + "#live", this.debugTargetData.getBinaryFile(), null, CollectionsKt.emptyList(), false);
        Intrinsics.checkNotNullExpressionValue((Object)inferior, (String)"loadForRemote(...)");
        return inferior;
    }

    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        Intrinsics.checkNotNullParameter((Object)meaning, (String)"meaning");
        super.handleSignal(stopPlace, signal, meaning);
        this.ready.set(true);
    }

    public void resume(@Nullable XSuspendContext context) {
        super.resume(context);
        this.ready.set(false);
    }

    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        super.handleInterrupted(stopPlace);
        this.ready.set(true);
    }

    @Nullable
    public final CidrEvaluator fakeStackFrameEvaluatorIfReady() {
        if (!this.ready.get()) {
            return null;
        }
        CidrStackFrame cidrStackFrame = this.newExecutionStack(this.fakeThread, this.fakeFrame, true, null, null).getTopFrame();
        return cidrStackFrame != null ? cidrStackFrame.getEvaluator() : null;
    }

    private static final void _init_$lambda$0(XDebugSession $session) {
        $session.stop();
    }

    private static final void sessionInitialized$lambda$0(LiveWatchesSubProcess this$0, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (this$0.myState != CidrDebugProcess.State.STARTED) {
            return;
        }
        this$0.doStartTarget(this$0.getInferior());
    }
}

